/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf;

import java.nio.ByteBuffer;
import org.apache.hbase.thirdparty.com.google.protobuf.Android;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteInput;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeUtil;

final class Utf8 {
    private static final Processor processor = UnsafeProcessor.isAvailable() && !Android.isOnAndroidDevice() ? new UnsafeProcessor() : new SafeProcessor();
    private static final long ASCII_MASK_LONG = -9187201950435737472L;
    static final int MAX_BYTES_PER_CHAR = 3;
    public static final int COMPLETE = 0;
    public static final int MALFORMED = -1;
    private static final int UNSAFE_COUNT_ASCII_THRESHOLD = 16;

    public static boolean isValidUtf8(byte[] bytes2) {
        return processor.isValidUtf8(bytes2, 0, bytes2.length);
    }

    public static boolean isValidUtf8(byte[] bytes2, int index2, int limit2) {
        return processor.isValidUtf8(bytes2, index2, limit2);
    }

    public static int partialIsValidUtf8(int state, byte[] bytes2, int index2, int limit2) {
        return processor.partialIsValidUtf8(state, bytes2, index2, limit2);
    }

    private static int incompleteStateFor(int byte1) {
        return byte1 > -12 ? -1 : byte1;
    }

    private static int incompleteStateFor(int byte1, int byte2) {
        return byte1 > -12 || byte2 > -65 ? -1 : byte1 ^ byte2 << 8;
    }

    private static int incompleteStateFor(int byte1, int byte2, int byte3) {
        return byte1 > -12 || byte2 > -65 || byte3 > -65 ? -1 : byte1 ^ byte2 << 8 ^ byte3 << 16;
    }

    private static int incompleteStateFor(byte[] bytes2, int index2, int limit2) {
        byte byte1 = bytes2[index2 - 1];
        switch (limit2 - index2) {
            case 0: {
                return Utf8.incompleteStateFor(byte1);
            }
            case 1: {
                return Utf8.incompleteStateFor(byte1, bytes2[index2]);
            }
            case 2: {
                return Utf8.incompleteStateFor(byte1, (int)bytes2[index2], (int)bytes2[index2 + 1]);
            }
        }
        throw new AssertionError();
    }

    private static int incompleteStateFor(ByteBuffer buffer, int byte1, int index2, int remaining) {
        switch (remaining) {
            case 0: {
                return Utf8.incompleteStateFor(byte1);
            }
            case 1: {
                return Utf8.incompleteStateFor(byte1, buffer.get(index2));
            }
            case 2: {
                return Utf8.incompleteStateFor(byte1, (int)buffer.get(index2), (int)buffer.get(index2 + 1));
            }
        }
        throw new AssertionError();
    }

    private static int incompleteStateFor(ByteInput bytes2, int index2, int limit2) {
        byte byte1 = bytes2.read(index2 - 1);
        switch (limit2 - index2) {
            case 0: {
                return Utf8.incompleteStateFor(byte1);
            }
            case 1: {
                return Utf8.incompleteStateFor(byte1, bytes2.read(index2));
            }
            case 2: {
                return Utf8.incompleteStateFor(byte1, (int)bytes2.read(index2), (int)bytes2.read(index2 + 1));
            }
        }
        throw new AssertionError();
    }

    static int encodedLength(CharSequence sequence) {
        int i2;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (i2 = 0; i2 < utf16Length && sequence.charAt(i2) < '\u0080'; ++i2) {
        }
        while (i2 < utf16Length) {
            char c = sequence.charAt(i2);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += Utf8.encodedLengthGeneral(sequence, i2);
                break;
            }
            ++i2;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start2) {
        int utf16Length = sequence.length();
        int utf8Length = 0;
        for (int i2 = start2; i2 < utf16Length; ++i2) {
            char c = sequence.charAt(i2);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
                continue;
            }
            utf8Length += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int cp = Character.codePointAt(sequence, i2);
            if (cp < 65536) {
                throw new UnpairedSurrogateException(i2, utf16Length);
            }
            ++i2;
        }
        return utf8Length;
    }

    static int encode(CharSequence in, byte[] out, int offset2, int length2) {
        return processor.encodeUtf8(in, out, offset2, length2);
    }

    static boolean isValidUtf8(ByteBuffer buffer) {
        return processor.isValidUtf8(buffer, buffer.position(), buffer.remaining());
    }

    static int partialIsValidUtf8(int state, ByteBuffer buffer, int index2, int limit2) {
        return processor.partialIsValidUtf8(state, buffer, index2, limit2);
    }

    static String decodeUtf8(ByteBuffer buffer, int index2, int size2) throws InvalidProtocolBufferException {
        return processor.decodeUtf8(buffer, index2, size2);
    }

    static String decodeUtf8(byte[] bytes2, int index2, int size2) throws InvalidProtocolBufferException {
        return processor.decodeUtf8(bytes2, index2, size2);
    }

    static boolean isValidUtf8(ByteInput buffer, int index2, int limit2) {
        return processor.isValidUtf8(buffer, index2, limit2);
    }

    static int partialIsValidUtf8(int state, ByteInput buffer, int index2, int limit2) {
        return processor.partialIsValidUtf8(state, buffer, index2, limit2);
    }

    static void encodeUtf8(CharSequence in, ByteBuffer out) {
        processor.encodeUtf8(in, out);
    }

    private static int estimateConsecutiveAscii(ByteBuffer buffer, int index2, int limit2) {
        int i2;
        int lim = limit2 - 7;
        for (i2 = index2; i2 < lim && (buffer.getLong(i2) & 0x8080808080808080L) == 0L; i2 += 8) {
        }
        return i2 - index2;
    }

    private Utf8() {
    }

    private static class DecodeUtil {
        private DecodeUtil() {
        }

        private static boolean isOneByte(byte b) {
            return b >= 0;
        }

        private static boolean isTwoBytes(byte b) {
            return b < -32;
        }

        private static boolean isThreeBytes(byte b) {
            return b < -16;
        }

        private static void handleOneByte(byte byte1, char[] resultArr, int resultPos) {
            resultArr[resultPos] = (char)byte1;
        }

        private static void handleTwoBytes(byte byte1, byte byte2, char[] resultArr, int resultPos) throws InvalidProtocolBufferException {
            if (byte1 < -62 || DecodeUtil.isNotTrailingByte(byte2)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            resultArr[resultPos] = (char)((byte1 & 0x1F) << 6 | DecodeUtil.trailingByteValue(byte2));
        }

        private static void handleThreeBytes(byte byte1, byte byte2, byte byte3, char[] resultArr, int resultPos) throws InvalidProtocolBufferException {
            if (DecodeUtil.isNotTrailingByte(byte2) || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || DecodeUtil.isNotTrailingByte(byte3)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            resultArr[resultPos] = (char)((byte1 & 0xF) << 12 | DecodeUtil.trailingByteValue(byte2) << 6 | DecodeUtil.trailingByteValue(byte3));
        }

        private static void handleFourBytes(byte byte1, byte byte2, byte byte3, byte byte4, char[] resultArr, int resultPos) throws InvalidProtocolBufferException {
            if (DecodeUtil.isNotTrailingByte(byte2) || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(byte3) || DecodeUtil.isNotTrailingByte(byte4)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            int codepoint = (byte1 & 7) << 18 | DecodeUtil.trailingByteValue(byte2) << 12 | DecodeUtil.trailingByteValue(byte3) << 6 | DecodeUtil.trailingByteValue(byte4);
            resultArr[resultPos] = DecodeUtil.highSurrogate(codepoint);
            resultArr[resultPos + 1] = DecodeUtil.lowSurrogate(codepoint);
        }

        private static boolean isNotTrailingByte(byte b) {
            return b > -65;
        }

        private static int trailingByteValue(byte b) {
            return b & 0x3F;
        }

        private static char highSurrogate(int codePoint) {
            return (char)(55232 + (codePoint >>> 10));
        }

        private static char lowSurrogate(int codePoint) {
            return (char)(56320 + (codePoint & 0x3FF));
        }
    }

    static final class UnsafeProcessor
    extends Processor {
        UnsafeProcessor() {
        }

        static boolean isAvailable() {
            return UnsafeUtil.hasUnsafeArrayOperations() && UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        @Override
        int partialIsValidUtf8(int state, byte[] bytes2, int index2, int limit2) {
            if ((index2 | limit2 | bytes2.length - limit2) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("Array length=%d, index=%d, limit=%d", bytes2.length, index2, limit2));
            }
            long offset2 = index2;
            long offsetLimit = limit2;
            if (state != 0) {
                if (offset2 >= offsetLimit) {
                    return state;
                }
                byte byte1 = (byte)state;
                if (byte1 < -32) {
                    if (byte1 < -62 || UnsafeUtil.getByte(bytes2, offset2++) > -65) {
                        return -1;
                    }
                } else if (byte1 < -16) {
                    byte byte2 = (byte)(~(state >> 8));
                    if (byte2 == 0) {
                        byte2 = UnsafeUtil.getByte(bytes2, offset2++);
                        if (offset2 >= offsetLimit) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    }
                    if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || UnsafeUtil.getByte(bytes2, offset2++) > -65) {
                        return -1;
                    }
                } else {
                    byte byte2 = (byte)(~(state >> 8));
                    byte byte3 = 0;
                    if (byte2 == 0) {
                        byte2 = UnsafeUtil.getByte(bytes2, offset2++);
                        if (offset2 >= offsetLimit) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    } else {
                        byte3 = (byte)(state >> 16);
                    }
                    if (byte3 == 0) {
                        byte3 = UnsafeUtil.getByte(bytes2, offset2++);
                        if (offset2 >= offsetLimit) {
                            return Utf8.incompleteStateFor(byte1, byte2, byte3);
                        }
                    }
                    if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || UnsafeUtil.getByte(bytes2, offset2++) > -65) {
                        return -1;
                    }
                }
            }
            return UnsafeProcessor.partialIsValidUtf8(bytes2, offset2, (int)(offsetLimit - offset2));
        }

        @Override
        int partialIsValidUtf8Direct(int state, ByteBuffer buffer, int index2, int limit2) {
            if ((index2 | limit2 | buffer.limit() - limit2) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", buffer.limit(), index2, limit2));
            }
            long address2 = UnsafeUtil.addressOffset(buffer) + (long)index2;
            long addressLimit = address2 + (long)(limit2 - index2);
            if (state != 0) {
                if (address2 >= addressLimit) {
                    return state;
                }
                byte byte1 = (byte)state;
                if (byte1 < -32) {
                    if (byte1 < -62 || UnsafeUtil.getByte(address2++) > -65) {
                        return -1;
                    }
                } else if (byte1 < -16) {
                    byte byte2 = (byte)(~(state >> 8));
                    if (byte2 == 0) {
                        byte2 = UnsafeUtil.getByte(address2++);
                        if (address2 >= addressLimit) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    }
                    if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || UnsafeUtil.getByte(address2++) > -65) {
                        return -1;
                    }
                } else {
                    byte byte2 = (byte)(~(state >> 8));
                    byte byte3 = 0;
                    if (byte2 == 0) {
                        byte2 = UnsafeUtil.getByte(address2++);
                        if (address2 >= addressLimit) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    } else {
                        byte3 = (byte)(state >> 16);
                    }
                    if (byte3 == 0) {
                        byte3 = UnsafeUtil.getByte(address2++);
                        if (address2 >= addressLimit) {
                            return Utf8.incompleteStateFor(byte1, byte2, byte3);
                        }
                    }
                    if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || UnsafeUtil.getByte(address2++) > -65) {
                        return -1;
                    }
                }
            }
            return UnsafeProcessor.partialIsValidUtf8(address2, (int)(addressLimit - address2));
        }

        @Override
        String decodeUtf8(byte[] bytes2, int index2, int size2) throws InvalidProtocolBufferException {
            byte b;
            int offset2;
            if ((index2 | size2 | bytes2.length - index2 - size2) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", bytes2.length, index2, size2));
            }
            int limit2 = offset2 + size2;
            char[] resultArr = new char[size2];
            int resultPos = 0;
            for (offset2 = index2; offset2 < limit2 && DecodeUtil.isOneByte(b = UnsafeUtil.getByte(bytes2, (long)offset2)); ++offset2) {
                DecodeUtil.handleOneByte(b, resultArr, resultPos++);
            }
            while (offset2 < limit2) {
                byte byte1;
                if (DecodeUtil.isOneByte(byte1 = UnsafeUtil.getByte(bytes2, (long)offset2++))) {
                    byte b2;
                    DecodeUtil.handleOneByte(byte1, resultArr, resultPos++);
                    while (offset2 < limit2 && DecodeUtil.isOneByte(b2 = UnsafeUtil.getByte(bytes2, (long)offset2))) {
                        ++offset2;
                        DecodeUtil.handleOneByte(b2, resultArr, resultPos++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(byte1)) {
                    if (offset2 >= limit2) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(byte1, UnsafeUtil.getByte(bytes2, (long)offset2++), resultArr, resultPos++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(byte1)) {
                    if (offset2 >= limit2 - 1) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(byte1, UnsafeUtil.getByte(bytes2, (long)offset2++), UnsafeUtil.getByte(bytes2, (long)offset2++), resultArr, resultPos++);
                    continue;
                }
                if (offset2 >= limit2 - 2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(byte1, UnsafeUtil.getByte(bytes2, (long)offset2++), UnsafeUtil.getByte(bytes2, (long)offset2++), UnsafeUtil.getByte(bytes2, (long)offset2++), resultArr, resultPos++);
                ++resultPos;
            }
            return new String(resultArr, 0, resultPos);
        }

        @Override
        String decodeUtf8Direct(ByteBuffer buffer, int index2, int size2) throws InvalidProtocolBufferException {
            byte b;
            long address2;
            if ((index2 | size2 | buffer.limit() - index2 - size2) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", buffer.limit(), index2, size2));
            }
            long addressLimit = address2 + (long)size2;
            char[] resultArr = new char[size2];
            int resultPos = 0;
            for (address2 = UnsafeUtil.addressOffset(buffer) + (long)index2; address2 < addressLimit && DecodeUtil.isOneByte(b = UnsafeUtil.getByte(address2)); ++address2) {
                DecodeUtil.handleOneByte(b, resultArr, resultPos++);
            }
            while (address2 < addressLimit) {
                byte byte1;
                if (DecodeUtil.isOneByte(byte1 = UnsafeUtil.getByte(address2++))) {
                    byte b2;
                    DecodeUtil.handleOneByte(byte1, resultArr, resultPos++);
                    while (address2 < addressLimit && DecodeUtil.isOneByte(b2 = UnsafeUtil.getByte(address2))) {
                        ++address2;
                        DecodeUtil.handleOneByte(b2, resultArr, resultPos++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(byte1)) {
                    if (address2 >= addressLimit) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(byte1, UnsafeUtil.getByte(address2++), resultArr, resultPos++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(byte1)) {
                    if (address2 >= addressLimit - 1L) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(byte1, UnsafeUtil.getByte(address2++), UnsafeUtil.getByte(address2++), resultArr, resultPos++);
                    continue;
                }
                if (address2 >= addressLimit - 2L) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(byte1, UnsafeUtil.getByte(address2++), UnsafeUtil.getByte(address2++), UnsafeUtil.getByte(address2++), resultArr, resultPos++);
                ++resultPos;
            }
            return new String(resultArr, 0, resultPos);
        }

        @Override
        int encodeUtf8(CharSequence in, byte[] out, int offset2, int length2) {
            char c;
            int inIx;
            long outIx = offset2;
            long outLimit = outIx + (long)length2;
            int inLimit = in.length();
            if (inLimit > length2 || out.length - length2 < offset2) {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(inLimit - 1) + " at index " + (offset2 + length2));
            }
            for (inIx = 0; inIx < inLimit && (c = in.charAt(inIx)) < '\u0080'; ++inIx) {
                UnsafeUtil.putByte(out, outIx++, (byte)c);
            }
            if (inIx == inLimit) {
                return (int)outIx;
            }
            while (inIx < inLimit) {
                c = in.charAt(inIx);
                if (c < '\u0080' && outIx < outLimit) {
                    UnsafeUtil.putByte(out, outIx++, (byte)c);
                } else if (c < '\u0800' && outIx <= outLimit - 2L) {
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x3C0 | c >>> 6));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & c));
                } else if ((c < '\ud800' || '\udfff' < c) && outIx <= outLimit - 3L) {
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x1E0 | c >>> 12));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & c >>> 6));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & c));
                } else if (outIx <= outLimit - 4L) {
                    char low;
                    if (inIx + 1 == inLimit || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                        throw new UnpairedSurrogateException(inIx - 1, inLimit);
                    }
                    int codePoint = Character.toCodePoint(c, low);
                    UnsafeUtil.putByte(out, outIx++, (byte)(0xF0 | codePoint >>> 18));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                    UnsafeUtil.putByte(out, outIx++, (byte)(0x80 | 0x3F & codePoint));
                } else {
                    if (!('\ud800' > c || c > '\udfff' || inIx + 1 != inLimit && Character.isSurrogatePair(c, in.charAt(inIx + 1)))) {
                        throw new UnpairedSurrogateException(inIx, inLimit);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + outIx);
                }
                ++inIx;
            }
            return (int)outIx;
        }

        @Override
        void encodeUtf8Direct(CharSequence in, ByteBuffer out) {
            char c;
            int inIx;
            long address2 = UnsafeUtil.addressOffset(out);
            long outIx = address2 + (long)out.position();
            long outLimit = address2 + (long)out.limit();
            int inLimit = in.length();
            if ((long)inLimit > outLimit - outIx) {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(inLimit - 1) + " at index " + out.limit());
            }
            for (inIx = 0; inIx < inLimit && (c = in.charAt(inIx)) < '\u0080'; ++inIx) {
                UnsafeUtil.putByte(outIx++, (byte)c);
            }
            if (inIx == inLimit) {
                out.position((int)(outIx - address2));
                return;
            }
            while (inIx < inLimit) {
                c = in.charAt(inIx);
                if (c < '\u0080' && outIx < outLimit) {
                    UnsafeUtil.putByte(outIx++, (byte)c);
                } else if (c < '\u0800' && outIx <= outLimit - 2L) {
                    UnsafeUtil.putByte(outIx++, (byte)(0x3C0 | c >>> 6));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & c));
                } else if ((c < '\ud800' || '\udfff' < c) && outIx <= outLimit - 3L) {
                    UnsafeUtil.putByte(outIx++, (byte)(0x1E0 | c >>> 12));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & c >>> 6));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & c));
                } else if (outIx <= outLimit - 4L) {
                    char low;
                    if (inIx + 1 == inLimit || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                        throw new UnpairedSurrogateException(inIx - 1, inLimit);
                    }
                    int codePoint = Character.toCodePoint(c, low);
                    UnsafeUtil.putByte(outIx++, (byte)(0xF0 | codePoint >>> 18));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & codePoint));
                } else {
                    if (!('\ud800' > c || c > '\udfff' || inIx + 1 != inLimit && Character.isSurrogatePair(c, in.charAt(inIx + 1)))) {
                        throw new UnpairedSurrogateException(inIx, inLimit);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + outIx);
                }
                ++inIx;
            }
            out.position((int)(outIx - address2));
        }

        private static int unsafeEstimateConsecutiveAscii(byte[] bytes2, long offset2, int maxChars) {
            if (maxChars < 16) {
                return 0;
            }
            for (int i2 = 0; i2 < maxChars; ++i2) {
                if (UnsafeUtil.getByte(bytes2, offset2++) >= 0) continue;
                return i2;
            }
            return maxChars;
        }

        private static int unsafeEstimateConsecutiveAscii(long address2, int maxChars) {
            int unaligned;
            int remaining = maxChars;
            if (remaining < 16) {
                return 0;
            }
            for (int j = unaligned = 8 - ((int)address2 & 7); j > 0; --j) {
                if (UnsafeUtil.getByte(address2++) >= 0) continue;
                return unaligned - j;
            }
            remaining -= unaligned;
            while (remaining >= 8 && (UnsafeUtil.getLong(address2) & 0x8080808080808080L) == 0L) {
                address2 += 8L;
                remaining -= 8;
            }
            return maxChars - remaining;
        }

        private static int partialIsValidUtf8(byte[] bytes2, long offset2, int remaining) {
            int skipped = UnsafeProcessor.unsafeEstimateConsecutiveAscii(bytes2, offset2, remaining);
            remaining -= skipped;
            offset2 += (long)skipped;
            while (true) {
                byte byte2;
                int byte1 = 0;
                while (remaining > 0) {
                    byte by = UnsafeUtil.getByte(bytes2, offset2++);
                    byte1 = by;
                    if (by < 0) break;
                    --remaining;
                }
                if (remaining == 0) {
                    return 0;
                }
                --remaining;
                if (byte1 < -32) {
                    if (remaining == 0) {
                        return byte1;
                    }
                    --remaining;
                    if (byte1 >= -62 && UnsafeUtil.getByte(bytes2, offset2++) <= -65) continue;
                    return -1;
                }
                if (byte1 < -16) {
                    if (remaining < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(bytes2, byte1, offset2, remaining);
                    }
                    remaining -= 2;
                    if (!((byte2 = UnsafeUtil.getByte(bytes2, offset2++)) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96) && UnsafeUtil.getByte(bytes2, offset2++) <= -65) continue;
                    return -1;
                }
                if (remaining < 3) {
                    return UnsafeProcessor.unsafeIncompleteStateFor(bytes2, byte1, offset2, remaining);
                }
                remaining -= 3;
                if ((byte2 = UnsafeUtil.getByte(bytes2, offset2++)) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || UnsafeUtil.getByte(bytes2, offset2++) > -65 || UnsafeUtil.getByte(bytes2, offset2++) > -65) break;
            }
            return -1;
        }

        private static int partialIsValidUtf8(long address2, int remaining) {
            int skipped = UnsafeProcessor.unsafeEstimateConsecutiveAscii(address2, remaining);
            address2 += (long)skipped;
            remaining -= skipped;
            while (true) {
                byte byte2;
                int byte1 = 0;
                while (remaining > 0) {
                    byte by = UnsafeUtil.getByte(address2++);
                    byte1 = by;
                    if (by < 0) break;
                    --remaining;
                }
                if (remaining == 0) {
                    return 0;
                }
                --remaining;
                if (byte1 < -32) {
                    if (remaining == 0) {
                        return byte1;
                    }
                    --remaining;
                    if (byte1 >= -62 && UnsafeUtil.getByte(address2++) <= -65) continue;
                    return -1;
                }
                if (byte1 < -16) {
                    if (remaining < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(address2, byte1, remaining);
                    }
                    remaining -= 2;
                    if (!((byte2 = UnsafeUtil.getByte(address2++)) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96) && UnsafeUtil.getByte(address2++) <= -65) continue;
                    return -1;
                }
                if (remaining < 3) {
                    return UnsafeProcessor.unsafeIncompleteStateFor(address2, byte1, remaining);
                }
                remaining -= 3;
                if ((byte2 = UnsafeUtil.getByte(address2++)) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || UnsafeUtil.getByte(address2++) > -65 || UnsafeUtil.getByte(address2++) > -65) break;
            }
            return -1;
        }

        private static int unsafeIncompleteStateFor(byte[] bytes2, int byte1, long offset2, int remaining) {
            switch (remaining) {
                case 0: {
                    return Utf8.incompleteStateFor(byte1);
                }
                case 1: {
                    return Utf8.incompleteStateFor(byte1, UnsafeUtil.getByte(bytes2, offset2));
                }
                case 2: {
                    return Utf8.incompleteStateFor(byte1, UnsafeUtil.getByte(bytes2, offset2), UnsafeUtil.getByte(bytes2, offset2 + 1L));
                }
            }
            throw new AssertionError();
        }

        private static int unsafeIncompleteStateFor(long address2, int byte1, int remaining) {
            switch (remaining) {
                case 0: {
                    return Utf8.incompleteStateFor(byte1);
                }
                case 1: {
                    return Utf8.incompleteStateFor(byte1, UnsafeUtil.getByte(address2));
                }
                case 2: {
                    return Utf8.incompleteStateFor(byte1, UnsafeUtil.getByte(address2), UnsafeUtil.getByte(address2 + 1L));
                }
            }
            throw new AssertionError();
        }
    }

    static final class SafeProcessor
    extends Processor {
        SafeProcessor() {
        }

        @Override
        int partialIsValidUtf8(int state, byte[] bytes2, int index2, int limit2) {
            if (state != 0) {
                if (index2 >= limit2) {
                    return state;
                }
                byte byte1 = (byte)state;
                if (byte1 < -32) {
                    if (byte1 < -62 || bytes2[index2++] > -65) {
                        return -1;
                    }
                } else if (byte1 < -16) {
                    byte byte2 = (byte)(~(state >> 8));
                    if (byte2 == 0) {
                        byte2 = bytes2[index2++];
                        if (index2 >= limit2) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    }
                    if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || bytes2[index2++] > -65) {
                        return -1;
                    }
                } else {
                    byte byte2 = (byte)(~(state >> 8));
                    byte byte3 = 0;
                    if (byte2 == 0) {
                        byte2 = bytes2[index2++];
                        if (index2 >= limit2) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    } else {
                        byte3 = (byte)(state >> 16);
                    }
                    if (byte3 == 0) {
                        byte3 = bytes2[index2++];
                        if (index2 >= limit2) {
                            return Utf8.incompleteStateFor(byte1, byte2, byte3);
                        }
                    }
                    if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || bytes2[index2++] > -65) {
                        return -1;
                    }
                }
            }
            return SafeProcessor.partialIsValidUtf8(bytes2, index2, limit2);
        }

        @Override
        int partialIsValidUtf8Direct(int state, ByteBuffer buffer, int index2, int limit2) {
            return this.partialIsValidUtf8Default(state, buffer, index2, limit2);
        }

        @Override
        String decodeUtf8(byte[] bytes2, int index2, int size2) throws InvalidProtocolBufferException {
            byte b;
            int offset2;
            if ((index2 | size2 | bytes2.length - index2 - size2) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", bytes2.length, index2, size2));
            }
            int limit2 = offset2 + size2;
            char[] resultArr = new char[size2];
            int resultPos = 0;
            for (offset2 = index2; offset2 < limit2 && DecodeUtil.isOneByte(b = bytes2[offset2]); ++offset2) {
                DecodeUtil.handleOneByte(b, resultArr, resultPos++);
            }
            while (offset2 < limit2) {
                byte byte1;
                if (DecodeUtil.isOneByte(byte1 = bytes2[offset2++])) {
                    byte b2;
                    DecodeUtil.handleOneByte(byte1, resultArr, resultPos++);
                    while (offset2 < limit2 && DecodeUtil.isOneByte(b2 = bytes2[offset2])) {
                        ++offset2;
                        DecodeUtil.handleOneByte(b2, resultArr, resultPos++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(byte1)) {
                    if (offset2 >= limit2) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(byte1, bytes2[offset2++], resultArr, resultPos++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(byte1)) {
                    if (offset2 >= limit2 - 1) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(byte1, bytes2[offset2++], bytes2[offset2++], resultArr, resultPos++);
                    continue;
                }
                if (offset2 >= limit2 - 2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(byte1, bytes2[offset2++], bytes2[offset2++], bytes2[offset2++], resultArr, resultPos++);
                ++resultPos;
            }
            return new String(resultArr, 0, resultPos);
        }

        @Override
        String decodeUtf8Direct(ByteBuffer buffer, int index2, int size2) throws InvalidProtocolBufferException {
            return this.decodeUtf8Default(buffer, index2, size2);
        }

        @Override
        int encodeUtf8(CharSequence in, byte[] out, int offset2, int length2) {
            char c;
            int i2;
            int utf16Length = in.length();
            int j = offset2;
            int limit2 = offset2 + length2;
            for (i2 = 0; i2 < utf16Length && i2 + j < limit2 && (c = in.charAt(i2)) < '\u0080'; ++i2) {
                out[j + i2] = (byte)c;
            }
            if (i2 == utf16Length) {
                return j + utf16Length;
            }
            j += i2;
            while (i2 < utf16Length) {
                c = in.charAt(i2);
                if (c < '\u0080' && j < limit2) {
                    out[j++] = (byte)c;
                } else if (c < '\u0800' && j <= limit2 - 2) {
                    out[j++] = (byte)(0x3C0 | c >>> 6);
                    out[j++] = (byte)(0x80 | 0x3F & c);
                } else if ((c < '\ud800' || '\udfff' < c) && j <= limit2 - 3) {
                    out[j++] = (byte)(0x1E0 | c >>> 12);
                    out[j++] = (byte)(0x80 | 0x3F & c >>> 6);
                    out[j++] = (byte)(0x80 | 0x3F & c);
                } else if (j <= limit2 - 4) {
                    char low;
                    if (i2 + 1 == in.length() || !Character.isSurrogatePair(c, low = in.charAt(++i2))) {
                        throw new UnpairedSurrogateException(i2 - 1, utf16Length);
                    }
                    int codePoint = Character.toCodePoint(c, low);
                    out[j++] = (byte)(0xF0 | codePoint >>> 18);
                    out[j++] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                    out[j++] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                    out[j++] = (byte)(0x80 | 0x3F & codePoint);
                } else {
                    if (!('\ud800' > c || c > '\udfff' || i2 + 1 != in.length() && Character.isSurrogatePair(c, in.charAt(i2 + 1)))) {
                        throw new UnpairedSurrogateException(i2, utf16Length);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + j);
                }
                ++i2;
            }
            return j;
        }

        @Override
        void encodeUtf8Direct(CharSequence in, ByteBuffer out) {
            this.encodeUtf8Default(in, out);
        }

        private static int partialIsValidUtf8(byte[] bytes2, int index2, int limit2) {
            while (index2 < limit2 && bytes2[index2] >= 0) {
                ++index2;
            }
            return index2 >= limit2 ? 0 : SafeProcessor.partialIsValidUtf8NonAscii(bytes2, index2, limit2);
        }

        private static int partialIsValidUtf8NonAscii(byte[] bytes2, int index2, int limit2) {
            while (true) {
                byte byte2;
                byte byte1;
                if (index2 >= limit2) {
                    return 0;
                }
                if ((byte1 = bytes2[index2++]) >= 0) continue;
                if (byte1 < -32) {
                    if (index2 >= limit2) {
                        return byte1;
                    }
                    if (byte1 >= -62 && bytes2[index2++] <= -65) continue;
                    return -1;
                }
                if (byte1 < -16) {
                    if (index2 >= limit2 - 1) {
                        return Utf8.incompleteStateFor(bytes2, index2, limit2);
                    }
                    if (!((byte2 = bytes2[index2++]) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96) && bytes2[index2++] <= -65) continue;
                    return -1;
                }
                if (index2 >= limit2 - 2) {
                    return Utf8.incompleteStateFor(bytes2, index2, limit2);
                }
                if ((byte2 = bytes2[index2++]) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || bytes2[index2++] > -65 || bytes2[index2++] > -65) break;
            }
            return -1;
        }
    }

    static abstract class Processor {
        Processor() {
        }

        final boolean isValidUtf8(byte[] bytes2, int index2, int limit2) {
            return this.partialIsValidUtf8(0, bytes2, index2, limit2) == 0;
        }

        abstract int partialIsValidUtf8(int var1, byte[] var2, int var3, int var4);

        final boolean isValidUtf8(ByteBuffer buffer, int index2, int limit2) {
            return this.partialIsValidUtf8(0, buffer, index2, limit2) == 0;
        }

        final int partialIsValidUtf8(int state, ByteBuffer buffer, int index2, int limit2) {
            if (buffer.hasArray()) {
                int offset2 = buffer.arrayOffset();
                return this.partialIsValidUtf8(state, buffer.array(), offset2 + index2, offset2 + limit2);
            }
            if (buffer.isDirect()) {
                return this.partialIsValidUtf8Direct(state, buffer, index2, limit2);
            }
            return this.partialIsValidUtf8Default(state, buffer, index2, limit2);
        }

        abstract int partialIsValidUtf8Direct(int var1, ByteBuffer var2, int var3, int var4);

        final int partialIsValidUtf8Default(int state, ByteBuffer buffer, int index2, int limit2) {
            if (state != 0) {
                if (index2 >= limit2) {
                    return state;
                }
                byte byte1 = (byte)state;
                if (byte1 < -32) {
                    if (byte1 < -62 || buffer.get(index2++) > -65) {
                        return -1;
                    }
                } else if (byte1 < -16) {
                    byte byte2 = (byte)(~(state >> 8));
                    if (byte2 == 0) {
                        byte2 = buffer.get(index2++);
                        if (index2 >= limit2) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    }
                    if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || buffer.get(index2++) > -65) {
                        return -1;
                    }
                } else {
                    byte byte2 = (byte)(~(state >> 8));
                    byte byte3 = 0;
                    if (byte2 == 0) {
                        byte2 = buffer.get(index2++);
                        if (index2 >= limit2) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    } else {
                        byte3 = (byte)(state >> 16);
                    }
                    if (byte3 == 0) {
                        byte3 = buffer.get(index2++);
                        if (index2 >= limit2) {
                            return Utf8.incompleteStateFor(byte1, byte2, byte3);
                        }
                    }
                    if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || buffer.get(index2++) > -65) {
                        return -1;
                    }
                }
            }
            return Processor.partialIsValidUtf8(buffer, index2, limit2);
        }

        private static int partialIsValidUtf8(ByteBuffer buffer, int index2, int limit2) {
            index2 += Utf8.estimateConsecutiveAscii(buffer, index2, limit2);
            while (true) {
                byte byte2;
                byte byte1;
                if (index2 >= limit2) {
                    return 0;
                }
                if ((byte1 = buffer.get(index2++)) >= 0) continue;
                if (byte1 < -32) {
                    if (index2 >= limit2) {
                        return byte1;
                    }
                    if (byte1 < -62 || buffer.get(index2) > -65) {
                        return -1;
                    }
                    ++index2;
                    continue;
                }
                if (byte1 < -16) {
                    if (index2 >= limit2 - 1) {
                        return Utf8.incompleteStateFor(buffer, byte1, index2, limit2 - index2);
                    }
                    if ((byte2 = buffer.get(index2++)) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || buffer.get(index2) > -65) {
                        return -1;
                    }
                    ++index2;
                    continue;
                }
                if (index2 >= limit2 - 2) {
                    return Utf8.incompleteStateFor(buffer, byte1, index2, limit2 - index2);
                }
                if ((byte2 = buffer.get(index2++)) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || buffer.get(index2++) > -65 || buffer.get(index2++) > -65) break;
            }
            return -1;
        }

        abstract String decodeUtf8(byte[] var1, int var2, int var3) throws InvalidProtocolBufferException;

        final String decodeUtf8(ByteBuffer buffer, int index2, int size2) throws InvalidProtocolBufferException {
            if (buffer.hasArray()) {
                int offset2 = buffer.arrayOffset();
                return this.decodeUtf8(buffer.array(), offset2 + index2, size2);
            }
            if (buffer.isDirect()) {
                return this.decodeUtf8Direct(buffer, index2, size2);
            }
            return this.decodeUtf8Default(buffer, index2, size2);
        }

        abstract String decodeUtf8Direct(ByteBuffer var1, int var2, int var3) throws InvalidProtocolBufferException;

        final String decodeUtf8Default(ByteBuffer buffer, int index2, int size2) throws InvalidProtocolBufferException {
            byte b;
            int offset2;
            if ((index2 | size2 | buffer.limit() - index2 - size2) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", buffer.limit(), index2, size2));
            }
            int limit2 = offset2 + size2;
            char[] resultArr = new char[size2];
            int resultPos = 0;
            for (offset2 = index2; offset2 < limit2 && DecodeUtil.isOneByte(b = buffer.get(offset2)); ++offset2) {
                DecodeUtil.handleOneByte(b, resultArr, resultPos++);
            }
            while (offset2 < limit2) {
                byte byte1;
                if (DecodeUtil.isOneByte(byte1 = buffer.get(offset2++))) {
                    byte b2;
                    DecodeUtil.handleOneByte(byte1, resultArr, resultPos++);
                    while (offset2 < limit2 && DecodeUtil.isOneByte(b2 = buffer.get(offset2))) {
                        ++offset2;
                        DecodeUtil.handleOneByte(b2, resultArr, resultPos++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(byte1)) {
                    if (offset2 >= limit2) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(byte1, buffer.get(offset2++), resultArr, resultPos++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(byte1)) {
                    if (offset2 >= limit2 - 1) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(byte1, buffer.get(offset2++), buffer.get(offset2++), resultArr, resultPos++);
                    continue;
                }
                if (offset2 >= limit2 - 2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(byte1, buffer.get(offset2++), buffer.get(offset2++), buffer.get(offset2++), resultArr, resultPos++);
                ++resultPos;
            }
            return new String(resultArr, 0, resultPos);
        }

        public boolean isValidUtf8(ByteInput buffer, int index2, int limit2) {
            return this.partialIsValidUtf8(0, buffer, index2, limit2) == 0;
        }

        int partialIsValidUtf8(int state, ByteInput bytes2, int index2, int limit2) {
            if (state != 0) {
                if (index2 >= limit2) {
                    return state;
                }
                byte byte1 = (byte)state;
                if (byte1 < -32) {
                    if (byte1 < -62 || bytes2.read(index2++) > -65) {
                        return -1;
                    }
                } else if (byte1 < -16) {
                    byte byte2 = (byte)(~(state >> 8));
                    if (byte2 == 0) {
                        byte2 = bytes2.read(index2++);
                        if (index2 >= limit2) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    }
                    if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || bytes2.read(index2++) > -65) {
                        return -1;
                    }
                } else {
                    byte byte2 = (byte)(~(state >> 8));
                    byte byte3 = 0;
                    if (byte2 == 0) {
                        byte2 = bytes2.read(index2++);
                        if (index2 >= limit2) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    } else {
                        byte3 = (byte)(state >> 16);
                    }
                    if (byte3 == 0) {
                        byte3 = bytes2.read(index2++);
                        if (index2 >= limit2) {
                            return Utf8.incompleteStateFor(byte1, byte2, byte3);
                        }
                    }
                    if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || bytes2.read(index2++) > -65) {
                        return -1;
                    }
                }
            }
            return Processor.partialIsValidUtf8(bytes2, index2, limit2);
        }

        private static int partialIsValidUtf8(ByteInput bytes2, int index2, int limit2) {
            while (index2 < limit2 && bytes2.read(index2) >= 0) {
                ++index2;
            }
            return index2 >= limit2 ? 0 : Processor.partialIsValidUtf8NonAscii(bytes2, index2, limit2);
        }

        private static int partialIsValidUtf8NonAscii(ByteInput bytes2, int index2, int limit2) {
            while (true) {
                byte byte2;
                byte byte1;
                if (index2 >= limit2) {
                    return 0;
                }
                if ((byte1 = bytes2.read(index2++)) >= 0) continue;
                if (byte1 < -32) {
                    if (index2 >= limit2) {
                        return byte1;
                    }
                    if (byte1 >= -62 && bytes2.read(index2++) <= -65) continue;
                    return -1;
                }
                if (byte1 < -16) {
                    if (index2 >= limit2 - 1) {
                        return Utf8.incompleteStateFor(bytes2, index2, limit2);
                    }
                    if (!((byte2 = bytes2.read(index2++)) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96) && bytes2.read(index2++) <= -65) continue;
                    return -1;
                }
                if (index2 >= limit2 - 2) {
                    return Utf8.incompleteStateFor(bytes2, index2, limit2);
                }
                if ((byte2 = bytes2.read(index2++)) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || bytes2.read(index2++) > -65 || bytes2.read(index2++) > -65) break;
            }
            return -1;
        }

        abstract int encodeUtf8(CharSequence var1, byte[] var2, int var3, int var4);

        final void encodeUtf8(CharSequence in, ByteBuffer out) {
            if (out.hasArray()) {
                int offset2 = out.arrayOffset();
                int endIndex = Utf8.encode(in, out.array(), offset2 + out.position(), out.remaining());
                out.position(endIndex - offset2);
            } else if (out.isDirect()) {
                this.encodeUtf8Direct(in, out);
            } else {
                this.encodeUtf8Default(in, out);
            }
        }

        abstract void encodeUtf8Direct(CharSequence var1, ByteBuffer var2);

        final void encodeUtf8Default(CharSequence in, ByteBuffer out) {
            int inIx;
            int inLength = in.length();
            int outIx = out.position();
            try {
                char c;
                for (inIx = 0; inIx < inLength && (c = in.charAt(inIx)) < '\u0080'; ++inIx) {
                    out.put(outIx + inIx, (byte)c);
                }
                if (inIx == inLength) {
                    out.position(outIx + inIx);
                    return;
                }
                outIx += inIx;
                while (inIx < inLength) {
                    c = in.charAt(inIx);
                    if (c < '\u0080') {
                        out.put(outIx, (byte)c);
                    } else if (c < '\u0800') {
                        out.put(outIx++, (byte)(0xC0 | c >>> 6));
                        out.put(outIx, (byte)(0x80 | 0x3F & c));
                    } else if (c < '\ud800' || '\udfff' < c) {
                        out.put(outIx++, (byte)(0xE0 | c >>> 12));
                        out.put(outIx++, (byte)(0x80 | 0x3F & c >>> 6));
                        out.put(outIx, (byte)(0x80 | 0x3F & c));
                    } else {
                        char low;
                        if (inIx + 1 == inLength || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                            throw new UnpairedSurrogateException(inIx, inLength);
                        }
                        int codePoint = Character.toCodePoint(c, low);
                        out.put(outIx++, (byte)(0xF0 | codePoint >>> 18));
                        out.put(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                        out.put(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                        out.put(outIx, (byte)(0x80 | 0x3F & codePoint));
                    }
                    ++inIx;
                    ++outIx;
                }
                out.position(outIx);
            }
            catch (IndexOutOfBoundsException e) {
                int badWriteIndex = out.position() + Math.max(inIx, outIx - out.position() + 1);
                throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(inIx) + " at index " + badWriteIndex);
            }
        }
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        UnpairedSurrogateException(int index2, int length2) {
            super("Unpaired surrogate at index " + index2 + " of " + length2);
        }
    }
}

