/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.apache.hbase.thirdparty.io.netty.buffer.AbstractReferenceCountedByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.PoolChunk;
import org.apache.hbase.thirdparty.io.netty.buffer.PoolThreadCache;
import org.apache.hbase.thirdparty.io.netty.buffer.PooledDuplicatedByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.PooledSlicedByteBuf;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectPool;

abstract class PooledByteBuf<T>
extends AbstractReferenceCountedByteBuf {
    private final ObjectPool.Handle<PooledByteBuf<T>> recyclerHandle;
    protected PoolChunk<T> chunk;
    protected long handle;
    protected T memory;
    protected int offset;
    protected int length;
    int maxLength;
    PoolThreadCache cache;
    ByteBuffer tmpNioBuf;
    private ByteBufAllocator allocator;

    protected PooledByteBuf(ObjectPool.Handle<? extends PooledByteBuf<T>> recyclerHandle, int maxCapacity) {
        super(maxCapacity);
        this.recyclerHandle = recyclerHandle;
    }

    void init(PoolChunk<T> chunk2, ByteBuffer nioBuffer, long handle, int offset2, int length2, int maxLength, PoolThreadCache cache) {
        this.init0(chunk2, nioBuffer, handle, offset2, length2, maxLength, cache);
    }

    void initUnpooled(PoolChunk<T> chunk2, int length2) {
        this.init0(chunk2, null, 0L, 0, length2, length2, null);
    }

    private void init0(PoolChunk<T> chunk2, ByteBuffer nioBuffer, long handle, int offset2, int length2, int maxLength, PoolThreadCache cache) {
        assert (handle >= 0L);
        assert (chunk2 != null);
        this.chunk = chunk2;
        this.memory = chunk2.memory;
        this.tmpNioBuf = nioBuffer;
        this.allocator = chunk2.arena.parent;
        this.cache = cache;
        this.handle = handle;
        this.offset = offset2;
        this.length = length2;
        this.maxLength = maxLength;
    }

    final void reuse(int maxCapacity) {
        this.maxCapacity(maxCapacity);
        this.resetRefCnt();
        this.setIndex0(0, 0);
        this.discardMarks();
    }

    @Override
    public final int capacity() {
        return this.length;
    }

    @Override
    public int maxFastWritableBytes() {
        return Math.min(this.maxLength, this.maxCapacity()) - this.writerIndex;
    }

    @Override
    public final ByteBuf capacity(int newCapacity) {
        if (newCapacity == this.length) {
            this.ensureAccessible();
            return this;
        }
        this.checkNewCapacity(newCapacity);
        if (!this.chunk.unpooled) {
            if (newCapacity > this.length) {
                if (newCapacity <= this.maxLength) {
                    this.length = newCapacity;
                    return this;
                }
            } else if (newCapacity > this.maxLength >>> 1 && (this.maxLength > 512 || newCapacity > this.maxLength - 16)) {
                this.length = newCapacity;
                this.trimIndicesToCapacity(newCapacity);
                return this;
            }
        }
        this.chunk.arena.reallocate(this, newCapacity, true);
        return this;
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        return PooledDuplicatedByteBuf.newInstance(this, this, this.readerIndex(), this.writerIndex());
    }

    @Override
    public final ByteBuf retainedSlice() {
        int index2 = this.readerIndex();
        return this.retainedSlice(index2, this.writerIndex() - index2);
    }

    @Override
    public final ByteBuf retainedSlice(int index2, int length2) {
        return PooledSlicedByteBuf.newInstance(this, this, index2, length2);
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer tmpNioBuf = this.tmpNioBuf;
        if (tmpNioBuf == null) {
            this.tmpNioBuf = tmpNioBuf = this.newInternalNioBuffer(this.memory);
        } else {
            tmpNioBuf.clear();
        }
        return tmpNioBuf;
    }

    protected abstract ByteBuffer newInternalNioBuffer(T var1);

    @Override
    protected final void deallocate() {
        if (this.handle >= 0L) {
            long handle = this.handle;
            this.handle = -1L;
            this.memory = null;
            this.chunk.arena.free(this.chunk, this.tmpNioBuf, handle, this.maxLength, this.cache);
            this.tmpNioBuf = null;
            this.chunk = null;
            this.recycle();
        }
    }

    private void recycle() {
        this.recyclerHandle.recycle(this);
    }

    protected final int idx(int index2) {
        return this.offset + index2;
    }

    final ByteBuffer _internalNioBuffer(int index2, int length2, boolean duplicate) {
        index2 = this.idx(index2);
        ByteBuffer buffer = duplicate ? this.newInternalNioBuffer(this.memory) : this.internalNioBuffer();
        buffer.limit(index2 + length2).position(index2);
        return buffer;
    }

    ByteBuffer duplicateInternalNioBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        return this._internalNioBuffer(index2, length2, true);
    }

    @Override
    public final ByteBuffer internalNioBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        return this._internalNioBuffer(index2, length2, false);
    }

    @Override
    public final int nioBufferCount() {
        return 1;
    }

    @Override
    public final ByteBuffer nioBuffer(int index2, int length2) {
        return this.duplicateInternalNioBuffer(index2, length2).slice();
    }

    @Override
    public final ByteBuffer[] nioBuffers(int index2, int length2) {
        return new ByteBuffer[]{this.nioBuffer(index2, length2)};
    }

    @Override
    public final boolean isContiguous() {
        return true;
    }

    @Override
    public final int getBytes(int index2, GatheringByteChannel out, int length2) throws IOException {
        return out.write(this.duplicateInternalNioBuffer(index2, length2));
    }

    @Override
    public final int readBytes(GatheringByteChannel out, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes = out.write(this._internalNioBuffer(this.readerIndex, length2, false));
        this.readerIndex += readBytes;
        return readBytes;
    }

    @Override
    public final int getBytes(int index2, FileChannel out, long position, int length2) throws IOException {
        return out.write(this.duplicateInternalNioBuffer(index2, length2), position);
    }

    @Override
    public final int readBytes(FileChannel out, long position, int length2) throws IOException {
        this.checkReadableBytes(length2);
        int readBytes = out.write(this._internalNioBuffer(this.readerIndex, length2, false), position);
        this.readerIndex += readBytes;
        return readBytes;
    }

    @Override
    public final int setBytes(int index2, ScatteringByteChannel in, int length2) throws IOException {
        try {
            return in.read(this.internalNioBuffer(index2, length2));
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }

    @Override
    public final int setBytes(int index2, FileChannel in, long position, int length2) throws IOException {
        try {
            return in.read(this.internalNioBuffer(index2, length2), position);
        }
        catch (ClosedChannelException ignored) {
            return -1;
        }
    }
}

