/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.channel;

import java.util.ArrayDeque;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.CompositeByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelFutureListener;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundInvoker;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPromise;
import org.apache.hbase.thirdparty.io.netty.channel.DelegatingChannelPromiseNotifier;
import org.apache.hbase.thirdparty.io.netty.channel.PendingBytesTracker;
import org.apache.hbase.thirdparty.io.netty.util.ReferenceCountUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLogger;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class AbstractCoalescingBufferQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractCoalescingBufferQueue.class);
    private final ArrayDeque<Object> bufAndListenerPairs;
    private final PendingBytesTracker tracker;
    private int readableBytes;

    protected AbstractCoalescingBufferQueue(Channel channel, int initSize) {
        this.bufAndListenerPairs = new ArrayDeque(initSize);
        this.tracker = channel == null ? null : PendingBytesTracker.newTracker(channel);
    }

    public final void addFirst(ByteBuf buf, ChannelPromise promise) {
        this.addFirst(buf, AbstractCoalescingBufferQueue.toChannelFutureListener(promise));
    }

    private void addFirst(ByteBuf buf, ChannelFutureListener listener) {
        if (listener != null) {
            this.bufAndListenerPairs.addFirst(listener);
        }
        this.bufAndListenerPairs.addFirst(buf);
        this.incrementReadableBytes(buf.readableBytes());
    }

    public final void add(ByteBuf buf) {
        this.add(buf, (ChannelFutureListener)null);
    }

    public final void add(ByteBuf buf, ChannelPromise promise) {
        this.add(buf, AbstractCoalescingBufferQueue.toChannelFutureListener(promise));
    }

    public final void add(ByteBuf buf, ChannelFutureListener listener) {
        this.bufAndListenerPairs.add(buf);
        if (listener != null) {
            this.bufAndListenerPairs.add(listener);
        }
        this.incrementReadableBytes(buf.readableBytes());
    }

    public final ByteBuf removeFirst(ChannelPromise aggregatePromise) {
        Object entry = this.bufAndListenerPairs.poll();
        if (entry == null) {
            return null;
        }
        assert (entry instanceof ByteBuf);
        ByteBuf result2 = (ByteBuf)entry;
        this.decrementReadableBytes(result2.readableBytes());
        entry = this.bufAndListenerPairs.peek();
        if (entry instanceof ChannelFutureListener) {
            aggregatePromise.addListener((ChannelFutureListener)entry);
            this.bufAndListenerPairs.poll();
        }
        return result2;
    }

    public final ByteBuf remove(ByteBufAllocator alloc2, int bytes2, ChannelPromise aggregatePromise) {
        ObjectUtil.checkPositiveOrZero(bytes2, "bytes");
        ObjectUtil.checkNotNull(aggregatePromise, "aggregatePromise");
        if (this.bufAndListenerPairs.isEmpty()) {
            assert (this.readableBytes == 0);
            return this.removeEmptyValue();
        }
        bytes2 = Math.min(bytes2, this.readableBytes);
        ByteBuf toReturn = null;
        ByteBuf entryBuffer = null;
        int originalBytes = bytes2;
        try {
            Object entry;
            while ((entry = this.bufAndListenerPairs.poll()) != null) {
                if (entry instanceof ChannelFutureListener) {
                    aggregatePromise.addListener((ChannelFutureListener)entry);
                    continue;
                }
                entryBuffer = (ByteBuf)entry;
                if (entryBuffer.readableBytes() > bytes2) {
                    this.bufAndListenerPairs.addFirst(entryBuffer);
                    if (bytes2 > 0) {
                        entryBuffer = entryBuffer.readRetainedSlice(bytes2);
                        toReturn = toReturn == null ? this.composeFirst(alloc2, entryBuffer) : this.compose(alloc2, toReturn, entryBuffer);
                        bytes2 = 0;
                    }
                    break;
                }
                bytes2 -= entryBuffer.readableBytes();
                toReturn = toReturn == null ? this.composeFirst(alloc2, entryBuffer) : this.compose(alloc2, toReturn, entryBuffer);
                entryBuffer = null;
            }
        }
        catch (Throwable cause2) {
            ReferenceCountUtil.safeRelease(entryBuffer);
            ReferenceCountUtil.safeRelease(toReturn);
            aggregatePromise.setFailure(cause2);
            PlatformDependent.throwException(cause2);
        }
        this.decrementReadableBytes(originalBytes - bytes2);
        return toReturn;
    }

    public final int readableBytes() {
        return this.readableBytes;
    }

    public final boolean isEmpty() {
        return this.bufAndListenerPairs.isEmpty();
    }

    public final void releaseAndFailAll(ChannelOutboundInvoker invoker, Throwable cause2) {
        this.releaseAndCompleteAll(invoker.newFailedFuture(cause2));
    }

    public final void copyTo(AbstractCoalescingBufferQueue dest) {
        dest.bufAndListenerPairs.addAll(this.bufAndListenerPairs);
        dest.incrementReadableBytes(this.readableBytes);
    }

    public final void writeAndRemoveAll(ChannelHandlerContext ctx) {
        Throwable pending = null;
        ByteBuf previousBuf = null;
        while (true) {
            Object entry = this.bufAndListenerPairs.poll();
            try {
                if (entry == null) {
                    if (previousBuf == null) break;
                    this.decrementReadableBytes(previousBuf.readableBytes());
                    ctx.write(previousBuf, ctx.voidPromise());
                    break;
                }
                if (entry instanceof ByteBuf) {
                    if (previousBuf != null) {
                        this.decrementReadableBytes(previousBuf.readableBytes());
                        ctx.write(previousBuf, ctx.voidPromise());
                    }
                    previousBuf = (ByteBuf)entry;
                    continue;
                }
                if (entry instanceof ChannelPromise) {
                    this.decrementReadableBytes(previousBuf.readableBytes());
                    ctx.write(previousBuf, (ChannelPromise)entry);
                    previousBuf = null;
                    continue;
                }
                this.decrementReadableBytes(previousBuf.readableBytes());
                ctx.write(previousBuf).addListener((ChannelFutureListener)entry);
                previousBuf = null;
            }
            catch (Throwable t) {
                if (pending == null) {
                    pending = t;
                    continue;
                }
                logger.info("Throwable being suppressed because Throwable {} is already pending", (Object)pending, (Object)t);
            }
        }
        if (pending != null) {
            throw new IllegalStateException(pending);
        }
    }

    public String toString() {
        return "bytes: " + this.readableBytes + " buffers: " + (this.size() >> 1);
    }

    protected abstract ByteBuf compose(ByteBufAllocator var1, ByteBuf var2, ByteBuf var3);

    protected final ByteBuf composeIntoComposite(ByteBufAllocator alloc2, ByteBuf cumulation, ByteBuf next2) {
        CompositeByteBuf composite = alloc2.compositeBuffer(this.size() + 2);
        try {
            composite.addComponent(true, cumulation);
            composite.addComponent(true, next2);
        }
        catch (Throwable cause2) {
            composite.release();
            ReferenceCountUtil.safeRelease(next2);
            PlatformDependent.throwException(cause2);
        }
        return composite;
    }

    protected final ByteBuf copyAndCompose(ByteBufAllocator alloc2, ByteBuf cumulation, ByteBuf next2) {
        ByteBuf newCumulation = alloc2.ioBuffer(cumulation.readableBytes() + next2.readableBytes());
        try {
            newCumulation.writeBytes(cumulation).writeBytes(next2);
        }
        catch (Throwable cause2) {
            newCumulation.release();
            ReferenceCountUtil.safeRelease(next2);
            PlatformDependent.throwException(cause2);
        }
        cumulation.release();
        next2.release();
        return newCumulation;
    }

    protected ByteBuf composeFirst(ByteBufAllocator allocator, ByteBuf first2) {
        return first2;
    }

    protected abstract ByteBuf removeEmptyValue();

    protected final int size() {
        return this.bufAndListenerPairs.size();
    }

    private void releaseAndCompleteAll(ChannelFuture future) {
        Object entry;
        Throwable pending = null;
        while ((entry = this.bufAndListenerPairs.poll()) != null) {
            try {
                if (entry instanceof ByteBuf) {
                    ByteBuf buffer = (ByteBuf)entry;
                    this.decrementReadableBytes(buffer.readableBytes());
                    ReferenceCountUtil.safeRelease(buffer);
                    continue;
                }
                ((ChannelFutureListener)entry).operationComplete(future);
            }
            catch (Throwable t) {
                if (pending == null) {
                    pending = t;
                    continue;
                }
                logger.info("Throwable being suppressed because Throwable {} is already pending", (Object)pending, (Object)t);
            }
        }
        if (pending != null) {
            throw new IllegalStateException(pending);
        }
    }

    private void incrementReadableBytes(int increment) {
        int nextReadableBytes = this.readableBytes + increment;
        if (nextReadableBytes < this.readableBytes) {
            throw new IllegalStateException("buffer queue length overflow: " + this.readableBytes + " + " + increment);
        }
        this.readableBytes = nextReadableBytes;
        if (this.tracker != null) {
            this.tracker.incrementPendingOutboundBytes(increment);
        }
    }

    private void decrementReadableBytes(int decrement) {
        this.readableBytes -= decrement;
        assert (this.readableBytes >= 0);
        if (this.tracker != null) {
            this.tracker.decrementPendingOutboundBytes(decrement);
        }
    }

    private static ChannelFutureListener toChannelFutureListener(ChannelPromise promise) {
        return promise.isVoid() ? null : new DelegatingChannelPromiseNotifier(promise);
    }
}

