/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.channel.epoll;

import java.nio.ByteBuffer;
import org.apache.hbase.thirdparty.io.netty.channel.epoll.Native;
import org.apache.hbase.thirdparty.io.netty.channel.unix.Buffer;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;

final class EpollEventArray {
    private static final int EPOLL_EVENT_SIZE = Native.sizeofEpollEvent();
    private static final int EPOLL_DATA_OFFSET = Native.offsetofEpollData();
    private ByteBuffer memory;
    private long memoryAddress;
    private int length;

    EpollEventArray(int length2) {
        if (length2 < 1) {
            throw new IllegalArgumentException("length must be >= 1 but was " + length2);
        }
        this.length = length2;
        this.memory = Buffer.allocateDirectWithNativeOrder(EpollEventArray.calculateBufferCapacity(length2));
        this.memoryAddress = Buffer.memoryAddress(this.memory);
    }

    long memoryAddress() {
        return this.memoryAddress;
    }

    int length() {
        return this.length;
    }

    void increase() {
        this.length <<= 1;
        ByteBuffer buffer = Buffer.allocateDirectWithNativeOrder(EpollEventArray.calculateBufferCapacity(this.length));
        Buffer.free(this.memory);
        this.memory = buffer;
        this.memoryAddress = Buffer.memoryAddress(buffer);
    }

    void free() {
        Buffer.free(this.memory);
        this.memoryAddress = 0L;
    }

    int events(int index2) {
        return this.getInt(index2, 0);
    }

    int fd(int index2) {
        return this.getInt(index2, EPOLL_DATA_OFFSET);
    }

    private int getInt(int index2, int offset2) {
        if (PlatformDependent.hasUnsafe()) {
            long n = (long)index2 * (long)EPOLL_EVENT_SIZE;
            return PlatformDependent.getInt(this.memoryAddress + n + (long)offset2);
        }
        return this.memory.getInt(index2 * EPOLL_EVENT_SIZE + offset2);
    }

    private static int calculateBufferCapacity(int capacity) {
        return capacity * EPOLL_EVENT_SIZE;
    }
}

