/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.channel.kqueue;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoop;
import org.apache.hbase.thirdparty.io.netty.channel.kqueue.AbstractKQueueServerChannel;
import org.apache.hbase.thirdparty.io.netty.channel.kqueue.BsdSocket;
import org.apache.hbase.thirdparty.io.netty.channel.kqueue.KQueueEventLoop;
import org.apache.hbase.thirdparty.io.netty.channel.kqueue.KQueueServerSocketChannelConfig;
import org.apache.hbase.thirdparty.io.netty.channel.kqueue.KQueueSocketChannel;
import org.apache.hbase.thirdparty.io.netty.channel.socket.ServerSocketChannel;
import org.apache.hbase.thirdparty.io.netty.channel.unix.NativeInetAddress;

public final class KQueueServerSocketChannel
extends AbstractKQueueServerChannel
implements ServerSocketChannel {
    private final KQueueServerSocketChannelConfig config = new KQueueServerSocketChannelConfig(this);

    public KQueueServerSocketChannel() {
        super(BsdSocket.newSocketStream(), false);
    }

    public KQueueServerSocketChannel(int fd) {
        this(new BsdSocket(fd));
    }

    KQueueServerSocketChannel(BsdSocket fd) {
        super(fd);
    }

    KQueueServerSocketChannel(BsdSocket fd, boolean active) {
        super(fd, active);
    }

    @Override
    protected boolean isCompatible(EventLoop loop2) {
        return loop2 instanceof KQueueEventLoop;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        super.doBind(localAddress);
        this.socket.listen(this.config.getBacklog());
        this.active = true;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public KQueueServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected Channel newChildChannel(int fd, byte[] address2, int offset2, int len) throws Exception {
        return new KQueueSocketChannel((Channel)this, new BsdSocket(fd), NativeInetAddress.address(address2, offset2, len));
    }
}

