/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.compression;

import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.handler.codec.compression.Crc32c;
import org.apache.hbase.thirdparty.io.netty.handler.codec.compression.DecompressionException;

public final class Snappy {
    private static final int MAX_HT_SIZE = 16384;
    private static final int MIN_COMPRESSIBLE_BYTES = 15;
    private static final int PREAMBLE_NOT_FULL = -1;
    private static final int NOT_ENOUGH_INPUT = -1;
    private static final int LITERAL = 0;
    private static final int COPY_1_BYTE_OFFSET = 1;
    private static final int COPY_2_BYTE_OFFSET = 2;
    private static final int COPY_4_BYTE_OFFSET = 3;
    private State state = State.READY;
    private byte tag;
    private int written;

    public void reset() {
        this.state = State.READY;
        this.tag = 0;
        this.written = 0;
    }

    public void encode(ByteBuf in, ByteBuf out, int length2) {
        int inIndex;
        int b;
        int i2 = 0;
        while (true) {
            if (((b = length2 >>> i2 * 7) & 0xFFFFFF80) == 0) break;
            out.writeByte(b & 0x7F | 0x80);
            ++i2;
        }
        out.writeByte(b);
        int baseIndex = inIndex = in.readerIndex();
        short[] table = Snappy.getHashTable(length2);
        int shift2 = Integer.numberOfLeadingZeros(table.length) + 1;
        int nextEmit = inIndex;
        if (length2 - inIndex >= 15) {
            int nextHash = Snappy.hash(in, ++inIndex, shift2);
            block1: while (true) {
                int insertTail;
                int candidate;
                int skip2 = 32;
                int nextIndex = inIndex;
                do {
                    int bytesBetweenHashLookups;
                    inIndex = nextIndex;
                    int hash2 = nextHash;
                    if ((nextIndex = inIndex + (bytesBetweenHashLookups = skip2++ >> 5)) > length2 - 4) break block1;
                    nextHash = Snappy.hash(in, nextIndex, shift2);
                    candidate = baseIndex + table[hash2];
                    table[hash2] = (short)(inIndex - baseIndex);
                } while (in.getInt(inIndex) != in.getInt(candidate));
                Snappy.encodeLiteral(in, out, inIndex - nextEmit);
                do {
                    int base = inIndex;
                    int matched2 = 4 + Snappy.findMatchingLength(in, candidate + 4, inIndex + 4, length2);
                    int offset2 = base - candidate;
                    Snappy.encodeCopy(out, offset2, matched2);
                    in.readerIndex(in.readerIndex() + matched2);
                    insertTail = (inIndex += matched2) - 1;
                    nextEmit = inIndex;
                    if (inIndex >= length2 - 4) break block1;
                    int prevHash = Snappy.hash(in, insertTail, shift2);
                    table[prevHash] = (short)(inIndex - baseIndex - 1);
                    int currentHash = Snappy.hash(in, insertTail + 1, shift2);
                    candidate = baseIndex + table[currentHash];
                    table[currentHash] = (short)(inIndex - baseIndex);
                } while (in.getInt(insertTail + 1) == in.getInt(candidate));
                nextHash = Snappy.hash(in, insertTail + 2, shift2);
                ++inIndex;
            }
        }
        if (nextEmit < length2) {
            Snappy.encodeLiteral(in, out, length2 - nextEmit);
        }
    }

    private static int hash(ByteBuf in, int index2, int shift2) {
        return in.getInt(index2) * 506832829 >>> shift2;
    }

    private static short[] getHashTable(int inputSize) {
        int htSize;
        for (htSize = 256; htSize < 16384 && htSize < inputSize; htSize <<= 1) {
        }
        return new short[htSize];
    }

    private static int findMatchingLength(ByteBuf in, int minIndex, int inIndex, int maxIndex) {
        int matched2 = 0;
        while (inIndex <= maxIndex - 4 && in.getInt(inIndex) == in.getInt(minIndex + matched2)) {
            inIndex += 4;
            matched2 += 4;
        }
        while (inIndex < maxIndex && in.getByte(minIndex + matched2) == in.getByte(inIndex)) {
            ++inIndex;
            ++matched2;
        }
        return matched2;
    }

    private static int bitsToEncode(int value2) {
        int highestOneBit = Integer.highestOneBit(value2);
        int bitLength = 0;
        while ((highestOneBit >>= 1) != 0) {
            ++bitLength;
        }
        return bitLength;
    }

    static void encodeLiteral(ByteBuf in, ByteBuf out, int length2) {
        if (length2 < 61) {
            out.writeByte(length2 - 1 << 2);
        } else {
            int bitLength = Snappy.bitsToEncode(length2 - 1);
            int bytesToEncode = 1 + bitLength / 8;
            out.writeByte(59 + bytesToEncode << 2);
            for (int i2 = 0; i2 < bytesToEncode; ++i2) {
                out.writeByte(length2 - 1 >> i2 * 8 & 0xFF);
            }
        }
        out.writeBytes(in, length2);
    }

    private static void encodeCopyWithOffset(ByteBuf out, int offset2, int length2) {
        if (length2 < 12 && offset2 < 2048) {
            out.writeByte(1 | length2 - 4 << 2 | offset2 >> 8 << 5);
            out.writeByte(offset2 & 0xFF);
        } else {
            out.writeByte(2 | length2 - 1 << 2);
            out.writeByte(offset2 & 0xFF);
            out.writeByte(offset2 >> 8 & 0xFF);
        }
    }

    private static void encodeCopy(ByteBuf out, int offset2, int length2) {
        while (length2 >= 68) {
            Snappy.encodeCopyWithOffset(out, offset2, 64);
            length2 -= 64;
        }
        if (length2 > 64) {
            Snappy.encodeCopyWithOffset(out, offset2, 60);
            length2 -= 60;
        }
        Snappy.encodeCopyWithOffset(out, offset2, length2);
    }

    public void decode(ByteBuf in, ByteBuf out) {
        while (in.isReadable()) {
            block0 : switch (this.state) {
                case READY: {
                    this.state = State.READING_PREAMBLE;
                }
                case READING_PREAMBLE: {
                    int uncompressedLength = Snappy.readPreamble(in);
                    if (uncompressedLength == -1) {
                        return;
                    }
                    if (uncompressedLength == 0) {
                        this.state = State.READY;
                        return;
                    }
                    out.ensureWritable(uncompressedLength);
                    this.state = State.READING_TAG;
                }
                case READING_TAG: {
                    if (!in.isReadable()) {
                        return;
                    }
                    this.tag = in.readByte();
                    switch (this.tag & 3) {
                        case 0: {
                            this.state = State.READING_LITERAL;
                            break block0;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            this.state = State.READING_COPY;
                        }
                    }
                    break;
                }
                case READING_LITERAL: {
                    int literalWritten = Snappy.decodeLiteral(this.tag, in, out);
                    if (literalWritten != -1) {
                        this.state = State.READING_TAG;
                        this.written += literalWritten;
                        break;
                    }
                    return;
                }
                case READING_COPY: {
                    switch (this.tag & 3) {
                        case 1: {
                            int decodeWritten = Snappy.decodeCopyWith1ByteOffset(this.tag, in, out, this.written);
                            if (decodeWritten != -1) {
                                this.state = State.READING_TAG;
                                this.written += decodeWritten;
                                break block0;
                            }
                            return;
                        }
                        case 2: {
                            int decodeWritten = Snappy.decodeCopyWith2ByteOffset(this.tag, in, out, this.written);
                            if (decodeWritten != -1) {
                                this.state = State.READING_TAG;
                                this.written += decodeWritten;
                                break block0;
                            }
                            return;
                        }
                        case 3: {
                            int decodeWritten = Snappy.decodeCopyWith4ByteOffset(this.tag, in, out, this.written);
                            if (decodeWritten != -1) {
                                this.state = State.READING_TAG;
                                this.written += decodeWritten;
                                break block0;
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    private static int readPreamble(ByteBuf in) {
        int length2 = 0;
        int byteIndex = 0;
        while (in.isReadable()) {
            short current2 = in.readUnsignedByte();
            length2 |= (current2 & 0x7F) << byteIndex++ * 7;
            if ((current2 & 0x80) == 0) {
                return length2;
            }
            if (byteIndex < 4) continue;
            throw new DecompressionException("Preamble is greater than 4 bytes");
        }
        return 0;
    }

    static int decodeLiteral(byte tag2, ByteBuf in, ByteBuf out) {
        int length2;
        in.markReaderIndex();
        switch (tag2 >> 2 & 0x3F) {
            case 60: {
                if (!in.isReadable()) {
                    return -1;
                }
                length2 = in.readUnsignedByte();
                break;
            }
            case 61: {
                if (in.readableBytes() < 2) {
                    return -1;
                }
                length2 = in.readUnsignedShortLE();
                break;
            }
            case 62: {
                if (in.readableBytes() < 3) {
                    return -1;
                }
                length2 = in.readUnsignedMediumLE();
                break;
            }
            case 63: {
                if (in.readableBytes() < 4) {
                    return -1;
                }
                length2 = in.readIntLE();
                break;
            }
            default: {
                length2 = tag2 >> 2 & 0x3F;
            }
        }
        if (in.readableBytes() < ++length2) {
            in.resetReaderIndex();
            return -1;
        }
        out.writeBytes(in, length2);
        return length2;
    }

    private static int decodeCopyWith1ByteOffset(byte tag2, ByteBuf in, ByteBuf out, int writtenSoFar) {
        if (!in.isReadable()) {
            return -1;
        }
        int initialIndex = out.writerIndex();
        int length2 = 4 + ((tag2 & 0x1C) >> 2);
        int offset2 = (tag2 & 0xE0) << 8 >> 5 | in.readUnsignedByte();
        Snappy.validateOffset(offset2, writtenSoFar);
        out.markReaderIndex();
        if (offset2 < length2) {
            for (int copies = length2 / offset2; copies > 0; --copies) {
                out.readerIndex(initialIndex - offset2);
                out.readBytes(out, offset2);
            }
            if (length2 % offset2 != 0) {
                out.readerIndex(initialIndex - offset2);
                out.readBytes(out, length2 % offset2);
            }
        } else {
            out.readerIndex(initialIndex - offset2);
            out.readBytes(out, length2);
        }
        out.resetReaderIndex();
        return length2;
    }

    private static int decodeCopyWith2ByteOffset(byte tag2, ByteBuf in, ByteBuf out, int writtenSoFar) {
        if (in.readableBytes() < 2) {
            return -1;
        }
        int initialIndex = out.writerIndex();
        int length2 = 1 + (tag2 >> 2 & 0x3F);
        int offset2 = in.readUnsignedShortLE();
        Snappy.validateOffset(offset2, writtenSoFar);
        out.markReaderIndex();
        if (offset2 < length2) {
            for (int copies = length2 / offset2; copies > 0; --copies) {
                out.readerIndex(initialIndex - offset2);
                out.readBytes(out, offset2);
            }
            if (length2 % offset2 != 0) {
                out.readerIndex(initialIndex - offset2);
                out.readBytes(out, length2 % offset2);
            }
        } else {
            out.readerIndex(initialIndex - offset2);
            out.readBytes(out, length2);
        }
        out.resetReaderIndex();
        return length2;
    }

    private static int decodeCopyWith4ByteOffset(byte tag2, ByteBuf in, ByteBuf out, int writtenSoFar) {
        if (in.readableBytes() < 4) {
            return -1;
        }
        int initialIndex = out.writerIndex();
        int length2 = 1 + (tag2 >> 2 & 0x3F);
        int offset2 = in.readIntLE();
        Snappy.validateOffset(offset2, writtenSoFar);
        out.markReaderIndex();
        if (offset2 < length2) {
            for (int copies = length2 / offset2; copies > 0; --copies) {
                out.readerIndex(initialIndex - offset2);
                out.readBytes(out, offset2);
            }
            if (length2 % offset2 != 0) {
                out.readerIndex(initialIndex - offset2);
                out.readBytes(out, length2 % offset2);
            }
        } else {
            out.readerIndex(initialIndex - offset2);
            out.readBytes(out, length2);
        }
        out.resetReaderIndex();
        return length2;
    }

    private static void validateOffset(int offset2, int chunkSizeSoFar) {
        if (offset2 == 0) {
            throw new DecompressionException("Offset is less than minimum permissible value");
        }
        if (offset2 < 0) {
            throw new DecompressionException("Offset is greater than maximum value supported by this implementation");
        }
        if (offset2 > chunkSizeSoFar) {
            throw new DecompressionException("Offset exceeds size of chunk");
        }
    }

    static int calculateChecksum(ByteBuf data) {
        return Snappy.calculateChecksum(data, data.readerIndex(), data.readableBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int calculateChecksum(ByteBuf data, int offset2, int length2) {
        Crc32c crc322 = new Crc32c();
        try {
            crc322.update(data, offset2, length2);
            int n = Snappy.maskChecksum(crc322.getValue());
            return n;
        }
        finally {
            crc322.reset();
        }
    }

    static void validateChecksum(int expectedChecksum, ByteBuf data) {
        Snappy.validateChecksum(expectedChecksum, data, data.readerIndex(), data.readableBytes());
    }

    static void validateChecksum(int expectedChecksum, ByteBuf data, int offset2, int length2) {
        int actualChecksum = Snappy.calculateChecksum(data, offset2, length2);
        if (actualChecksum != expectedChecksum) {
            throw new DecompressionException("mismatching checksum: " + Integer.toHexString(actualChecksum) + " (expected: " + Integer.toHexString(expectedChecksum) + ')');
        }
    }

    static int maskChecksum(long checksum) {
        return (int)((checksum >> 15 | checksum << 17) + -1568478504L);
    }

    private static enum State {
        READY,
        READING_PREAMBLE,
        READING_TAG,
        READING_LITERAL,
        READING_COPY;

    }
}

