/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.memcache.binary;

import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import org.apache.hbase.thirdparty.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheResponse;
import org.apache.hbase.thirdparty.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;

public class DefaultFullBinaryMemcacheResponse
extends DefaultBinaryMemcacheResponse
implements FullBinaryMemcacheResponse {
    private final ByteBuf content;

    public DefaultFullBinaryMemcacheResponse(ByteBuf key2, ByteBuf extras) {
        this(key2, extras, Unpooled.buffer(0));
    }

    public DefaultFullBinaryMemcacheResponse(ByteBuf key2, ByteBuf extras, ByteBuf content) {
        super(key2, extras);
        this.content = ObjectUtil.checkNotNull(content, "content");
        this.setTotalBodyLength(this.keyLength() + this.extrasLength() + content.readableBytes());
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public FullBinaryMemcacheResponse retain() {
        super.retain();
        return this;
    }

    @Override
    public FullBinaryMemcacheResponse retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public FullBinaryMemcacheResponse touch() {
        super.touch();
        return this;
    }

    @Override
    public FullBinaryMemcacheResponse touch(Object hint) {
        super.touch(hint);
        this.content.touch(hint);
        return this;
    }

    @Override
    protected void deallocate() {
        super.deallocate();
        this.content.release();
    }

    @Override
    public FullBinaryMemcacheResponse copy() {
        ByteBuf extras;
        ByteBuf key2 = this.key();
        if (key2 != null) {
            key2 = key2.copy();
        }
        if ((extras = this.extras()) != null) {
            extras = extras.copy();
        }
        return this.newInstance(key2, extras, this.content().copy());
    }

    @Override
    public FullBinaryMemcacheResponse duplicate() {
        ByteBuf extras;
        ByteBuf key2 = this.key();
        if (key2 != null) {
            key2 = key2.duplicate();
        }
        if ((extras = this.extras()) != null) {
            extras = extras.duplicate();
        }
        return this.newInstance(key2, extras, this.content().duplicate());
    }

    @Override
    public FullBinaryMemcacheResponse retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public FullBinaryMemcacheResponse replace(ByteBuf content) {
        ByteBuf extras;
        ByteBuf key2 = this.key();
        if (key2 != null) {
            key2 = key2.retainedDuplicate();
        }
        if ((extras = this.extras()) != null) {
            extras = extras.retainedDuplicate();
        }
        return this.newInstance(key2, extras, content);
    }

    private FullBinaryMemcacheResponse newInstance(ByteBuf key2, ByteBuf extras, ByteBuf content) {
        DefaultFullBinaryMemcacheResponse newInstance2 = new DefaultFullBinaryMemcacheResponse(key2, extras, content);
        this.copyMeta(newInstance2);
        return newInstance2;
    }
}

