/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.util.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;
import org.apache.hbase.thirdparty.io.netty.util.internal.SuppressJava6Requirement;

public final class ThrowableUtil {
    private ThrowableUtil() {
    }

    public static <T extends Throwable> T unknownStackTrace(T cause2, Class<?> clazz, String method2) {
        cause2.setStackTrace(new StackTraceElement[]{new StackTraceElement(clazz.getName(), method2, null, -1)});
        return cause2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stackTraceToString(Throwable cause2) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(out);
        cause2.printStackTrace(pout);
        pout.flush();
        try {
            String string2 = new String(out.toByteArray());
            return string2;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean haveSuppressed() {
        return PlatformDependent.javaVersion() >= 7;
    }

    @SuppressJava6Requirement(reason="Throwable addSuppressed is only available for >= 7. Has check for < 7.")
    public static void addSuppressed(Throwable target, Throwable suppressed) {
        if (!ThrowableUtil.haveSuppressed()) {
            return;
        }
        target.addSuppressed(suppressed);
    }

    public static void addSuppressedAndClear(Throwable target, List<Throwable> suppressed) {
        ThrowableUtil.addSuppressed(target, suppressed);
        suppressed.clear();
    }

    public static void addSuppressed(Throwable target, List<Throwable> suppressed) {
        for (Throwable t : suppressed) {
            ThrowableUtil.addSuppressed(target, t);
        }
    }
}

