/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.deser.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.SettableBeanProperty;
import org.apache.htrace.shaded.fasterxml.jackson.databind.util.NameTransformer;

public final class BeanPropertyMap
implements Iterable<SettableBeanProperty>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Bucket[] _buckets;
    private final int _hashMask;
    private final int _size;
    private int _nextBucketIndex = 0;

    public BeanPropertyMap(Collection<SettableBeanProperty> properties) {
        this._size = properties.size();
        int bucketCount = BeanPropertyMap.findSize(this._size);
        this._hashMask = bucketCount - 1;
        Bucket[] buckets = new Bucket[bucketCount];
        for (SettableBeanProperty property : properties) {
            String key2 = property.getName();
            int index2 = key2.hashCode() & this._hashMask;
            buckets[index2] = new Bucket(buckets[index2], key2, property, this._nextBucketIndex++);
        }
        this._buckets = buckets;
    }

    private BeanPropertyMap(Bucket[] buckets, int size2, int index2) {
        this._buckets = buckets;
        this._size = size2;
        this._hashMask = buckets.length - 1;
        this._nextBucketIndex = index2;
    }

    public BeanPropertyMap withProperty(SettableBeanProperty newProperty) {
        int bcount = this._buckets.length;
        Bucket[] newBuckets = new Bucket[bcount];
        System.arraycopy(this._buckets, 0, newBuckets, 0, bcount);
        String propName = newProperty.getName();
        SettableBeanProperty oldProp = this.find(newProperty.getName());
        if (oldProp == null) {
            int index2 = propName.hashCode() & this._hashMask;
            newBuckets[index2] = new Bucket(newBuckets[index2], propName, newProperty, this._nextBucketIndex++);
            return new BeanPropertyMap(newBuckets, this._size + 1, this._nextBucketIndex);
        }
        BeanPropertyMap newMap = new BeanPropertyMap(newBuckets, bcount, this._nextBucketIndex);
        newMap.replace(newProperty);
        return newMap;
    }

    public BeanPropertyMap renameAll(NameTransformer transformer) {
        if (transformer == null || transformer == NameTransformer.NOP) {
            return this;
        }
        Iterator<SettableBeanProperty> it = this.iterator();
        ArrayList<SettableBeanProperty> newProps = new ArrayList<SettableBeanProperty>();
        while (it.hasNext()) {
            JsonDeserializer<Object> newDeser;
            SettableBeanProperty prop = it.next();
            String newName = transformer.transform(prop.getName());
            JsonDeserializer<Object> deser = (prop = prop.withSimpleName(newName)).getValueDeserializer();
            if (deser != null && (newDeser = deser.unwrappingDeserializer(transformer)) != deser) {
                prop = prop.withValueDeserializer(newDeser);
            }
            newProps.add(prop);
        }
        return new BeanPropertyMap(newProps);
    }

    public BeanPropertyMap assignIndexes() {
        int index2 = 0;
        for (Bucket bucket : this._buckets) {
            while (bucket != null) {
                bucket.value.assignIndex(index2++);
                bucket = bucket.next;
            }
        }
        return this;
    }

    private static final int findSize(int size2) {
        int result2;
        int needed = size2 <= 32 ? size2 + size2 : size2 + (size2 >> 2);
        for (result2 = 2; result2 < needed; result2 += result2) {
        }
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Properties=[");
        int count2 = 0;
        for (SettableBeanProperty prop : this.getPropertiesInInsertionOrder()) {
            if (prop == null) continue;
            if (count2++ > 0) {
                sb.append(", ");
            }
            sb.append(prop.getName());
            sb.append('(');
            sb.append(prop.getType());
            sb.append(')');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Iterator<SettableBeanProperty> iterator() {
        return new IteratorImpl(this._buckets);
    }

    public SettableBeanProperty[] getPropertiesInInsertionOrder() {
        int len = this._nextBucketIndex;
        SettableBeanProperty[] result2 = new SettableBeanProperty[len];
        Bucket[] arr$ = this._buckets;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Bucket root;
            Bucket bucket = root = arr$[i$];
            while (bucket != null) {
                result2[bucket.index] = bucket.value;
                bucket = bucket.next;
            }
        }
        return result2;
    }

    public int size() {
        return this._size;
    }

    public SettableBeanProperty find(String key2) {
        if (key2 == null) {
            throw new IllegalArgumentException("Can not pass null property name");
        }
        int index2 = key2.hashCode() & this._hashMask;
        Bucket bucket = this._buckets[index2];
        if (bucket == null) {
            return null;
        }
        if (bucket.key == key2) {
            return bucket.value;
        }
        while ((bucket = bucket.next) != null) {
            if (bucket.key != key2) continue;
            return bucket.value;
        }
        return this._findWithEquals(key2, index2);
    }

    public SettableBeanProperty find(int propertyIndex) {
        for (Bucket bucket : this._buckets) {
            while (bucket != null) {
                if (bucket.index == propertyIndex) {
                    return bucket.value;
                }
                bucket = bucket.next;
            }
        }
        return null;
    }

    public void replace(SettableBeanProperty property) {
        String name2 = property.getName();
        int index2 = name2.hashCode() & this._buckets.length - 1;
        Bucket tail = null;
        int foundIndex = -1;
        Bucket bucket = this._buckets[index2];
        while (bucket != null) {
            if (foundIndex < 0 && bucket.key.equals(name2)) {
                foundIndex = bucket.index;
            } else {
                tail = new Bucket(tail, bucket.key, bucket.value, bucket.index);
            }
            bucket = bucket.next;
        }
        if (foundIndex < 0) {
            throw new NoSuchElementException("No entry '" + property + "' found, can't replace");
        }
        this._buckets[index2] = new Bucket(tail, name2, property, foundIndex);
    }

    public void remove(SettableBeanProperty property) {
        String name2 = property.getName();
        int index2 = name2.hashCode() & this._buckets.length - 1;
        Bucket tail = null;
        boolean found = false;
        Bucket bucket = this._buckets[index2];
        while (bucket != null) {
            if (!found && bucket.key.equals(name2)) {
                found = true;
            } else {
                tail = new Bucket(tail, bucket.key, bucket.value, bucket.index);
            }
            bucket = bucket.next;
        }
        if (!found) {
            throw new NoSuchElementException("No entry '" + property + "' found, can't remove");
        }
        this._buckets[index2] = tail;
    }

    private SettableBeanProperty _findWithEquals(String key2, int index2) {
        Bucket bucket = this._buckets[index2];
        while (bucket != null) {
            if (key2.equals(bucket.key)) {
                return bucket.value;
            }
            bucket = bucket.next;
        }
        return null;
    }

    private static final class IteratorImpl
    implements Iterator<SettableBeanProperty> {
        private final Bucket[] _buckets;
        private Bucket _currentBucket;
        private int _nextBucketIndex;

        public IteratorImpl(Bucket[] buckets) {
            this._buckets = buckets;
            int i2 = 0;
            int len = this._buckets.length;
            while (i2 < len) {
                Bucket b;
                if ((b = this._buckets[i2++]) == null) continue;
                this._currentBucket = b;
                break;
            }
            this._nextBucketIndex = i2;
        }

        @Override
        public boolean hasNext() {
            return this._currentBucket != null;
        }

        @Override
        public SettableBeanProperty next() {
            Bucket curr = this._currentBucket;
            if (curr == null) {
                throw new NoSuchElementException();
            }
            Bucket b = curr.next;
            while (b == null && this._nextBucketIndex < this._buckets.length) {
                b = this._buckets[this._nextBucketIndex++];
            }
            this._currentBucket = b;
            return curr.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class Bucket
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Bucket next;
        public final String key;
        public final SettableBeanProperty value;
        public final int index;

        public Bucket(Bucket next2, String key2, SettableBeanProperty value2, int index2) {
            this.next = next2;
            this.key = key2;
            this.value = value2;
            this.index = index2;
        }
    }
}

