/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.ext;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationContext;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class DOMDeserializer<T>
extends FromStringDeserializer<T> {
    private static final long serialVersionUID = 1L;
    private static final DocumentBuilderFactory _parserFactory = DocumentBuilderFactory.newInstance();

    protected DOMDeserializer(Class<T> cls) {
        super(cls);
    }

    @Override
    public abstract T _deserialize(String var1, DeserializationContext var2);

    protected final Document parse(String value2) throws IllegalArgumentException {
        try {
            return _parserFactory.newDocumentBuilder().parse(new InputSource(new StringReader(value2)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse JSON String as XML: " + e.getMessage(), e);
        }
    }

    static {
        _parserFactory.setNamespaceAware(true);
    }

    public static class DocumentDeserializer
    extends DOMDeserializer<Document> {
        private static final long serialVersionUID = 1L;

        public DocumentDeserializer() {
            super(Document.class);
        }

        @Override
        public Document _deserialize(String value2, DeserializationContext ctxt) throws IllegalArgumentException {
            return this.parse(value2);
        }
    }

    public static class NodeDeserializer
    extends DOMDeserializer<Node> {
        private static final long serialVersionUID = 1L;

        public NodeDeserializer() {
            super(Node.class);
        }

        @Override
        public Node _deserialize(String value2, DeserializationContext ctxt) throws IllegalArgumentException {
            return this.parse(value2);
        }
    }
}

