/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rewrite;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.rewrite.RewritePolicy;
import org.apache.log4j.spi.LoggingEvent;

public class ReflectionRewritePolicy
implements RewritePolicy {
    public LoggingEvent rewrite(LoggingEvent source2) {
        Object msg = source2.getMessage();
        if (!(msg instanceof String)) {
            Object newMsg = msg;
            HashMap<String, Object> rewriteProps = new HashMap<String, Object>(source2.getProperties());
            try {
                PropertyDescriptor[] props = Introspector.getBeanInfo(msg.getClass(), Object.class).getPropertyDescriptors();
                if (props.length > 0) {
                    for (int i2 = 0; i2 < props.length; ++i2) {
                        try {
                            Object propertyValue = props[i2].getReadMethod().invoke(msg, (Object[])null);
                            if ("message".equalsIgnoreCase(props[i2].getName())) {
                                newMsg = propertyValue;
                                continue;
                            }
                            rewriteProps.put(props[i2].getName(), propertyValue);
                            continue;
                        }
                        catch (Exception e) {
                            LogLog.warn("Unable to evaluate property " + props[i2].getName(), e);
                        }
                    }
                    return new LoggingEvent(source2.getFQNOfLoggerClass(), source2.getLogger() != null ? source2.getLogger() : Logger.getLogger(source2.getLoggerName()), source2.getTimeStamp(), source2.getLevel(), newMsg, source2.getThreadName(), source2.getThrowableInformation(), source2.getNDC(), source2.getLocationInformation(), rewriteProps);
                }
            }
            catch (Exception e) {
                LogLog.warn("Unable to get property descriptors", e);
            }
        }
        return source2;
    }
}

