/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yetus.audience.tools;

import com.sun.javadoc.DocErrorReporter;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.yetus.audience.tools.RootDocProcessor;

class StabilityOptions {
    public static final String STABLE_OPTION = "-stable";
    public static final String EVOLVING_OPTION = "-evolving";
    public static final String UNSTABLE_OPTION = "-unstable";

    StabilityOptions() {
    }

    public static Integer optionLength(String option) {
        String opt = option.toLowerCase(Locale.ENGLISH);
        if (opt.equals(UNSTABLE_OPTION)) {
            return 1;
        }
        if (opt.equals(EVOLVING_OPTION)) {
            return 1;
        }
        if (opt.equals(STABLE_OPTION)) {
            return 1;
        }
        return null;
    }

    public static void validOptions(String[][] options2, DocErrorReporter reporter) {
        for (int i2 = 0; i2 < options2.length; ++i2) {
            String opt = options2[i2][0].toLowerCase(Locale.ENGLISH);
            if (opt.equals(UNSTABLE_OPTION)) {
                RootDocProcessor.stability = UNSTABLE_OPTION;
                continue;
            }
            if (opt.equals(EVOLVING_OPTION)) {
                RootDocProcessor.stability = EVOLVING_OPTION;
                continue;
            }
            if (!opt.equals(STABLE_OPTION)) continue;
            RootDocProcessor.stability = STABLE_OPTION;
        }
    }

    public static String[][] filterOptions(String[][] options2) {
        ArrayList<String[]> optionsList = new ArrayList<String[]>();
        for (int i2 = 0; i2 < options2.length; ++i2) {
            if (options2[i2][0].equalsIgnoreCase(UNSTABLE_OPTION) || options2[i2][0].equalsIgnoreCase(EVOLVING_OPTION) || options2[i2][0].equalsIgnoreCase(STABLE_OPTION)) continue;
            optionsList.add(options2[i2]);
        }
        String[][] filteredOptions = new String[optionsList.size()][];
        int i3 = 0;
        for (String[] option : optionsList) {
            filteredOptions[i3++] = option;
        }
        return filteredOptions;
    }
}

