/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jute.Record;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.ClientCnxnSocket;
import org.apache.zookeeper.ClientCnxnSocketNIO;
import org.apache.zookeeper.ClientWatchManager;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Environment;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MultiResponse;
import org.apache.zookeeper.MultiTransactionRecord;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Testable;
import org.apache.zookeeper.Transaction;
import org.apache.zookeeper.WatchDeregistration;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeperTestable;
import org.apache.zookeeper.client.ConnectStringParser;
import org.apache.zookeeper.client.HostProvider;
import org.apache.zookeeper.client.StaticHostProvider;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.client.ZooKeeperSaslClient;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.common.StringUtils;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CheckWatchesRequest;
import org.apache.zookeeper.proto.Create2Response;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.CreateResponse;
import org.apache.zookeeper.proto.CreateTTLRequest;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.ExistsRequest;
import org.apache.zookeeper.proto.GetACLRequest;
import org.apache.zookeeper.proto.GetACLResponse;
import org.apache.zookeeper.proto.GetChildren2Request;
import org.apache.zookeeper.proto.GetChildren2Response;
import org.apache.zookeeper.proto.GetChildrenRequest;
import org.apache.zookeeper.proto.GetChildrenResponse;
import org.apache.zookeeper.proto.GetDataRequest;
import org.apache.zookeeper.proto.GetDataResponse;
import org.apache.zookeeper.proto.ReconfigRequest;
import org.apache.zookeeper.proto.RemoveWatchesRequest;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.proto.SetACLRequest;
import org.apache.zookeeper.proto.SetACLResponse;
import org.apache.zookeeper.proto.SetDataRequest;
import org.apache.zookeeper.proto.SetDataResponse;
import org.apache.zookeeper.proto.SyncRequest;
import org.apache.zookeeper.proto.SyncResponse;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.EphemeralType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class ZooKeeper
implements AutoCloseable {
    @Deprecated
    public static final String ZOOKEEPER_CLIENT_CNXN_SOCKET = "zookeeper.clientCnxnSocket";
    @Deprecated
    public static final String SECURE_CLIENT = "zookeeper.client.secure";
    protected final ClientCnxn cnxn;
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeper.class);
    protected final HostProvider hostProvider;
    protected final ZKWatchManager watchManager;
    private final ZKClientConfig clientConfig;

    public void updateServerList(String connectString) throws IOException {
        ClientCnxnSocket clientCnxnSocket;
        InetSocketAddress currentHost;
        ConnectStringParser connectStringParser = new ConnectStringParser(connectString);
        ArrayList<InetSocketAddress> serverAddresses = connectStringParser.getServerAddresses();
        boolean reconfigMode = this.hostProvider.updateServerList(serverAddresses, currentHost = (InetSocketAddress)(clientCnxnSocket = this.cnxn.sendThread.getClientCnxnSocket()).getRemoteSocketAddress());
        if (reconfigMode) {
            clientCnxnSocket.testableCloseSocket();
        }
    }

    public ZooKeeperSaslClient getSaslClient() {
        return this.cnxn.zooKeeperSaslClient;
    }

    public ZKClientConfig getClientConfig() {
        return this.clientConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getDataWatches() {
        Map map = this.watchManager.dataWatches;
        synchronized (map) {
            ArrayList<String> rc = new ArrayList<String>(this.watchManager.dataWatches.keySet());
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getExistWatches() {
        Map map = this.watchManager.existWatches;
        synchronized (map) {
            ArrayList<String> rc = new ArrayList<String>(this.watchManager.existWatches.keySet());
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getChildWatches() {
        Map map = this.watchManager.childWatches;
        synchronized (map) {
            ArrayList<String> rc = new ArrayList<String>(this.watchManager.childWatches.keySet());
            return rc;
        }
    }

    public ZooKeeper(String connectString, int sessionTimeout, Watcher watcher) throws IOException {
        this(connectString, sessionTimeout, watcher, false);
    }

    public ZooKeeper(String connectString, int sessionTimeout, Watcher watcher, ZKClientConfig conf) throws IOException {
        this(connectString, sessionTimeout, watcher, false, conf);
    }

    public ZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly, HostProvider aHostProvider) throws IOException {
        this(connectString, sessionTimeout, watcher, canBeReadOnly, aHostProvider, null);
    }

    public ZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly, HostProvider aHostProvider, ZKClientConfig clientConfig) throws IOException {
        LOG.info("Initiating client connection, connectString=" + connectString + " sessionTimeout=" + sessionTimeout + " watcher=" + watcher);
        if (clientConfig == null) {
            clientConfig = new ZKClientConfig();
        }
        this.clientConfig = clientConfig;
        this.watchManager = this.defaultWatchManager();
        this.watchManager.defaultWatcher = watcher;
        ConnectStringParser connectStringParser = new ConnectStringParser(connectString);
        this.hostProvider = aHostProvider;
        this.cnxn = this.createConnection(connectStringParser.getChrootPath(), this.hostProvider, sessionTimeout, this, this.watchManager, this.getClientCnxnSocket(), canBeReadOnly);
        this.cnxn.start();
    }

    protected ClientCnxn createConnection(String chrootPath, HostProvider hostProvider, int sessionTimeout, ZooKeeper zooKeeper, ClientWatchManager watcher, ClientCnxnSocket clientCnxnSocket, boolean canBeReadOnly) throws IOException {
        return new ClientCnxn(chrootPath, hostProvider, sessionTimeout, this, this.watchManager, clientCnxnSocket, canBeReadOnly);
    }

    public ZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly) throws IOException {
        this(connectString, sessionTimeout, watcher, canBeReadOnly, ZooKeeper.createDefaultHostProvider(connectString));
    }

    public ZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly, ZKClientConfig conf) throws IOException {
        this(connectString, sessionTimeout, watcher, canBeReadOnly, ZooKeeper.createDefaultHostProvider(connectString), conf);
    }

    public ZooKeeper(String connectString, int sessionTimeout, Watcher watcher, long sessionId, byte[] sessionPasswd) throws IOException {
        this(connectString, sessionTimeout, watcher, sessionId, sessionPasswd, false);
    }

    public ZooKeeper(String connectString, int sessionTimeout, Watcher watcher, long sessionId, byte[] sessionPasswd, boolean canBeReadOnly, HostProvider aHostProvider) throws IOException {
        this(connectString, sessionTimeout, watcher, sessionId, sessionPasswd, canBeReadOnly, aHostProvider, null);
    }

    public ZooKeeper(String connectString, int sessionTimeout, Watcher watcher, long sessionId, byte[] sessionPasswd, boolean canBeReadOnly, HostProvider aHostProvider, ZKClientConfig clientConfig) throws IOException {
        LOG.info("Initiating client connection, connectString=" + connectString + " sessionTimeout=" + sessionTimeout + " watcher=" + watcher + " sessionId=" + Long.toHexString(sessionId) + " sessionPasswd=" + (sessionPasswd == null ? "<null>" : "<hidden>"));
        if (clientConfig == null) {
            clientConfig = new ZKClientConfig();
        }
        this.clientConfig = clientConfig;
        this.watchManager = this.defaultWatchManager();
        this.watchManager.defaultWatcher = watcher;
        ConnectStringParser connectStringParser = new ConnectStringParser(connectString);
        this.hostProvider = aHostProvider;
        this.cnxn = new ClientCnxn(connectStringParser.getChrootPath(), this.hostProvider, sessionTimeout, this, this.watchManager, this.getClientCnxnSocket(), sessionId, sessionPasswd, canBeReadOnly);
        this.cnxn.seenRwServerBefore = true;
        this.cnxn.start();
    }

    public ZooKeeper(String connectString, int sessionTimeout, Watcher watcher, long sessionId, byte[] sessionPasswd, boolean canBeReadOnly) throws IOException {
        this(connectString, sessionTimeout, watcher, sessionId, sessionPasswd, canBeReadOnly, ZooKeeper.createDefaultHostProvider(connectString));
    }

    private static HostProvider createDefaultHostProvider(String connectString) {
        return new StaticHostProvider(new ConnectStringParser(connectString).getServerAddresses());
    }

    public Testable getTestable() {
        return new ZooKeeperTestable(this, this.cnxn);
    }

    protected ZKWatchManager defaultWatchManager() {
        return new ZKWatchManager(this.getClientConfig().getBoolean("zookeeper.disableAutoWatchReset"));
    }

    public long getSessionId() {
        return this.cnxn.getSessionId();
    }

    public byte[] getSessionPasswd() {
        return this.cnxn.getSessionPasswd();
    }

    public int getSessionTimeout() {
        return this.cnxn.getSessionTimeout();
    }

    public void addAuthInfo(String scheme, byte[] auth) {
        this.cnxn.addAuthInfo(scheme, auth);
    }

    public synchronized void register(Watcher watcher) {
        this.watchManager.defaultWatcher = watcher;
    }

    @Override
    public synchronized void close() throws InterruptedException {
        block5: {
            if (!this.cnxn.getState().isAlive()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Close called on already closed client");
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing session: 0x" + Long.toHexString(this.getSessionId()));
            }
            try {
                this.cnxn.close();
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("Ignoring unexpected exception during close", e);
            }
        }
        LOG.info("Session: 0x" + Long.toHexString(this.getSessionId()) + " closed");
    }

    public boolean close(int waitForShutdownTimeoutMs) throws InterruptedException {
        this.close();
        return this.testableWaitForShutdown(waitForShutdownTimeoutMs);
    }

    private String prependChroot(String clientPath) {
        if (this.cnxn.chrootPath != null) {
            if (clientPath.length() == 1) {
                return this.cnxn.chrootPath;
            }
            return this.cnxn.chrootPath + clientPath;
        }
        return clientPath;
    }

    public String create(String path2, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        String clientPath = path2;
        PathUtils.validatePath(clientPath, createMode.isSequential());
        EphemeralType.validateTTL(createMode, -1L);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(createMode.isContainer() ? 19 : 1);
        CreateRequest request = new CreateRequest();
        CreateResponse response = new CreateResponse();
        request.setData(data);
        request.setFlags(createMode.toFlag());
        request.setPath(serverPath);
        if (acl != null && acl.size() == 0) {
            throw new KeeperException.InvalidACLException();
        }
        request.setAcl(acl);
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, null);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        if (this.cnxn.chrootPath == null) {
            return response.getPath();
        }
        return response.getPath().substring(this.cnxn.chrootPath.length());
    }

    public String create(String path2, byte[] data, List<ACL> acl, CreateMode createMode, Stat stat2) throws KeeperException, InterruptedException {
        return this.create(path2, data, acl, createMode, stat2, -1L);
    }

    public String create(String path2, byte[] data, List<ACL> acl, CreateMode createMode, Stat stat2, long ttl) throws KeeperException, InterruptedException {
        String clientPath = path2;
        PathUtils.validatePath(clientPath, createMode.isSequential());
        EphemeralType.validateTTL(createMode, ttl);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        this.setCreateHeader(createMode, h);
        Create2Response response = new Create2Response();
        if (acl != null && acl.size() == 0) {
            throw new KeeperException.InvalidACLException();
        }
        Record record = this.makeCreateRecord(createMode, serverPath, data, acl, ttl);
        ReplyHeader r = this.cnxn.submitRequest(h, record, response, null);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        if (stat2 != null) {
            DataTree.copyStat(response.getStat(), stat2);
        }
        if (this.cnxn.chrootPath == null) {
            return response.getPath();
        }
        return response.getPath().substring(this.cnxn.chrootPath.length());
    }

    private void setCreateHeader(CreateMode createMode, RequestHeader h) {
        if (createMode.isTTL()) {
            h.setType(21);
        } else {
            h.setType(createMode.isContainer() ? 19 : 15);
        }
    }

    private Record makeCreateRecord(CreateMode createMode, String serverPath, byte[] data, List<ACL> acl, long ttl) {
        Record record;
        if (createMode.isTTL()) {
            CreateTTLRequest request = new CreateTTLRequest();
            request.setData(data);
            request.setFlags(createMode.toFlag());
            request.setPath(serverPath);
            request.setAcl(acl);
            request.setTtl(ttl);
            record = request;
        } else {
            CreateRequest request = new CreateRequest();
            request.setData(data);
            request.setFlags(createMode.toFlag());
            request.setPath(serverPath);
            request.setAcl(acl);
            record = request;
        }
        return record;
    }

    public void create(String path2, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.StringCallback cb, Object ctx) {
        String clientPath = path2;
        PathUtils.validatePath(clientPath, createMode.isSequential());
        EphemeralType.validateTTL(createMode, -1L);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(createMode.isContainer() ? 19 : 1);
        CreateRequest request = new CreateRequest();
        CreateResponse response = new CreateResponse();
        ReplyHeader r = new ReplyHeader();
        request.setData(data);
        request.setFlags(createMode.toFlag());
        request.setPath(serverPath);
        request.setAcl(acl);
        this.cnxn.queuePacket(h, r, request, response, cb, clientPath, serverPath, ctx, null);
    }

    public void create(String path2, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.Create2Callback cb, Object ctx) {
        this.create(path2, data, acl, createMode, cb, ctx, -1L);
    }

    public void create(String path2, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.Create2Callback cb, Object ctx, long ttl) {
        String clientPath = path2;
        PathUtils.validatePath(clientPath, createMode.isSequential());
        EphemeralType.validateTTL(createMode, ttl);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        this.setCreateHeader(createMode, h);
        ReplyHeader r = new ReplyHeader();
        Create2Response response = new Create2Response();
        Record record = this.makeCreateRecord(createMode, serverPath, data, acl, ttl);
        this.cnxn.queuePacket(h, r, record, response, cb, clientPath, serverPath, ctx, null);
    }

    public void delete(String path2, int version) throws InterruptedException, KeeperException {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        String serverPath = clientPath.equals("/") ? clientPath : this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(2);
        DeleteRequest request = new DeleteRequest();
        request.setPath(serverPath);
        request.setVersion(version);
        ReplyHeader r = this.cnxn.submitRequest(h, request, null, null);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
    }

    public List<OpResult> multi(Iterable<Op> ops) throws InterruptedException, KeeperException {
        for (Op op : ops) {
            op.validate();
        }
        return this.multiInternal(this.generateMultiTransaction(ops));
    }

    public void multi(Iterable<Op> ops, AsyncCallback.MultiCallback cb, Object ctx) {
        List<OpResult> results = this.validatePath(ops);
        if (results.size() > 0) {
            cb.processResult(KeeperException.Code.BADARGUMENTS.intValue(), null, ctx, results);
            return;
        }
        this.multiInternal(this.generateMultiTransaction(ops), cb, ctx);
    }

    private List<OpResult> validatePath(Iterable<Op> ops) {
        ArrayList<OpResult> results = new ArrayList<OpResult>();
        boolean error2 = false;
        for (Op op : ops) {
            OpResult.ErrorResult err;
            try {
                op.validate();
            }
            catch (IllegalArgumentException iae) {
                LOG.error("IllegalArgumentException: " + iae.getMessage());
                err = new OpResult.ErrorResult(KeeperException.Code.BADARGUMENTS.intValue());
                results.add(err);
                error2 = true;
                continue;
            }
            catch (KeeperException ke) {
                LOG.error("KeeperException: " + ke.getMessage());
                err = new OpResult.ErrorResult(ke.code().intValue());
                results.add(err);
                error2 = true;
                continue;
            }
            OpResult.ErrorResult err2 = new OpResult.ErrorResult(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
            results.add(err2);
        }
        if (!error2) {
            results.clear();
        }
        return results;
    }

    private MultiTransactionRecord generateMultiTransaction(Iterable<Op> ops) {
        ArrayList<Op> transaction = new ArrayList<Op>();
        for (Op op : ops) {
            transaction.add(this.withRootPrefix(op));
        }
        return new MultiTransactionRecord(transaction);
    }

    private Op withRootPrefix(Op op) {
        if (null != op.getPath()) {
            String serverPath = this.prependChroot(op.getPath());
            if (!op.getPath().equals(serverPath)) {
                return op.withChroot(serverPath);
            }
        }
        return op;
    }

    protected void multiInternal(MultiTransactionRecord request, AsyncCallback.MultiCallback cb, Object ctx) {
        RequestHeader h = new RequestHeader();
        h.setType(14);
        MultiResponse response = new MultiResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, null, null, ctx, null);
    }

    protected List<OpResult> multiInternal(MultiTransactionRecord request) throws InterruptedException, KeeperException {
        RequestHeader h = new RequestHeader();
        h.setType(14);
        MultiResponse response = new MultiResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, null);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()));
        }
        List<OpResult> results = response.getResultList();
        OpResult.ErrorResult fatalError = null;
        for (OpResult result2 : results) {
            if (!(result2 instanceof OpResult.ErrorResult) || ((OpResult.ErrorResult)result2).getErr() == KeeperException.Code.OK.intValue()) continue;
            fatalError = (OpResult.ErrorResult)result2;
            break;
        }
        if (fatalError != null) {
            KeeperException ex = KeeperException.create(KeeperException.Code.get(fatalError.getErr()));
            ex.setMultiResults(results);
            throw ex;
        }
        return results;
    }

    public Transaction transaction() {
        return new Transaction(this);
    }

    public void delete(String path2, int version, AsyncCallback.VoidCallback cb, Object ctx) {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        String serverPath = clientPath.equals("/") ? clientPath : this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(2);
        DeleteRequest request = new DeleteRequest();
        request.setPath(serverPath);
        request.setVersion(version);
        this.cnxn.queuePacket(h, new ReplyHeader(), request, null, cb, clientPath, serverPath, ctx, null);
    }

    public Stat exists(String path2, Watcher watcher) throws KeeperException, InterruptedException {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        ExistsWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new ExistsWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(3);
        ExistsRequest request = new ExistsRequest();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        SetDataResponse response = new SetDataResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, wcb);
        if (r.getErr() != 0) {
            if (r.getErr() == KeeperException.Code.NONODE.intValue()) {
                return null;
            }
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        return response.getStat().getCzxid() == -1L ? null : response.getStat();
    }

    public Stat exists(String path2, boolean watch) throws KeeperException, InterruptedException {
        return this.exists(path2, watch ? this.watchManager.defaultWatcher : null);
    }

    public void exists(String path2, Watcher watcher, AsyncCallback.StatCallback cb, Object ctx) {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        ExistsWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new ExistsWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(3);
        ExistsRequest request = new ExistsRequest();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        SetDataResponse response = new SetDataResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, wcb);
    }

    public void exists(String path2, boolean watch, AsyncCallback.StatCallback cb, Object ctx) {
        this.exists(path2, watch ? this.watchManager.defaultWatcher : null, cb, ctx);
    }

    public byte[] getData(String path2, Watcher watcher, Stat stat2) throws KeeperException, InterruptedException {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        DataWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new DataWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(4);
        GetDataRequest request = new GetDataRequest();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        GetDataResponse response = new GetDataResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, wcb);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        if (stat2 != null) {
            DataTree.copyStat(response.getStat(), stat2);
        }
        return response.getData();
    }

    public byte[] getData(String path2, boolean watch, Stat stat2) throws KeeperException, InterruptedException {
        return this.getData(path2, watch ? this.watchManager.defaultWatcher : null, stat2);
    }

    public void getData(String path2, Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        DataWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new DataWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(4);
        GetDataRequest request = new GetDataRequest();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        GetDataResponse response = new GetDataResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, wcb);
    }

    public void getData(String path2, boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        this.getData(path2, watch ? this.watchManager.defaultWatcher : null, cb, ctx);
    }

    public byte[] getConfig(Watcher watcher, Stat stat2) throws KeeperException, InterruptedException {
        String configZnode = "/zookeeper/config";
        DataWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new DataWatchRegistration(watcher, "/zookeeper/config");
        }
        RequestHeader h = new RequestHeader();
        h.setType(4);
        GetDataRequest request = new GetDataRequest();
        request.setPath("/zookeeper/config");
        request.setWatch(watcher != null);
        GetDataResponse response = new GetDataResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, wcb);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), "/zookeeper/config");
        }
        if (stat2 != null) {
            DataTree.copyStat(response.getStat(), stat2);
        }
        return response.getData();
    }

    public void getConfig(Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        String configZnode = "/zookeeper/config";
        DataWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new DataWatchRegistration(watcher, "/zookeeper/config");
        }
        RequestHeader h = new RequestHeader();
        h.setType(4);
        GetDataRequest request = new GetDataRequest();
        request.setPath("/zookeeper/config");
        request.setWatch(watcher != null);
        GetDataResponse response = new GetDataResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, "/zookeeper/config", "/zookeeper/config", ctx, wcb);
    }

    public byte[] getConfig(boolean watch, Stat stat2) throws KeeperException, InterruptedException {
        return this.getConfig(watch ? this.watchManager.defaultWatcher : null, stat2);
    }

    public void getConfig(boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        this.getConfig(watch ? this.watchManager.defaultWatcher : null, cb, ctx);
    }

    @Deprecated
    public byte[] reconfig(String joiningServers, String leavingServers, String newMembers, long fromConfig, Stat stat2) throws KeeperException, InterruptedException {
        return this.internalReconfig(joiningServers, leavingServers, newMembers, fromConfig, stat2);
    }

    @Deprecated
    public byte[] reconfig(List<String> joiningServers, List<String> leavingServers, List<String> newMembers, long fromConfig, Stat stat2) throws KeeperException, InterruptedException {
        return this.internalReconfig(joiningServers, leavingServers, newMembers, fromConfig, stat2);
    }

    @Deprecated
    public void reconfig(String joiningServers, String leavingServers, String newMembers, long fromConfig, AsyncCallback.DataCallback cb, Object ctx) {
        this.internalReconfig(joiningServers, leavingServers, newMembers, fromConfig, cb, ctx);
    }

    @Deprecated
    public void reconfig(List<String> joiningServers, List<String> leavingServers, List<String> newMembers, long fromConfig, AsyncCallback.DataCallback cb, Object ctx) {
        this.internalReconfig(joiningServers, leavingServers, newMembers, fromConfig, cb, ctx);
    }

    public Stat setData(String path2, byte[] data, int version) throws KeeperException, InterruptedException {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(5);
        SetDataRequest request = new SetDataRequest();
        request.setPath(serverPath);
        request.setData(data);
        request.setVersion(version);
        SetDataResponse response = new SetDataResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, null);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        return response.getStat();
    }

    public void setData(String path2, byte[] data, int version, AsyncCallback.StatCallback cb, Object ctx) {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(5);
        SetDataRequest request = new SetDataRequest();
        request.setPath(serverPath);
        request.setData(data);
        request.setVersion(version);
        SetDataResponse response = new SetDataResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, null);
    }

    public List<ACL> getACL(String path2, Stat stat2) throws KeeperException, InterruptedException {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(6);
        GetACLRequest request = new GetACLRequest();
        request.setPath(serverPath);
        GetACLResponse response = new GetACLResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, null);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        if (stat2 != null) {
            DataTree.copyStat(response.getStat(), stat2);
        }
        return response.getAcl();
    }

    public void getACL(String path2, Stat stat2, AsyncCallback.ACLCallback cb, Object ctx) {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(6);
        GetACLRequest request = new GetACLRequest();
        request.setPath(serverPath);
        GetACLResponse response = new GetACLResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, null);
    }

    public Stat setACL(String path2, List<ACL> acl, int aclVersion) throws KeeperException, InterruptedException {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(7);
        SetACLRequest request = new SetACLRequest();
        request.setPath(serverPath);
        if (acl != null && acl.size() == 0) {
            throw new KeeperException.InvalidACLException(clientPath);
        }
        request.setAcl(acl);
        request.setVersion(aclVersion);
        SetACLResponse response = new SetACLResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, null);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        return response.getStat();
    }

    public void setACL(String path2, List<ACL> acl, int version, AsyncCallback.StatCallback cb, Object ctx) {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(7);
        SetACLRequest request = new SetACLRequest();
        request.setPath(serverPath);
        request.setAcl(acl);
        request.setVersion(version);
        SetACLResponse response = new SetACLResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, null);
    }

    public List<String> getChildren(String path2, Watcher watcher) throws KeeperException, InterruptedException {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        ChildWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new ChildWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(8);
        GetChildrenRequest request = new GetChildrenRequest();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        GetChildrenResponse response = new GetChildrenResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, wcb);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        return response.getChildren();
    }

    public List<String> getChildren(String path2, boolean watch) throws KeeperException, InterruptedException {
        return this.getChildren(path2, watch ? this.watchManager.defaultWatcher : null);
    }

    public void getChildren(String path2, Watcher watcher, AsyncCallback.ChildrenCallback cb, Object ctx) {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        ChildWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new ChildWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(8);
        GetChildrenRequest request = new GetChildrenRequest();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        GetChildrenResponse response = new GetChildrenResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, wcb);
    }

    public void getChildren(String path2, boolean watch, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this.getChildren(path2, watch ? this.watchManager.defaultWatcher : null, cb, ctx);
    }

    public List<String> getChildren(String path2, Watcher watcher, Stat stat2) throws KeeperException, InterruptedException {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        ChildWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new ChildWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(12);
        GetChildren2Request request = new GetChildren2Request();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        GetChildren2Response response = new GetChildren2Response();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, wcb);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
        if (stat2 != null) {
            DataTree.copyStat(response.getStat(), stat2);
        }
        return response.getChildren();
    }

    public List<String> getChildren(String path2, boolean watch, Stat stat2) throws KeeperException, InterruptedException {
        return this.getChildren(path2, watch ? this.watchManager.defaultWatcher : null, stat2);
    }

    public void getChildren(String path2, Watcher watcher, AsyncCallback.Children2Callback cb, Object ctx) {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        ChildWatchRegistration wcb = null;
        if (watcher != null) {
            wcb = new ChildWatchRegistration(watcher, clientPath);
        }
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(12);
        GetChildren2Request request = new GetChildren2Request();
        request.setPath(serverPath);
        request.setWatch(watcher != null);
        GetChildren2Response response = new GetChildren2Response();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, wcb);
    }

    public void getChildren(String path2, boolean watch, AsyncCallback.Children2Callback cb, Object ctx) {
        this.getChildren(path2, watch ? this.watchManager.defaultWatcher : null, cb, ctx);
    }

    public void sync(String path2, AsyncCallback.VoidCallback cb, Object ctx) {
        String clientPath = path2;
        PathUtils.validatePath(clientPath);
        String serverPath = this.prependChroot(clientPath);
        RequestHeader h = new RequestHeader();
        h.setType(9);
        SyncRequest request = new SyncRequest();
        SyncResponse response = new SyncResponse();
        request.setPath(serverPath);
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, clientPath, serverPath, ctx, null);
    }

    public void removeWatches(String path2, Watcher watcher, Watcher.WatcherType watcherType, boolean local) throws InterruptedException, KeeperException {
        this.validateWatcher(watcher);
        this.removeWatches(17, path2, watcher, watcherType, local);
    }

    public void removeWatches(String path2, Watcher watcher, Watcher.WatcherType watcherType, boolean local, AsyncCallback.VoidCallback cb, Object ctx) {
        this.validateWatcher(watcher);
        this.removeWatches(17, path2, watcher, watcherType, local, cb, ctx);
    }

    public void removeAllWatches(String path2, Watcher.WatcherType watcherType, boolean local) throws InterruptedException, KeeperException {
        this.removeWatches(18, path2, null, watcherType, local);
    }

    public void removeAllWatches(String path2, Watcher.WatcherType watcherType, boolean local, AsyncCallback.VoidCallback cb, Object ctx) {
        this.removeWatches(18, path2, null, watcherType, local, cb, ctx);
    }

    private void validateWatcher(Watcher watcher) {
        if (watcher == null) {
            throw new IllegalArgumentException("Invalid Watcher, shouldn't be null!");
        }
    }

    private void removeWatches(int opCode, String path2, Watcher watcher, Watcher.WatcherType watcherType, boolean local) throws InterruptedException, KeeperException {
        PathUtils.validatePath(path2);
        String clientPath = path2;
        String serverPath = this.prependChroot(clientPath);
        WatchDeregistration wcb = new WatchDeregistration(clientPath, watcher, watcherType, local, this.watchManager);
        RequestHeader h = new RequestHeader();
        h.setType(opCode);
        Record request = this.getRemoveWatchesRequest(opCode, watcherType, serverPath);
        ReplyHeader r = this.cnxn.submitRequest(h, request, null, null, wcb);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), clientPath);
        }
    }

    private void removeWatches(int opCode, String path2, Watcher watcher, Watcher.WatcherType watcherType, boolean local, AsyncCallback.VoidCallback cb, Object ctx) {
        PathUtils.validatePath(path2);
        String clientPath = path2;
        String serverPath = this.prependChroot(clientPath);
        WatchDeregistration wcb = new WatchDeregistration(clientPath, watcher, watcherType, local, this.watchManager);
        RequestHeader h = new RequestHeader();
        h.setType(opCode);
        Record request = this.getRemoveWatchesRequest(opCode, watcherType, serverPath);
        this.cnxn.queuePacket(h, new ReplyHeader(), request, null, cb, clientPath, serverPath, ctx, null, wcb);
    }

    private Record getRemoveWatchesRequest(int opCode, Watcher.WatcherType watcherType, String serverPath) {
        Record request = null;
        switch (opCode) {
            case 17: {
                CheckWatchesRequest chkReq = new CheckWatchesRequest();
                chkReq.setPath(serverPath);
                chkReq.setType(watcherType.getIntValue());
                request = chkReq;
                break;
            }
            case 18: {
                RemoveWatchesRequest rmReq = new RemoveWatchesRequest();
                rmReq.setPath(serverPath);
                rmReq.setType(watcherType.getIntValue());
                request = rmReq;
                break;
            }
            default: {
                LOG.warn("unknown type " + opCode);
            }
        }
        return request;
    }

    public States getState() {
        return this.cnxn.getState();
    }

    public String toString() {
        States state = this.getState();
        return "State:" + state.toString() + (state.isConnected() ? " Timeout:" + this.getSessionTimeout() + " " : " ") + this.cnxn;
    }

    protected boolean testableWaitForShutdown(int wait3) throws InterruptedException {
        this.cnxn.sendThread.join(wait3);
        if (this.cnxn.sendThread.isAlive()) {
            return false;
        }
        this.cnxn.eventThread.join(wait3);
        return !this.cnxn.eventThread.isAlive();
    }

    protected SocketAddress testableRemoteSocketAddress() {
        return this.cnxn.sendThread.getClientCnxnSocket().getRemoteSocketAddress();
    }

    protected SocketAddress testableLocalSocketAddress() {
        return this.cnxn.sendThread.getClientCnxnSocket().getLocalSocketAddress();
    }

    private ClientCnxnSocket getClientCnxnSocket() throws IOException {
        String clientCnxnSocketName = this.getClientConfig().getProperty(ZOOKEEPER_CLIENT_CNXN_SOCKET);
        if (clientCnxnSocketName == null) {
            clientCnxnSocketName = ClientCnxnSocketNIO.class.getName();
        }
        try {
            Constructor<?> clientCxnConstructor = Class.forName(clientCnxnSocketName).getDeclaredConstructor(ZKClientConfig.class);
            ClientCnxnSocket clientCxnSocket = (ClientCnxnSocket)clientCxnConstructor.newInstance(this.getClientConfig());
            return clientCxnSocket;
        }
        catch (Exception e) {
            IOException ioe = new IOException("Couldn't instantiate " + clientCnxnSocketName);
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected byte[] internalReconfig(String joiningServers, String leavingServers, String newMembers, long fromConfig, Stat stat2) throws KeeperException, InterruptedException {
        RequestHeader h = new RequestHeader();
        h.setType(16);
        ReconfigRequest request = new ReconfigRequest(joiningServers, leavingServers, newMembers, fromConfig);
        GetDataResponse response = new GetDataResponse();
        ReplyHeader r = this.cnxn.submitRequest(h, request, response, null);
        if (r.getErr() != 0) {
            throw KeeperException.create(KeeperException.Code.get(r.getErr()), "");
        }
        if (stat2 != null) {
            DataTree.copyStat(response.getStat(), stat2);
        }
        return response.getData();
    }

    protected byte[] internalReconfig(List<String> joiningServers, List<String> leavingServers, List<String> newMembers, long fromConfig, Stat stat2) throws KeeperException, InterruptedException {
        return this.internalReconfig(StringUtils.joinStrings(joiningServers, ","), StringUtils.joinStrings(leavingServers, ","), StringUtils.joinStrings(newMembers, ","), fromConfig, stat2);
    }

    protected void internalReconfig(String joiningServers, String leavingServers, String newMembers, long fromConfig, AsyncCallback.DataCallback cb, Object ctx) {
        RequestHeader h = new RequestHeader();
        h.setType(16);
        ReconfigRequest request = new ReconfigRequest(joiningServers, leavingServers, newMembers, fromConfig);
        GetDataResponse response = new GetDataResponse();
        this.cnxn.queuePacket(h, new ReplyHeader(), request, response, cb, "/zookeeper/config", "/zookeeper/config", ctx, null);
    }

    protected void internalReconfig(List<String> joiningServers, List<String> leavingServers, List<String> newMembers, long fromConfig, AsyncCallback.DataCallback cb, Object ctx) {
        this.internalReconfig(StringUtils.joinStrings(joiningServers, ","), StringUtils.joinStrings(leavingServers, ","), StringUtils.joinStrings(newMembers, ","), fromConfig, cb, ctx);
    }

    static {
        Environment.logEnv("Client environment:", LOG);
    }

    @InterfaceAudience.Public
    public static enum States {
        CONNECTING,
        ASSOCIATING,
        CONNECTED,
        CONNECTEDREADONLY,
        CLOSED,
        AUTH_FAILED,
        NOT_CONNECTED;


        public boolean isAlive() {
            return this != CLOSED && this != AUTH_FAILED;
        }

        public boolean isConnected() {
            return this == CONNECTED || this == CONNECTEDREADONLY;
        }
    }

    class ChildWatchRegistration
    extends WatchRegistration {
        public ChildWatchRegistration(Watcher watcher, String clientPath) {
            super(watcher, clientPath);
        }

        @Override
        protected Map<String, Set<Watcher>> getWatches(int rc) {
            return ZooKeeper.this.watchManager.childWatches;
        }
    }

    class DataWatchRegistration
    extends WatchRegistration {
        public DataWatchRegistration(Watcher watcher, String clientPath) {
            super(watcher, clientPath);
        }

        @Override
        protected Map<String, Set<Watcher>> getWatches(int rc) {
            return ZooKeeper.this.watchManager.dataWatches;
        }
    }

    class ExistsWatchRegistration
    extends WatchRegistration {
        public ExistsWatchRegistration(Watcher watcher, String clientPath) {
            super(watcher, clientPath);
        }

        @Override
        protected Map<String, Set<Watcher>> getWatches(int rc) {
            return rc == 0 ? ZooKeeper.this.watchManager.dataWatches : ZooKeeper.this.watchManager.existWatches;
        }

        @Override
        protected boolean shouldAddWatch(int rc) {
            return rc == 0 || rc == KeeperException.Code.NONODE.intValue();
        }
    }

    public abstract class WatchRegistration {
        private Watcher watcher;
        private String clientPath;

        public WatchRegistration(Watcher watcher, String clientPath) {
            this.watcher = watcher;
            this.clientPath = clientPath;
        }

        protected abstract Map<String, Set<Watcher>> getWatches(int var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(int rc) {
            if (this.shouldAddWatch(rc)) {
                Map<String, Set<Watcher>> watches;
                Map<String, Set<Watcher>> map = watches = this.getWatches(rc);
                synchronized (map) {
                    Set<Watcher> watchers = watches.get(this.clientPath);
                    if (watchers == null) {
                        watchers = new HashSet<Watcher>();
                        watches.put(this.clientPath, watchers);
                    }
                    watchers.add(this.watcher);
                }
            }
        }

        protected boolean shouldAddWatch(int rc) {
            return rc == 0;
        }
    }

    static class ZKWatchManager
    implements ClientWatchManager {
        private final Map<String, Set<Watcher>> dataWatches = new HashMap<String, Set<Watcher>>();
        private final Map<String, Set<Watcher>> existWatches = new HashMap<String, Set<Watcher>>();
        private final Map<String, Set<Watcher>> childWatches = new HashMap<String, Set<Watcher>>();
        private boolean disableAutoWatchReset;
        protected volatile Watcher defaultWatcher;

        ZKWatchManager(boolean disableAutoWatchReset) {
            this.disableAutoWatchReset = disableAutoWatchReset;
        }

        private final void addTo(Set<Watcher> from, Set<Watcher> to) {
            if (from != null) {
                to.addAll(from);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<Watcher.Event.EventType, Set<Watcher>> removeWatcher(String clientPath, Watcher watcher, Watcher.WatcherType watcherType, boolean local, int rc) throws KeeperException {
            this.containsWatcher(clientPath, watcher, watcherType);
            HashMap<Watcher.Event.EventType, Set<Watcher>> removedWatchers = new HashMap<Watcher.Event.EventType, Set<Watcher>>();
            HashSet<Watcher> childWatchersToRem = new HashSet<Watcher>();
            removedWatchers.put(Watcher.Event.EventType.ChildWatchRemoved, childWatchersToRem);
            HashSet<Watcher> dataWatchersToRem = new HashSet<Watcher>();
            removedWatchers.put(Watcher.Event.EventType.DataWatchRemoved, dataWatchersToRem);
            boolean removedWatcher = false;
            switch (watcherType) {
                case Children: {
                    Map<String, Set<Watcher>> map = this.childWatches;
                    synchronized (map) {
                        removedWatcher = this.removeWatches(this.childWatches, watcher, clientPath, local, rc, childWatchersToRem);
                        break;
                    }
                }
                case Data: {
                    Map<String, Set<Watcher>> map = this.dataWatches;
                    synchronized (map) {
                        removedWatcher = this.removeWatches(this.dataWatches, watcher, clientPath, local, rc, dataWatchersToRem);
                    }
                    map = this.existWatches;
                    synchronized (map) {
                        boolean removedDataWatcher = this.removeWatches(this.existWatches, watcher, clientPath, local, rc, dataWatchersToRem);
                        removedWatcher |= removedDataWatcher;
                        break;
                    }
                }
                case Any: {
                    boolean removedDataWatcher;
                    Map<String, Set<Watcher>> map = this.childWatches;
                    synchronized (map) {
                        removedWatcher = this.removeWatches(this.childWatches, watcher, clientPath, local, rc, childWatchersToRem);
                    }
                    map = this.dataWatches;
                    synchronized (map) {
                        removedDataWatcher = this.removeWatches(this.dataWatches, watcher, clientPath, local, rc, dataWatchersToRem);
                        removedWatcher |= removedDataWatcher;
                    }
                    map = this.existWatches;
                    synchronized (map) {
                        removedDataWatcher = this.removeWatches(this.existWatches, watcher, clientPath, local, rc, dataWatchersToRem);
                        removedWatcher |= removedDataWatcher;
                        break;
                    }
                }
            }
            if (!removedWatcher) {
                throw new KeeperException.NoWatcherException(clientPath);
            }
            return removedWatchers;
        }

        private boolean contains(String path2, Watcher watcherObj, Map<String, Set<Watcher>> pathVsWatchers) {
            Set<Watcher> watchers;
            boolean watcherExists = true;
            watcherExists = pathVsWatchers == null || pathVsWatchers.size() == 0 ? false : ((watchers = pathVsWatchers.get(path2)) == null ? false : (watcherObj == null ? watchers.size() > 0 : watchers.contains(watcherObj)));
            return watcherExists;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void containsWatcher(String path2, Watcher watcher, Watcher.WatcherType watcherType) throws KeeperException.NoWatcherException {
            boolean containsWatcher = false;
            switch (watcherType) {
                case Children: {
                    Map<String, Set<Watcher>> map = this.childWatches;
                    synchronized (map) {
                        containsWatcher = this.contains(path2, watcher, this.childWatches);
                        break;
                    }
                }
                case Data: {
                    Map<String, Set<Watcher>> map = this.dataWatches;
                    synchronized (map) {
                        containsWatcher = this.contains(path2, watcher, this.dataWatches);
                    }
                    map = this.existWatches;
                    synchronized (map) {
                        boolean contains_temp = this.contains(path2, watcher, this.existWatches);
                        containsWatcher |= contains_temp;
                        break;
                    }
                }
                case Any: {
                    boolean contains_temp;
                    Map<String, Set<Watcher>> map = this.childWatches;
                    synchronized (map) {
                        containsWatcher = this.contains(path2, watcher, this.childWatches);
                    }
                    map = this.dataWatches;
                    synchronized (map) {
                        contains_temp = this.contains(path2, watcher, this.dataWatches);
                        containsWatcher |= contains_temp;
                    }
                    map = this.existWatches;
                    synchronized (map) {
                        contains_temp = this.contains(path2, watcher, this.existWatches);
                        containsWatcher |= contains_temp;
                        break;
                    }
                }
            }
            if (!containsWatcher) {
                throw new KeeperException.NoWatcherException(path2);
            }
        }

        protected boolean removeWatches(Map<String, Set<Watcher>> pathVsWatcher, Watcher watcher, String path2, boolean local, int rc, Set<Watcher> removedWatchers) throws KeeperException {
            if (!local && rc != KeeperException.Code.OK.intValue()) {
                throw KeeperException.create(KeeperException.Code.get(rc), path2);
            }
            boolean success2 = false;
            if (rc == KeeperException.Code.OK.intValue() || local && rc != KeeperException.Code.OK.intValue()) {
                if (watcher == null) {
                    Set<Watcher> pathWatchers = pathVsWatcher.remove(path2);
                    if (pathWatchers != null) {
                        removedWatchers.addAll(pathWatchers);
                        success2 = true;
                    }
                } else {
                    Set<Watcher> watchers = pathVsWatcher.get(path2);
                    if (watchers != null && watchers.remove(watcher)) {
                        removedWatchers.add(watcher);
                        if (watchers.size() <= 0) {
                            pathVsWatcher.remove(path2);
                        }
                        success2 = true;
                    }
                }
            }
            return success2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Watcher> materialize(Watcher.Event.KeeperState state, Watcher.Event.EventType type2, String clientPath) {
            HashSet<Watcher> result2 = new HashSet<Watcher>();
            switch (type2) {
                case None: {
                    result2.add(this.defaultWatcher);
                    boolean clear2 = this.disableAutoWatchReset && state != Watcher.Event.KeeperState.SyncConnected;
                    Map<String, Set<Watcher>> map = this.dataWatches;
                    synchronized (map) {
                        for (Set<Watcher> ws : this.dataWatches.values()) {
                            result2.addAll(ws);
                        }
                        if (clear2) {
                            this.dataWatches.clear();
                        }
                    }
                    map = this.existWatches;
                    synchronized (map) {
                        for (Set<Watcher> ws : this.existWatches.values()) {
                            result2.addAll(ws);
                        }
                        if (clear2) {
                            this.existWatches.clear();
                        }
                    }
                    map = this.childWatches;
                    synchronized (map) {
                        for (Set<Watcher> ws : this.childWatches.values()) {
                            result2.addAll(ws);
                        }
                        if (clear2) {
                            this.childWatches.clear();
                        }
                    }
                    return result2;
                }
                case NodeDataChanged: 
                case NodeCreated: {
                    Map<String, Set<Watcher>> map = this.dataWatches;
                    synchronized (map) {
                        this.addTo(this.dataWatches.remove(clientPath), result2);
                    }
                    map = this.existWatches;
                    synchronized (map) {
                        this.addTo(this.existWatches.remove(clientPath), result2);
                        break;
                    }
                }
                case NodeChildrenChanged: {
                    Map<String, Set<Watcher>> map = this.childWatches;
                    synchronized (map) {
                        this.addTo(this.childWatches.remove(clientPath), result2);
                        break;
                    }
                }
                case NodeDeleted: {
                    Map<String, Set<Watcher>> map = this.dataWatches;
                    synchronized (map) {
                        this.addTo(this.dataWatches.remove(clientPath), result2);
                    }
                    map = this.existWatches;
                    synchronized (map) {
                        Set<Watcher> list2 = this.existWatches.remove(clientPath);
                        if (list2 != null) {
                            this.addTo(list2, result2);
                            LOG.warn("We are triggering an exists watch for delete! Shouldn't happen!");
                        }
                    }
                    map = this.childWatches;
                    synchronized (map) {
                        this.addTo(this.childWatches.remove(clientPath), result2);
                        break;
                    }
                }
                default: {
                    String msg = "Unhandled watch event type " + (Object)((Object)type2) + " with state " + (Object)((Object)state) + " on path " + clientPath;
                    LOG.error(msg);
                    throw new RuntimeException(msg);
                }
            }
            return result2;
        }
    }
}

