/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Scanner;
import java.util.zip.Adler32;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.server.TraceFormatter;
import org.apache.zookeeper.server.persistence.FileHeader;
import org.apache.zookeeper.server.persistence.FilePadding;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.txn.CreateContainerTxn;
import org.apache.zookeeper.txn.CreateTTLTxn;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.TxnHeader;

public class TxnLogToolkit
implements Closeable {
    private File txnLogFile;
    private boolean recoveryMode = false;
    private boolean verbose = false;
    private FileInputStream txnFis;
    private BinaryInputArchive logStream;
    private int crcFixed = 0;
    private FileOutputStream recoveryFos;
    private BinaryOutputArchive recoveryOa;
    private File recoveryLogFile;
    private FilePadding filePadding = new FilePadding();
    private boolean force = false;

    public static void main(String[] args2) throws Exception {
        try (TxnLogToolkit lt = TxnLogToolkit.parseCommandLine(args2);){
            lt.dump(new Scanner(System.in));
            lt.printStat();
        }
        catch (TxnLogToolkitParseException e) {
            System.err.println(e.getMessage() + "\n");
            TxnLogToolkit.printHelpAndExit(e.getExitCode(), e.getOptions());
        }
        catch (TxnLogToolkitException e) {
            System.err.println(e.getMessage());
            System.exit(e.getExitCode());
        }
    }

    public TxnLogToolkit(boolean recoveryMode, boolean verbose, String txnLogFileName, boolean force) throws FileNotFoundException, TxnLogToolkitException {
        this.recoveryMode = recoveryMode;
        this.verbose = verbose;
        this.force = force;
        this.txnLogFile = new File(txnLogFileName);
        if (!this.txnLogFile.exists() || !this.txnLogFile.canRead()) {
            throw new TxnLogToolkitException(1, "File doesn't exist or not readable: %s", this.txnLogFile);
        }
        if (recoveryMode) {
            this.recoveryLogFile = new File(this.txnLogFile.toString() + ".fixed");
            if (this.recoveryLogFile.exists()) {
                throw new TxnLogToolkitException(1, "Recovery file %s already exists or not writable", this.recoveryLogFile);
            }
        }
        this.openTxnLogFile();
        if (recoveryMode) {
            this.openRecoveryFile();
        }
    }

    public void dump(Scanner scanner) throws Exception {
        this.crcFixed = 0;
        FileHeader fhdr = new FileHeader();
        fhdr.deserialize(this.logStream, "fileheader");
        if (fhdr.getMagic() != FileTxnLog.TXNLOG_MAGIC) {
            throw new TxnLogToolkitException(2, "Invalid magic number for %s", this.txnLogFile.getName());
        }
        System.out.println("ZooKeeper Transactional Log File with dbid " + fhdr.getDbid() + " txnlog format version " + fhdr.getVersion());
        if (this.recoveryMode) {
            fhdr.serialize(this.recoveryOa, "fileheader");
            this.recoveryFos.flush();
            this.filePadding.setCurrentSize(this.recoveryFos.getChannel().position());
        }
        int count2 = 0;
        while (true) {
            byte[] bytes2;
            long crcValue;
            try {
                crcValue = this.logStream.readLong("crcvalue");
                bytes2 = this.logStream.readBuffer("txnEntry");
            }
            catch (EOFException e) {
                System.out.println("EOF reached after " + count2 + " txns.");
                return;
            }
            if (bytes2.length == 0) {
                System.out.println("EOF reached after " + count2 + " txns.");
                return;
            }
            Adler32 crc2 = new Adler32();
            crc2.update(bytes2, 0, bytes2.length);
            if (crcValue != crc2.getValue()) {
                if (this.recoveryMode) {
                    if (!this.force) {
                        this.printTxn(bytes2, "CRC ERROR");
                        if (this.askForFix(scanner)) {
                            crcValue = crc2.getValue();
                            ++this.crcFixed;
                        }
                    } else {
                        crcValue = crc2.getValue();
                        this.printTxn(bytes2, "CRC FIXED");
                        ++this.crcFixed;
                    }
                } else {
                    this.printTxn(bytes2, "CRC ERROR");
                }
            }
            if (!this.recoveryMode || this.verbose) {
                this.printTxn(bytes2);
            }
            if (this.logStream.readByte("EOR") != 66) {
                throw new TxnLogToolkitException(1, "Last transaction was partial.", new Object[0]);
            }
            if (this.recoveryMode) {
                this.filePadding.padFile(this.recoveryFos.getChannel());
                this.recoveryOa.writeLong(crcValue, "crcvalue");
                this.recoveryOa.writeBuffer(bytes2, "txnEntry");
                this.recoveryOa.writeByte((byte)66, "EOR");
            }
            ++count2;
        }
    }

    private boolean askForFix(Scanner scanner) throws TxnLogToolkitException {
        while (true) {
            System.out.print("Would you like to fix it (Yes/No/Abort) ? ");
            char answer = Character.toUpperCase(scanner.next().charAt(0));
            switch (answer) {
                case 'Y': {
                    return true;
                }
                case 'N': {
                    return false;
                }
                case 'A': {
                    throw new TxnLogToolkitException(0, "Recovery aborted.", new Object[0]);
                }
            }
        }
    }

    private void printTxn(byte[] bytes2) throws IOException {
        this.printTxn(bytes2, "");
    }

    private void printTxn(byte[] bytes2, String prefix) throws IOException {
        TxnHeader hdr = new TxnHeader();
        Record txn = SerializeUtils.deserializeTxn(bytes2, hdr);
        String txnStr = TxnLogToolkit.getDataStrFromTxn(txn);
        String txns = String.format("%s session 0x%s cxid 0x%s zxid 0x%s %s %s", DateFormat.getDateTimeInstance(3, 1).format(new Date(hdr.getTime())), Long.toHexString(hdr.getClientId()), Long.toHexString(hdr.getCxid()), Long.toHexString(hdr.getZxid()), TraceFormatter.op2String(hdr.getType()), txnStr);
        if (prefix != null && !"".equals(prefix.trim())) {
            System.out.print(prefix + " - ");
        }
        if (txns.endsWith("\n")) {
            System.out.print(txns);
        } else {
            System.out.println(txns);
        }
    }

    private static String getDataStrFromTxn(Record txn) {
        StringBuilder txnData = new StringBuilder();
        if (txn == null) {
            return txnData.toString();
        }
        if (txn instanceof CreateTxn) {
            CreateTxn createTxn = (CreateTxn)txn;
            txnData.append(createTxn.getPath() + "," + new String(createTxn.getData())).append("," + createTxn.getAcl() + "," + createTxn.getEphemeral()).append("," + createTxn.getParentCVersion());
        } else if (txn instanceof SetDataTxn) {
            SetDataTxn setDataTxn = (SetDataTxn)txn;
            txnData.append(setDataTxn.getPath() + "," + new String(setDataTxn.getData())).append("," + setDataTxn.getVersion());
        } else if (txn instanceof CreateContainerTxn) {
            CreateContainerTxn createContainerTxn = (CreateContainerTxn)txn;
            txnData.append(createContainerTxn.getPath() + "," + new String(createContainerTxn.getData())).append("," + createContainerTxn.getAcl() + "," + createContainerTxn.getParentCVersion());
        } else if (txn instanceof CreateTTLTxn) {
            CreateTTLTxn createTTLTxn = (CreateTTLTxn)txn;
            txnData.append(createTTLTxn.getPath() + "," + new String(createTTLTxn.getData())).append("," + createTTLTxn.getAcl() + "," + createTTLTxn.getParentCVersion()).append("," + createTTLTxn.getTtl());
        } else {
            txnData.append(txn.toString());
        }
        return txnData.toString();
    }

    private void openTxnLogFile() throws FileNotFoundException {
        this.txnFis = new FileInputStream(this.txnLogFile);
        this.logStream = BinaryInputArchive.getArchive(this.txnFis);
    }

    private void closeTxnLogFile() throws IOException {
        if (this.txnFis != null) {
            this.txnFis.close();
        }
    }

    private void openRecoveryFile() throws FileNotFoundException {
        this.recoveryFos = new FileOutputStream(this.recoveryLogFile);
        this.recoveryOa = BinaryOutputArchive.getArchive(this.recoveryFos);
    }

    private void closeRecoveryFile() throws IOException {
        if (this.recoveryFos != null) {
            this.recoveryFos.close();
        }
    }

    private static TxnLogToolkit parseCommandLine(String[] args2) throws TxnLogToolkitException, FileNotFoundException {
        PosixParser parser = new PosixParser();
        Options options2 = new Options();
        Option helpOpt = new Option("h", "help", false, "Print help message");
        options2.addOption(helpOpt);
        Option recoverOpt = new Option("r", "recover", false, "Recovery mode. Re-calculate CRC for broken entries.");
        options2.addOption(recoverOpt);
        Option quietOpt = new Option("v", "verbose", false, "Be verbose in recovery mode: print all entries, not just fixed ones.");
        options2.addOption(quietOpt);
        Option dumpOpt = new Option("d", "dump", false, "Dump mode. Dump all entries of the log file with printing the content of a nodepath (default)");
        options2.addOption(dumpOpt);
        Option forceOpt = new Option("y", "yes", false, "Non-interactive mode: repair all CRC errors without asking");
        options2.addOption(forceOpt);
        try {
            CommandLine cli = parser.parse(options2, args2);
            if (cli.hasOption("help")) {
                TxnLogToolkit.printHelpAndExit(0, options2);
            }
            if (cli.getArgs().length < 1) {
                TxnLogToolkit.printHelpAndExit(1, options2);
            }
            return new TxnLogToolkit(cli.hasOption("recover"), cli.hasOption("verbose"), cli.getArgs()[0], cli.hasOption("yes"));
        }
        catch (ParseException e) {
            throw new TxnLogToolkitParseException(options2, 1, e.getMessage(), new Object[0]);
        }
    }

    private static void printHelpAndExit(int exitCode, Options options2) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp(120, "TxnLogToolkit [-dhrv] <txn_log_file_name>", "", options2, "");
        System.exit(exitCode);
    }

    private void printStat() {
        if (this.recoveryMode) {
            System.out.printf("Recovery file %s has been written with %d fixed CRC error(s)%n", this.recoveryLogFile, this.crcFixed);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.recoveryMode) {
            this.closeRecoveryFile();
        }
        this.closeTxnLogFile();
    }

    static class TxnLogToolkitParseException
    extends TxnLogToolkitException {
        private static final long serialVersionUID = 1L;
        private Options options;

        TxnLogToolkitParseException(Options options2, int exitCode, String message2, Object ... params2) {
            super(exitCode, message2, params2);
            this.options = options2;
        }

        Options getOptions() {
            return this.options;
        }
    }

    static class TxnLogToolkitException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int exitCode;

        TxnLogToolkitException(int exitCode, String message2, Object ... params2) {
            super(String.format(message2, params2));
            this.exitCode = exitCode;
        }

        int getExitCode() {
            return this.exitCode;
        }
    }
}

