/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ZooKeeperCriticalThread;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.quorum.Leader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyRequestProcessor
extends ZooKeeperCriticalThread
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyRequestProcessor.class);
    private final LinkedBlockingQueue<Request> queuedRequests = new LinkedBlockingQueue();
    private boolean finished = false;
    private final RequestProcessor nextProcessor;
    private final ZooKeeperServer zks;

    public ReadOnlyRequestProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("ReadOnlyRequestProcessor:" + zks.getServerId(), zks.getZooKeeperServerListener());
        this.zks = zks;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public void run() {
        try {
            block8: while (!this.finished) {
                Request request = this.queuedRequests.take();
                long traceMask = 2L;
                if (request.type == 11) {
                    traceMask = 8L;
                }
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logRequest(LOG, traceMask, 'R', request, "");
                }
                if (Request.requestOfDeath != request) {
                    switch (request.type) {
                        case 1: 
                        case 2: 
                        case 5: 
                        case 7: 
                        case 9: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 19: 
                        case 20: 
                        case 21: {
                            ReplyHeader hdr = new ReplyHeader(request.cxid, this.zks.getZKDatabase().getDataTreeLastProcessedZxid(), KeeperException.Code.NOTREADONLY.intValue());
                            try {
                                request.cnxn.sendResponse(hdr, null, null);
                            }
                            catch (IOException e) {
                                LOG.error("IO exception while sending response", e);
                            }
                            continue block8;
                        }
                    }
                    if (this.nextProcessor == null) continue;
                    this.nextProcessor.processRequest(request);
                    continue;
                }
                break;
            }
        }
        catch (RequestProcessor.RequestProcessorException e) {
            if (e.getCause() instanceof Leader.XidRolloverException) {
                LOG.info(e.getCause().getMessage());
            }
            this.handleException(this.getName(), e);
        }
        catch (Exception e) {
            this.handleException(this.getName(), e);
        }
        LOG.info("ReadOnlyRequestProcessor exited loop!");
    }

    @Override
    public void processRequest(Request request) {
        if (!this.finished) {
            this.queuedRequests.add(request);
        }
    }

    @Override
    public void shutdown() {
        this.finished = true;
        this.queuedRequests.clear();
        this.queuedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }
}

