/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Collections;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.WeakHashSet;

@JRubyClass(name={"ThreadGroup"})
public class RubyThreadGroup
extends RubyObject {
    private final Set<RubyThread> rubyThreadList = Collections.synchronizedSet(new WeakHashSet());
    private boolean enclosed = false;
    private static final ObjectAllocator THREADGROUP_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
            return new RubyThreadGroup(runtime2, klazz);
        }
    };

    public static RubyClass createThreadGroupClass(Ruby runtime2) {
        RubyClass threadGroupClass = runtime2.defineClass("ThreadGroup", runtime2.getObject(), THREADGROUP_ALLOCATOR);
        runtime2.setThreadGroup(threadGroupClass);
        threadGroupClass.index = 28;
        threadGroupClass.defineAnnotatedMethods(RubyThreadGroup.class);
        RubyThreadGroup defaultThreadGroup = new RubyThreadGroup(runtime2, threadGroupClass);
        runtime2.setDefaultThreadGroup(defaultThreadGroup);
        threadGroupClass.defineConstant("Default", defaultThreadGroup);
        return threadGroupClass;
    }

    @JRubyMethod(name={"add"}, required=1)
    public IRubyObject add(IRubyObject rubyThread, Block block) {
        if (!(rubyThread instanceof RubyThread)) {
            throw this.getRuntime().newTypeError(rubyThread, this.getRuntime().getThread());
        }
        if (this.isFrozen()) {
            throw this.getRuntime().newTypeError("can't add to frozen ThreadGroup");
        }
        RubyThread thread = (RubyThread)rubyThread;
        if (thread.alive_p().isTrue()) {
            this.addDirectly(thread);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDirectly(RubyThread rubyThread) {
        RubyThread rubyThread2 = rubyThread;
        synchronized (rubyThread2) {
            IRubyObject oldGroup = rubyThread.group();
            if (!oldGroup.isNil()) {
                RubyThreadGroup threadGroup = (RubyThreadGroup)oldGroup;
                threadGroup.rubyThreadList.remove(rubyThread);
            }
            rubyThread.setThreadGroup(this);
            this.rubyThreadList.add(rubyThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(RubyThread rubyThread) {
        RubyThread rubyThread2 = rubyThread;
        synchronized (rubyThread2) {
            rubyThread.setThreadGroup(null);
            this.rubyThreadList.remove(rubyThread);
        }
    }

    @JRubyMethod
    public IRubyObject enclose(Block block) {
        this.enclosed = true;
        return this;
    }

    @JRubyMethod(name={"enclosed?"})
    public IRubyObject enclosed_p(Block block) {
        return this.getRuntime().newBoolean(this.enclosed);
    }

    @JRubyMethod
    public IRubyObject list(Block block) {
        return RubyArray.newArray(this.getRuntime(), this.rubyThreadList);
    }

    private RubyThreadGroup(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }
}

