/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyRange;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ArrayJavaProxy
extends JavaProxy {
    public ArrayJavaProxy(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
    }

    public static RubyClass createArrayJavaProxy(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyClass arrayJavaProxy = runtime2.defineClass("ArrayJavaProxy", runtime2.getJavaSupport().getJavaProxyClass(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new ArrayJavaProxy(runtime2, klazz);
            }
        });
        RubyClass singleton = arrayJavaProxy.getSingletonClass();
        DynamicMethod oldNew = singleton.searchMethod("new");
        singleton.addMethod("new", new ArrayNewMethod((RubyModule)singleton, Visibility.PUBLIC, oldNew));
        arrayJavaProxy.defineAnnotatedMethods(ArrayJavaProxy.class);
        arrayJavaProxy.includeModule(runtime2.getEnumerable());
        return arrayJavaProxy;
    }

    public JavaArray getJavaArray() {
        return (JavaArray)this.dataGetStruct();
    }

    @JRubyMethod(name={"length", "size"}, backtrace=true)
    public IRubyObject length() {
        return this.getJavaArray().length();
    }

    @JRubyMethod(name={"empty?"}, backtrace=true)
    public IRubyObject empty(ThreadContext context) {
        return RubyFixnum.zero(context.getRuntime()).eql_p(this.getJavaArray().length());
    }

    @JRubyMethod(name={"[]"}, backtrace=true)
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof RubyInteger) {
            int index2 = (int)((RubyInteger)arg2).getLongValue();
            return this.getJavaArray().arefDirect(index2);
        }
        return this.getRange(context, arg2);
    }

    @JRubyMethod(name={"[]"}, required=1, rest=true, backtrace=true)
    public IRubyObject op_aref(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 1 && args2[0] instanceof RubyInteger) {
            int index2 = (int)((RubyInteger)args2[0]).getLongValue();
            return this.getJavaArray().arefDirect(index2);
        }
        return this.getRange(context, args2);
    }

    @JRubyMethod(name={"[]="}, backtrace=true)
    public IRubyObject op_aset(ThreadContext context, IRubyObject index2, IRubyObject value2) {
        Object converted = value2.toJava(this.getJavaArray().getComponentType());
        this.getJavaArray().setWithExceptionHandling((int)index2.convertToInteger().getLongValue(), converted);
        return value2;
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject at(ThreadContext context, IRubyObject indexObj) {
        long index2;
        RubyFixnum lengthF = this.getJavaArray().length();
        RubyInteger indexI = indexObj.convertToInteger();
        if (indexI.getLongValue() < 0L) {
            indexI = RubyFixnum.newFixnum(context.getRuntime(), indexI.getLongValue() + lengthF.getLongValue());
        }
        if ((index2 = indexI.getLongValue()) >= 0L && index2 < lengthF.getLongValue()) {
            return this.getJavaArray().arefDirect((int)indexI.getLongValue());
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"+"}, backtrace=true)
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        JavaClass arrayClass = JavaClass.get(context.getRuntime(), this.getJavaArray().getComponentType());
        if (other instanceof ArrayJavaProxy) {
            JavaArray otherArray = ((ArrayJavaProxy)other).getJavaArray();
            if (this.getJavaArray().getComponentType().isAssignableFrom(otherArray.getComponentType())) {
                return arrayClass.concatArrays(context, this.getJavaArray(), otherArray);
            }
        }
        return arrayClass.concatArrays(context, this.getJavaArray(), other);
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject each(ThreadContext context, Block block) {
        int length2 = (int)this.getJavaArray().length().getLongValue();
        for (int i2 = 0; i2 < length2; ++i2) {
            IRubyObject rubyObj = this.getJavaArray().arefDirect(i2);
            block.yield(context, rubyObj);
        }
        return this;
    }

    @JRubyMethod(name={"to_a", "to_ary"}, backtrace=true)
    public IRubyObject to_a(ThreadContext context) {
        return JavaUtil.convertJavaArrayToRubyWithNesting(context, this.getObject());
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 1) {
            return this.getRange(context, args2[0]);
        }
        if (args2.length == 2) {
            return this.getRange(context, args2[0], args2[1]);
        }
        throw context.getRuntime().newArgumentError(args2.length, 1);
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject arg0) {
        int length2 = (int)this.getJavaArray().length().getLongValue();
        JavaClass arrayClass = JavaClass.get(context.getRuntime(), this.getJavaArray().getComponentType());
        if (arg0 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg0;
            if (range.first() instanceof RubyFixnum && range.last() instanceof RubyFixnum) {
                int first2 = (int)((RubyFixnum)range.first()).getLongValue();
                int last2 = (int)((RubyFixnum)range.last()).getLongValue();
                first2 = first2 >= 0 ? first2 : length2 + first2;
                last2 = last2 >= 0 ? last2 : length2 + last2;
                int newLength = last2 - first2;
                if (range.exclude_end_p().isFalse()) {
                    ++newLength;
                }
                if (newLength <= 0) {
                    return arrayClass.emptyJavaArray(context);
                }
                return arrayClass.javaArraySubarray(context, this.getJavaArray(), first2, newLength);
            }
            throw context.getRuntime().newTypeError("only Fixnum ranges supported");
        }
        throw context.getRuntime().newTypeError(arg0, context.getRuntime().getRange());
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject firstObj, IRubyObject lengthObj) {
        JavaClass arrayClass = JavaClass.get(context.getRuntime(), this.getJavaArray().getComponentType());
        if (firstObj instanceof RubyFixnum && lengthObj instanceof RubyFixnum) {
            int first2 = (int)((RubyFixnum)firstObj).getLongValue();
            int length2 = (int)((RubyFixnum)lengthObj).getLongValue();
            if ((long)length2 > this.getJavaArray().length().getLongValue()) {
                throw context.getRuntime().newIndexError("length specifed is longer than array");
            }
            int n = first2 = first2 >= 0 ? first2 : (int)this.getJavaArray().length().getLongValue() + first2;
            if (length2 <= 0) {
                return arrayClass.emptyJavaArray(context);
            }
            return arrayClass.javaArraySubarray(context, this.getJavaArray(), first2, length2);
        }
        throw context.getRuntime().newTypeError("only Fixnum ranges supported");
    }

    @Deprecated
    public IRubyObject at(int index2) {
        return this.getJavaArray().at(index2);
    }

    public static class ArrayNewMethod
    extends JavaMethod.JavaMethodOne {
        private DynamicMethod oldNew;

        public ArrayNewMethod(RubyModule implClass, Visibility visibility, DynamicMethod oldNew) {
            super(implClass, visibility);
            this.oldNew = oldNew;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0) {
            Ruby runtime2 = context.getRuntime();
            IRubyObject proxy2 = this.oldNew.call(context, self, clazz, "new_proxy");
            if (arg0 instanceof JavaArray) {
                proxy2.dataWrapStruct(arg0);
                return proxy2;
            }
            throw runtime2.newTypeError(arg0, runtime2.getJavaSupport().getJavaArrayClass());
        }
    }
}

