/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.healthcheck;

import com.codahale.metrics.health.HealthCheck;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.zeppelin.notebook.FileSystemStorage;

public class HdfsHealthCheck
extends HealthCheck {
    private final FileSystemStorage fs;
    private final Path path;

    public HdfsHealthCheck(FileSystemStorage fs, Path path) {
        this.fs = fs;
        this.path = path;
    }

    protected HealthCheck.Result check() throws Exception {
        try {
            if (this.fs.exists(this.path)) {
                return HealthCheck.Result.healthy((String)"Filesystem okay");
            }
        }
        catch (IOException e) {
            return HealthCheck.Result.unhealthy((String)"Filesystem unhealthy", (Object[])new Object[]{e});
        }
        return HealthCheck.Result.unhealthy((String)"Filesystem unhealthy");
    }
}

