/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.Input;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.InterpreterNotFoundException;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.ManagedInterpreterGroup;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.NoteManager;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.ParagraphJobListener;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSync;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithVersionControl;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.SchedulerThreadFactory;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.apache.zeppelin.util.ExecutorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Notebook {
    private static final Logger LOGGER = LoggerFactory.getLogger(Notebook.class);
    private AuthorizationService authorizationService;
    private NoteManager noteManager;
    private InterpreterFactory replFactory;
    private InterpreterSettingManager interpreterSettingManager;
    private ZeppelinConfiguration conf;
    private ParagraphJobListener paragraphJobListener;
    private NotebookRepo notebookRepo;
    private List<NoteEventListener> noteEventListeners = new CopyOnWriteArrayList<NoteEventListener>();
    private Credentials credentials;
    private final List<Consumer<String>> initConsumers;
    private ExecutorService initExecutor;

    public Notebook(ZeppelinConfiguration conf, AuthorizationService authorizationService, NotebookRepo notebookRepo, NoteManager noteManager, InterpreterFactory replFactory, InterpreterSettingManager interpreterSettingManager, Credentials credentials) {
        this.conf = conf;
        this.authorizationService = authorizationService;
        this.noteManager = noteManager;
        this.notebookRepo = notebookRepo;
        this.replFactory = replFactory;
        this.interpreterSettingManager = interpreterSettingManager;
        this.interpreterSettingManager.setNotebook(this);
        this.credentials = credentials;
        this.addNotebookEventListener(this.interpreterSettingManager);
        this.initConsumers = new LinkedList<Consumer<String>>();
    }

    public void recoveryIfNecessary() {
        if (this.conf.isRecoveryEnabled()) {
            this.recoverRunningParagraphs();
        }
    }

    public void addInitConsumer(Consumer<String> initConsumer) {
        this.initConsumers.add(initConsumer);
    }

    public void initNotebook() {
        if (this.initExecutor == null || this.initExecutor.isShutdown() || this.initExecutor.isTerminated()) {
            this.initExecutor = new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors(), 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new SchedulerThreadFactory("NotebookInit"));
        }
        for (NoteInfo noteInfo : this.getNotesInfo()) {
            this.initExecutor.execute(() -> {
                for (Consumer<String> initConsumer : this.initConsumers) {
                    initConsumer.accept(noteInfo.getId());
                }
            });
        }
    }

    public boolean waitForFinishInit(long timeout, TimeUnit unit) {
        if (this.initExecutor == null) {
            return true;
        }
        try {
            this.initExecutor.shutdown();
            return this.initExecutor.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Notebook Init-Job interrupted!", (Throwable)e);
            this.initExecutor.shutdownNow();
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private void recoverRunningParagraphs() {
        Thread thread = new Thread(() -> this.getNotesInfo().forEach(noteInfo -> {
            try {
                LinkedList paragraphsToRecover = new LinkedList();
                this.processNote(noteInfo.getId(), note -> {
                    for (Paragraph paragraph : note.getParagraphs()) {
                        if (paragraph.getStatus() != Job.Status.RUNNING) continue;
                        paragraphsToRecover.add(paragraph);
                    }
                    return null;
                });
                for (Paragraph paragraph : paragraphsToRecover) {
                    paragraph.recover();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Fail to recovery note: {}", (Object)noteInfo.getPath(), (Object)e);
            }
        }));
        thread.setName("Recovering-Thread");
        thread.start();
        LOGGER.info("Start paragraph recovering thread");
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Inject
    public Notebook(ZeppelinConfiguration conf, AuthorizationService authorizationService, NotebookRepo notebookRepo, NoteManager noteManager, InterpreterFactory replFactory, InterpreterSettingManager interpreterSettingManager, Credentials credentials, NoteEventListener noteEventListener) throws IOException {
        this(conf, authorizationService, notebookRepo, noteManager, replFactory, interpreterSettingManager, credentials);
        if (null != noteEventListener) {
            this.addNotebookEventListener(noteEventListener);
        }
        this.paragraphJobListener = (ParagraphJobListener)((Object)noteEventListener);
    }

    public NoteManager getNoteManager() {
        return this.noteManager;
    }

    public void setParagraphJobListener(ParagraphJobListener paragraphJobListener) {
        this.paragraphJobListener = paragraphJobListener;
    }

    public String createNote(String notePath, AuthenticationInfo subject) throws IOException {
        return this.createNote(notePath, this.interpreterSettingManager.getDefaultInterpreterSetting().getName(), subject);
    }

    public String createNote(String notePath, AuthenticationInfo subject, boolean save) throws IOException {
        return this.createNote(notePath, this.interpreterSettingManager.getDefaultInterpreterSetting().getName(), subject, save);
    }

    public String createNote(String notePath, String defaultInterpreterGroup, AuthenticationInfo subject) throws IOException {
        return this.createNote(notePath, defaultInterpreterGroup, subject, true);
    }

    public String createNote(String notePath, String defaultInterpreterGroup, AuthenticationInfo subject, boolean save) throws IOException {
        Note note = new Note(notePath, defaultInterpreterGroup, this.replFactory, this.interpreterSettingManager, this.paragraphJobListener, this.credentials, this.noteEventListeners);
        this.noteManager.addNote(note, subject);
        this.authorizationService.createNoteAuth(note.getId(), subject);
        this.authorizationService.saveNoteAuth();
        if (save) {
            this.noteManager.saveNote(note, subject);
        }
        this.fireNoteCreateEvent(note, subject);
        return note.getId();
    }

    public String exportNote(String noteId) throws IOException {
        try {
            return this.processNote(noteId, note -> {
                if (note == null) {
                    throw new IOException("Note " + noteId + " not found");
                }
                return note.toJson();
            });
        }
        catch (IOException e) {
            throw new IOException("Note " + noteId + " not found");
        }
    }

    public String importNote(String sourceJson, String notePath, AuthenticationInfo subject) throws IOException {
        Note oldNote = Note.fromJson(null, sourceJson);
        if (notePath == null) {
            notePath = oldNote.getName();
        }
        String newNoteId = this.createNote(notePath, subject);
        this.processNote(newNoteId, newNote -> {
            CopyOnWriteArrayList<Paragraph> paragraphs = oldNote.getParagraphs();
            for (Paragraph p : paragraphs) {
                newNote.addCloneParagraph(p, subject);
            }
            this.noteManager.saveNote(newNote, subject);
            return null;
        });
        return newNoteId;
    }

    public String cloneNote(String sourceNoteId, String newNotePath, AuthenticationInfo subject) throws IOException {
        return this.cloneNote(sourceNoteId, "", newNotePath, subject);
    }

    public String cloneNote(String sourceNoteId, String revisionId, String newNotePath, AuthenticationInfo subject) throws IOException {
        return this.processNote(sourceNoteId, sourceNote -> {
            if (sourceNote == null) {
                throw new IOException("Source note: " + sourceNoteId + " not found");
            }
            Note note = StringUtils.isNotEmpty((CharSequence)revisionId) ? this.getNoteByRevision(sourceNote.getId(), sourceNote.getPath(), revisionId, subject) : sourceNote;
            if (note == null) {
                throw new IOException("Source note: " + sourceNoteId + " revisionId " + revisionId + " not found");
            }
            String newNoteId = this.createNote(newNotePath, subject, false);
            this.processNote(newNoteId, newNote -> {
                CopyOnWriteArrayList<Paragraph> paragraphs = note.getParagraphs();
                for (Paragraph p : paragraphs) {
                    newNote.addCloneParagraph(p, subject);
                }
                newNote.setConfig(new HashMap<String, Object>(note.getConfig()));
                newNote.setInfo(new HashMap<String, Object>(note.getInfo()));
                newNote.setDefaultInterpreterGroup(note.getDefaultInterpreterGroup());
                newNote.setNoteForms(new HashMap<String, Input>(note.getNoteForms()));
                newNote.setNoteParams(new HashMap<String, Object>(note.getNoteParams()));
                newNote.setRunning(false);
                this.saveNote(newNote, subject);
                this.authorizationService.createNoteAuth(newNote.getId(), subject);
                return null;
            });
            return newNoteId;
        });
    }

    private void removeNote(Note note, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Remove note: {}", (Object)note.getId());
        note.setRemoved(true);
        this.noteManager.removeNote(note.getId(), subject);
        this.authorizationService.removeNoteAuth(note.getId());
        this.fireNoteRemoveEvent(note, subject);
    }

    public void removeCorruptedNote(String noteId, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Remove corrupted note: {}", (Object)noteId);
        this.noteManager.removeNote(noteId, subject);
        this.authorizationService.removeNoteAuth(noteId);
    }

    public void removeNote(String noteId, AuthenticationInfo subject) throws IOException {
        this.processNote(noteId, note -> {
            if (note != null) {
                this.removeNote(note, subject);
            }
            return null;
        });
    }

    public <T> T processNote(String noteId, NoteProcessor<T> noteProcessor) throws IOException {
        return this.processNote(noteId, false, noteProcessor);
    }

    public <T> T processNote(String noteId, boolean reload, NoteProcessor<T> noteProcessor) throws IOException {
        return (T)this.noteManager.processNote(noteId, reload, note -> {
            if (note == null) {
                return noteProcessor.process(note);
            }
            note.setInterpreterFactory(this.replFactory);
            note.setInterpreterSettingManager(this.interpreterSettingManager);
            note.setParagraphJobListener(this.paragraphJobListener);
            note.setNoteEventListeners(this.noteEventListeners);
            note.setCredentials(this.credentials);
            for (Paragraph p : note.getParagraphs()) {
                p.setNote(note);
            }
            return noteProcessor.process(note);
        });
    }

    public String getNoteIdByPath(String notePath) throws IOException {
        return this.noteManager.getNoteIdByPath(notePath);
    }

    public void saveNote(Note note, AuthenticationInfo subject) throws IOException {
        this.noteManager.saveNote(note, subject);
    }

    public void updateNote(Note note, AuthenticationInfo subject) throws IOException {
        this.noteManager.saveNote(note, subject);
        this.fireNoteUpdateEvent(note, subject);
    }

    public boolean containsNoteById(String noteId) {
        return this.noteManager.getNotesInfo().containsKey(noteId);
    }

    public boolean containsNote(String notePath) {
        return this.noteManager.containsNote(notePath);
    }

    public boolean containsFolder(String folderPath) {
        return this.noteManager.containsFolder(folderPath);
    }

    public void moveNote(String noteId, String newNotePath, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Move note {} to {}", (Object)noteId, (Object)newNotePath);
        this.noteManager.moveNote(noteId, newNotePath, subject);
    }

    public void moveFolder(String folderPath, String newFolderPath, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Move folder from {} to {}", (Object)folderPath, (Object)newFolderPath);
        this.noteManager.moveFolder(folderPath, newFolderPath, subject);
    }

    public void removeFolder(String folderPath, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Remove folder {}", (Object)folderPath);
        List<NoteInfo> noteInfos = this.noteManager.removeFolder(folderPath, subject);
        for (NoteInfo noteInfo : noteInfos) {
            this.removeNote(noteInfo.getId(), subject);
        }
    }

    public void emptyTrash(AuthenticationInfo subject) throws IOException {
        LOGGER.info("Empty Trash");
        this.removeFolder("/~Trash", subject);
    }

    public void restoreAll(AuthenticationInfo subject) throws IOException {
        NoteManager.Folder trash = this.noteManager.getTrashFolder();
        List notes = trash.getNotes().values().stream().collect(Collectors.toList());
        for (NoteManager.NoteNode noteNode : notes) {
            this.moveNote(noteNode.getNoteId(), noteNode.getNotePath().replace("/~Trash", ""), subject);
        }
        List folders = trash.getFolders().values().stream().collect(Collectors.toList());
        for (NoteManager.Folder folder : folders) {
            this.moveFolder(folder.getPath(), folder.getPath().replace("/~Trash", ""), subject);
        }
    }

    public NotebookRepoWithVersionControl.Revision checkpointNote(String noteId, String notePath, String checkpointMessage, AuthenticationInfo subject) throws IOException {
        if (((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo()) {
            return ((NotebookRepoWithVersionControl)this.notebookRepo).checkpoint(noteId, notePath, checkpointMessage, subject);
        }
        return null;
    }

    public List<NotebookRepoWithVersionControl.Revision> listRevisionHistory(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        if (((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo()) {
            return ((NotebookRepoWithVersionControl)this.notebookRepo).revisionHistory(noteId, notePath, subject);
        }
        return null;
    }

    public Note setNoteRevision(String noteId, String notePath, String revisionId, AuthenticationInfo subject) throws IOException {
        if (((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo()) {
            Note note = ((NotebookRepoWithVersionControl)this.notebookRepo).setNoteRevision(noteId, notePath, revisionId, subject);
            this.noteManager.saveNote(note);
            return note;
        }
        return null;
    }

    public Note getNoteByRevision(String noteId, String notePath, String revisionId, AuthenticationInfo subject) throws IOException {
        if (((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo()) {
            return ((NotebookRepoWithVersionControl)this.notebookRepo).get(noteId, notePath, revisionId, subject);
        }
        return null;
    }

    public Note loadNoteFromRepo(String id, AuthenticationInfo subject) {
        Note note = null;
        try {
            note = this.processNote(id, n -> n);
        }
        catch (IOException e) {
            LOGGER.error("Fail to get note: {}", (Object)id, (Object)e);
            return null;
        }
        if (note == null) {
            return null;
        }
        note.setCredentials(this.credentials);
        note.setInterpreterFactory(this.replFactory);
        note.setInterpreterSettingManager(this.interpreterSettingManager);
        note.setParagraphJobListener(this.paragraphJobListener);
        note.setCronSupported(this.getConf());
        if (note.getDefaultInterpreterGroup() == null) {
            note.setDefaultInterpreterGroup(this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_INTERPRETER_GROUP_DEFAULT));
        }
        HashMap<String, SnapshotAngularObject> angularObjectSnapshot = new HashMap<String, SnapshotAngularObject>();
        Date lastUpdatedDate = new Date(0L);
        for (Paragraph p : note.getParagraphs()) {
            p.setNote(note);
            if (p.getDateFinished() == null || !lastUpdatedDate.before(p.getDateFinished())) continue;
            lastUpdatedDate = p.getDateFinished();
        }
        Map<String, List<AngularObject>> savedObjects = note.getAngularObjects();
        if (savedObjects != null) {
            for (Map.Entry<String, List<AngularObject>> entry : savedObjects.entrySet()) {
                String intpGroupName = entry.getKey();
                List<AngularObject> objectList = entry.getValue();
                for (AngularObject object : objectList) {
                    SnapshotAngularObject snapshot = (SnapshotAngularObject)angularObjectSnapshot.get(object.getName());
                    if (snapshot != null && !snapshot.getLastUpdate().before(lastUpdatedDate)) continue;
                    angularObjectSnapshot.put(object.getName(), new SnapshotAngularObject(intpGroupName, object, lastUpdatedDate));
                }
            }
        }
        note.setNoteEventListeners(this.noteEventListeners);
        for (Map.Entry<String, List<Object>> entry : angularObjectSnapshot.entrySet()) {
            String name = entry.getKey();
            SnapshotAngularObject snapshot = (SnapshotAngularObject)((Object)entry.getValue());
            List<InterpreterSetting> settings = this.interpreterSettingManager.get();
            for (InterpreterSetting setting : settings) {
                ManagedInterpreterGroup intpGroup = setting.getInterpreterGroup(note.getExecutionContext());
                if (intpGroup == null || !intpGroup.getId().equals(snapshot.getIntpGroupId())) continue;
                AngularObjectRegistry registry = intpGroup.getAngularObjectRegistry();
                String noteId = snapshot.getAngularObject().getNoteId();
                String paragraphId = snapshot.getAngularObject().getParagraphId();
                registry.add(name, snapshot.getAngularObject().get(), noteId, paragraphId);
            }
        }
        return note;
    }

    public void reloadAllNotes(AuthenticationInfo subject) throws IOException {
        NotebookRepoSync mainRepo;
        this.noteManager.reloadNotes();
        if (this.notebookRepo instanceof NotebookRepoSync && (mainRepo = (NotebookRepoSync)this.notebookRepo).getRepoCount() > 1) {
            mainRepo.sync(subject);
        }
    }

    public List<NoteInfo> getNotesInfo() {
        return this.noteManager.getNotesInfo().entrySet().stream().map(entry -> new NoteInfo((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NoteInfo> getNotesInfo(Predicate<String> func) {
        String homescreenNoteId = this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_HOMESCREEN);
        boolean hideHomeScreenNotebookFromList = this.conf.getBoolean(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_HOMESCREEN_HIDE);
        Map<String, String> map = this.noteManager.getNotesInfo();
        synchronized (map) {
            List<NoteInfo> notesInfo = this.noteManager.getNotesInfo().entrySet().stream().filter(entry -> func.test((String)entry.getKey()) && (!hideHomeScreenNotebookFromList || hideHomeScreenNotebookFromList && !((String)entry.getKey()).equals(homescreenNoteId))).map(entry -> new NoteInfo((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
            notesInfo.sort((note1, note2) -> {
                String name1 = note1.getId();
                if (note1.getPath() != null) {
                    name1 = note1.getPath();
                }
                String name2 = note2.getId();
                if (note2.getPath() != null) {
                    name2 = note2.getPath();
                }
                return name1.compareTo(name2);
            });
            return notesInfo;
        }
    }

    public List<InterpreterSetting> getBindedInterpreterSettings(String noteId) throws IOException {
        ArrayList<InterpreterSetting> interpreterSettings = new ArrayList<InterpreterSetting>();
        this.processNote(noteId, note -> {
            if (note != null) {
                HashSet<InterpreterSetting> settings = new HashSet<InterpreterSetting>();
                for (Paragraph p : note.getParagraphs()) {
                    try {
                        Interpreter intp = p.getBindedInterpreter();
                        settings.add(((ManagedInterpreterGroup)intp.getInterpreterGroup()).getInterpreterSetting());
                    }
                    catch (InterpreterNotFoundException interpreterNotFoundException) {}
                }
                InterpreterSetting defaultIntpSetting = this.interpreterSettingManager.getByName(note.getDefaultInterpreterGroup());
                if (defaultIntpSetting != null) {
                    settings.add(defaultIntpSetting);
                }
                interpreterSettings.addAll(settings);
            }
            return null;
        });
        return interpreterSettings;
    }

    public InterpreterFactory getInterpreterFactory() {
        return this.replFactory;
    }

    public InterpreterSettingManager getInterpreterSettingManager() {
        return this.interpreterSettingManager;
    }

    public ZeppelinConfiguration getConf() {
        return this.conf;
    }

    public void close() {
        if (this.initExecutor != null) {
            ExecutorUtil.softShutdown((String)"NotebookInit", (ExecutorService)this.initExecutor, (int)1, (TimeUnit)TimeUnit.MINUTES);
        }
        this.notebookRepo.close();
    }

    public void addNotebookEventListener(NoteEventListener listener) {
        this.noteEventListeners.add(listener);
    }

    private void fireNoteCreateEvent(Note note, AuthenticationInfo subject) {
        for (NoteEventListener listener : this.noteEventListeners) {
            listener.onNoteCreate(note, subject);
        }
    }

    private void fireNoteUpdateEvent(Note note, AuthenticationInfo subject) {
        for (NoteEventListener listener : this.noteEventListeners) {
            listener.onNoteUpdate(note, subject);
        }
    }

    private void fireNoteRemoveEvent(Note note, AuthenticationInfo subject) {
        for (NoteEventListener listener : this.noteEventListeners) {
            listener.onNoteRemove(note, subject);
        }
    }

    public Boolean isRevisionSupported() {
        if (!this.conf.getBoolean(ZeppelinConfiguration.ConfVars.ZEPPELIN_NOTEBOOK_VERSIONED_MODE_ENABLE)) {
            return false;
        }
        if (this.notebookRepo instanceof NotebookRepoSync) {
            return ((NotebookRepoSync)this.notebookRepo).isRevisionSupportedInDefaultRepo();
        }
        if (this.notebookRepo instanceof NotebookRepoWithVersionControl) {
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface NoteProcessor<T> {
        public T process(Note var1) throws IOException;
    }

    private class SnapshotAngularObject {
        String intpGroupId;
        AngularObject angularObject;
        Date lastUpdate;

        SnapshotAngularObject(String intpGroupId, AngularObject angularObject, Date lastUpdate) {
            this.intpGroupId = intpGroupId;
            this.angularObject = angularObject;
            this.lastUpdate = lastUpdate;
        }

        String getIntpGroupId() {
            return this.intpGroupId;
        }

        AngularObject getAngularObject() {
            return this.angularObject;
        }

        Date getLastUpdate() {
            return this.lastUpdate;
        }
    }
}

