/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.user;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.storage.ConfigStorage;
import org.apache.zeppelin.user.CredentialsInfoSaving;
import org.apache.zeppelin.user.Encryptor;
import org.apache.zeppelin.user.UserCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Credentials {
    private static final Logger LOGGER = LoggerFactory.getLogger(Credentials.class);
    private ConfigStorage storage;
    private Map<String, UserCredentials> credentialsMap = new HashMap<String, UserCredentials>();
    private Gson gson;
    private Encryptor encryptor;

    public Credentials(ZeppelinConfiguration conf) {
        if (conf.credentialsPersist()) {
            String encryptKey = conf.getCredentialsEncryptKey();
            if (StringUtils.isNotBlank((CharSequence)encryptKey)) {
                this.encryptor = new Encryptor(encryptKey);
            }
            try {
                this.storage = ConfigStorage.getInstance(conf);
                GsonBuilder builder = new GsonBuilder();
                builder.setPrettyPrinting();
                this.gson = builder.create();
                this.loadFromFile();
            }
            catch (IOException e) {
                LOGGER.error("Fail to create ConfigStorage for Credentials. Persistenz will be disabled", (Throwable)e);
                this.encryptor = null;
                this.storage = null;
                this.gson = null;
            }
        } else {
            this.encryptor = null;
            this.storage = null;
            this.gson = null;
        }
    }

    public Credentials() {
        this.encryptor = null;
        this.storage = null;
        this.gson = null;
    }

    public UserCredentials getUserCredentials(String username) throws IOException {
        UserCredentials uc = this.credentialsMap.get(username);
        if (uc == null) {
            uc = new UserCredentials();
        }
        return uc;
    }

    public void putUserCredentials(String username, UserCredentials uc) throws IOException {
        this.loadCredentials();
        this.credentialsMap.put(username, uc);
        this.saveCredentials();
    }

    public UserCredentials removeUserCredentials(String username) throws IOException {
        this.loadCredentials();
        UserCredentials uc = this.credentialsMap.remove(username);
        this.saveCredentials();
        return uc;
    }

    public boolean removeCredentialEntity(String username, String entity) throws IOException {
        this.loadCredentials();
        UserCredentials uc = this.credentialsMap.get(username);
        if (uc == null || !uc.existUsernamePassword(entity)) {
            return false;
        }
        uc.removeUsernamePassword(entity);
        this.saveCredentials();
        return true;
    }

    public void saveCredentials() throws IOException {
        if (this.storage != null) {
            this.saveToFile();
        }
    }

    private void loadCredentials() throws IOException {
        if (this.storage != null) {
            this.loadFromFile();
        }
    }

    private void loadFromFile() throws IOException {
        try {
            CredentialsInfoSaving info;
            String json = this.storage.loadCredentials();
            if (this.encryptor != null && StringUtils.isNotBlank((CharSequence)json)) {
                json = this.encryptor.decrypt(json);
            }
            if ((info = CredentialsInfoSaving.fromJson(json)) != null) {
                this.credentialsMap = info.credentialsMap;
            }
        }
        catch (IOException e) {
            throw new IOException("Error loading credentials file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile() throws IOException {
        String jsonString;
        Map<String, UserCredentials> map = this.credentialsMap;
        synchronized (map) {
            CredentialsInfoSaving info = new CredentialsInfoSaving();
            info.credentialsMap = this.credentialsMap;
            jsonString = this.gson.toJson((Object)info);
        }
        try {
            if (this.encryptor != null) {
                jsonString = this.encryptor.encrypt(jsonString);
            }
            this.storage.saveCredentials(jsonString);
        }
        catch (IOException e) {
            throw new IOException("Error saving credentials file", e);
        }
    }
}

