/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.swing;

import com.openhtmltopdf.event.DocumentListener;
import com.openhtmltopdf.extend.FSStream;
import com.openhtmltopdf.extend.FSStreamFactory;
import com.openhtmltopdf.extend.FSUriResolver;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.resource.CSSResource;
import com.openhtmltopdf.resource.ImageResource;
import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.swing.AWTFSImage;
import com.openhtmltopdf.util.ImageUtil;
import com.openhtmltopdf.util.XRLog;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class NaiveUserAgent
implements UserAgentCallback,
DocumentListener {
    protected final LinkedHashMap<String, ImageResource> _imageCache = new LinkedHashMap();
    protected final FSUriResolver DEFAULT_URI_RESOLVER;
    protected FSUriResolver _resolver = this.DEFAULT_URI_RESOLVER = new DefaultUriResolver();
    protected String _baseUri;
    protected Map<String, FSStreamFactory> _protocolsStreamFactory = new HashMap<String, FSStreamFactory>(2);

    public NaiveUserAgent() {
        DefaultHttpStreamFactory factory = new DefaultHttpStreamFactory();
        this._protocolsStreamFactory.put("http", factory);
        this._protocolsStreamFactory.put("https", factory);
    }

    public void setProtocolsStreamFactory(Map<String, FSStreamFactory> protocolsStreamFactory) {
        this._protocolsStreamFactory = protocolsStreamFactory;
    }

    public void setUriResolver(FSUriResolver resolver) {
        this._resolver = resolver;
    }

    public FSUriResolver getDefaultUriResolver() {
        return this.DEFAULT_URI_RESOLVER;
    }

    @Deprecated
    public void clearImageCache() {
        this._imageCache.clear();
    }

    protected FSStreamFactory getProtocolFactory(String protocol) {
        return this._protocolsStreamFactory.get(protocol);
    }

    protected boolean hasProtocolFactory(String protocol) {
        return this._protocolsStreamFactory.containsKey(protocol);
    }

    protected InputStream openStream(String uri) {
        InputStream is = null;
        try {
            URI urlObj = new URI(uri);
            String protocol = urlObj.getScheme();
            if (this.hasProtocolFactory(protocol)) {
                return this.getProtocolFactory(protocol).getUrl(uri).getStream();
            }
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.exception("bad URL given: " + uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.exception("item at URI " + uri + " not found", e);
            }
            catch (IOException e) {
                XRLog.exception("IO problem for " + uri, e);
            }
        }
        catch (URISyntaxException e1) {
            XRLog.exception("bad URL given: " + uri, e1);
        }
        return is;
    }

    protected Reader openReader(String uri) {
        InputStream is = null;
        try {
            URI urlObj = new URI(uri);
            String protocol = urlObj.getScheme();
            if (this.hasProtocolFactory(protocol)) {
                return this.getProtocolFactory(protocol).getUrl(uri).getReader();
            }
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.exception("bad URL given: " + uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.exception("item at URI " + uri + " not found");
            }
            catch (IOException e) {
                XRLog.exception("IO problem for " + uri, e);
            }
        }
        catch (URISyntaxException e1) {
            XRLog.exception("bad URL given: " + uri, e1);
        }
        try {
            return is == null ? null : new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            XRLog.exception("Failed to create stream reader", e);
            return null;
        }
    }

    protected String readAll(Reader reader) throws IOException {
        int numCharsRead;
        char[] arr = new char[8192];
        StringBuilder buffer = new StringBuilder();
        while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
            buffer.append(arr, 0, numCharsRead);
        }
        return buffer.toString();
    }

    @Override
    public CSSResource getCSSResource(String uri) {
        String resolved = this._resolver.resolveURI(this._baseUri, uri);
        if (resolved == null) {
            XRLog.load(Level.INFO, "URI resolver rejected loading CSS resource at (" + uri + ")");
            return null;
        }
        return new CSSResource(this.openReader(resolved));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageResource getImageResource(String uri) {
        if (ImageUtil.isEmbeddedBase64Image(uri)) {
            BufferedImage image = ImageUtil.loadEmbeddedBase64Image(uri);
            return new ImageResource(null, AWTFSImage.createImage(image));
        }
        String resolved = this._resolver.resolveURI(this._baseUri, uri);
        if (resolved == null) {
            XRLog.load(Level.INFO, "URI resolver rejected loading image resource at (" + uri + ")");
            return null;
        }
        ImageResource ir = this._imageCache.get(resolved);
        if (ir != null) {
            return ir;
        }
        InputStream is = this.openStream(resolved);
        if (is != null) {
            try {
                BufferedImage img = ImageIO.read(is);
                if (img == null) {
                    throw new IOException("ImageIO.read() returned null");
                }
                AWTFSImage fsImage2 = (AWTFSImage)AWTFSImage.createImage(img);
                ir = new ImageResource(resolved, fsImage2);
                this._imageCache.put(resolved, ir);
                ImageResource imageResource = ir;
                return imageResource;
            }
            catch (FileNotFoundException e) {
                XRLog.exception("Can't read image file; image at URI '" + resolved + "' not found");
            }
            catch (IOException e) {
                XRLog.exception("Can't read image file; unexpected problem for URI '" + resolved + "'", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return new ImageResource(resolved, null);
    }

    @Override
    public XMLResource getXMLResource(String uri) {
        XMLResource xMLResource;
        block9: {
            String resolved = this._resolver.resolveURI(this._baseUri, uri);
            if (resolved == null) {
                XRLog.load(Level.INFO, "URI resolver rejected loading XML resource at (" + uri + ")");
                return null;
            }
            Reader inputReader = this.openReader(resolved);
            try {
                XMLResource xMLResource2 = xMLResource = inputReader == null ? null : XMLResource.load(inputReader);
                if (inputReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputReader != null) {
                        try {
                            inputReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            inputReader.close();
        }
        return xMLResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBinaryResource(String uri) {
        if (ImageUtil.isDataUri(uri)) {
            return ImageUtil.getEmbeddedDataUri(uri);
        }
        String resolved = this._resolver.resolveURI(this._baseUri, uri);
        if (resolved == null) {
            XRLog.load(Level.INFO, "URI resolver rejected loading binary resource at (" + uri + ")");
            return null;
        }
        InputStream is = this.openStream(resolved);
        if (is == null) {
            return null;
        }
        try {
            byte[] bytes2;
            int i;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buf = new byte[10240];
            while ((i = is.read(buf)) != -1) {
                result.write(buf, 0, i);
            }
            is.close();
            is = null;
            byte[] byArray = bytes2 = result.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean isVisited(String uri) {
        return false;
    }

    @Override
    public void setBaseURL(String uri) {
        this._baseUri = uri;
    }

    @Override
    public String getBaseURL() {
        return this._baseUri;
    }

    @Override
    @Deprecated
    public void documentStarted() {
        this.clearImageCache();
    }

    @Override
    @Deprecated
    public void documentLoaded() {
    }

    @Override
    @Deprecated
    public void onLayoutException(Throwable t) {
    }

    @Override
    @Deprecated
    public void onRenderException(Throwable t) {
    }

    @Override
    public String resolveURI(String uri) {
        return this._resolver.resolveURI(this.getBaseURL(), uri);
    }

    @Override
    public String resolveUri(String baseUri, String uri) {
        return this._resolver.resolveURI(baseUri, uri);
    }

    public static class DefaultUriResolver
    implements FSUriResolver {
        @Override
        public String resolveURI(String baseUri, String uri) {
            if (uri == null || uri.isEmpty()) {
                return null;
            }
            try {
                URI possiblyRelative = new URI(uri);
                if (possiblyRelative.isAbsolute()) {
                    return possiblyRelative.toString();
                }
                if (baseUri == null) {
                    XRLog.load(Level.WARNING, "Couldn't resolve relative URI(" + uri + ") because no base URI was provided.");
                    return null;
                }
                if (baseUri.startsWith("jar")) {
                    URL base = new URL(baseUri);
                    URL absolute = new URL(base, uri);
                    return absolute.toString();
                }
                URI base = new URI(baseUri);
                URI absolute = base.resolve(uri);
                return absolute.toString();
            }
            catch (URISyntaxException e) {
                XRLog.exception("When trying to load uri(" + uri + ") with base URI(" + baseUri + "), one or both were invalid URIs.", e);
                return null;
            }
            catch (MalformedURLException e) {
                XRLog.exception("When trying to load uri(" + uri + ") with base jar scheme URI(" + baseUri + "), one or both were invalid URIs.", e);
                return null;
            }
        }
    }

    public static class DefaultHttpStreamFactory
    implements FSStreamFactory {
        @Override
        public FSStream getUrl(String uri) {
            InputStream is = null;
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.exception("bad URL given: " + uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.exception("item at URI " + uri + " not found");
            }
            catch (IOException e) {
                XRLog.exception("IO problem for " + uri, e);
            }
            return new DefaultHttpStream(is);
        }
    }

    public static class DefaultHttpStream
    implements FSStream {
        private InputStream strm;

        public DefaultHttpStream(InputStream strm) {
            this.strm = strm;
        }

        @Override
        public InputStream getStream() {
            return this.strm;
        }

        @Override
        public Reader getReader() {
            if (this.strm != null) {
                try {
                    return new InputStreamReader(this.strm, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    XRLog.exception("Exception when creating stream reader", e);
                }
            }
            return null;
        }
    }
}

