/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.server;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHtmlServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexHtmlServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String TAG_BODY_OPENING = "<body";
    private static final String TAG_BODY_CLOSING = "</body>";
    private static final String TAG_HEAD_CLOSING = "</head>";
    private static final String TAG_HTML_CLOSING = "</html>";
    final String bodyAddon;
    final String headAddon;

    public IndexHtmlServlet(ZeppelinConfiguration conf) {
        this.bodyAddon = conf.getHtmlBodyAddon();
        this.headAddon = conf.getHtmlHeadAddon();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            URL indexResource = this.getServletContext().getResource("/index.html");
            String content = IOUtils.toString((URL)indexResource, (Charset)StandardCharsets.UTF_8);
            if (this.bodyAddon != null) {
                content = content.contains(TAG_BODY_CLOSING) ? content.replace(TAG_BODY_CLOSING, this.bodyAddon + TAG_BODY_CLOSING) : (content.contains(TAG_HTML_CLOSING) ? content.replace(TAG_HTML_CLOSING, this.bodyAddon + TAG_HTML_CLOSING) : content + this.bodyAddon);
            }
            if (this.headAddon != null) {
                if (content.contains(TAG_HEAD_CLOSING)) {
                    content = content.replace(TAG_HEAD_CLOSING, this.headAddon + TAG_HEAD_CLOSING);
                } else if (content.contains(TAG_BODY_OPENING)) {
                    content = content.replace(TAG_BODY_OPENING, this.headAddon + TAG_BODY_OPENING);
                } else {
                    LOGGER.error("Unable to process Head html addon. Could not find proper anchor in index.html.");
                }
            }
            resp.setContentType("text/html");
            resp.setStatus(200);
            resp.getWriter().append(content);
        }
        catch (IOException e) {
            LOGGER.error("Error rendering index.html.", (Throwable)e);
        }
    }
}

