/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.graph.neo4j.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.zeppelin.tabledata.Node;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.types.Relationship;

public class Neo4jConversionUtils {
    public static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final String[] LETTERS = "0123456789ABCDEF".split("");
    public static final String COLOR_GREY = "#D3D3D3";

    private Neo4jConversionUtils() {
    }

    public static Node toZeppelinNode(org.neo4j.driver.types.Node n, Map<String, String> graphLabels) {
        LinkedHashSet<String> labels = new LinkedHashSet<String>();
        String firstLabel = null;
        for (String label : n.labels()) {
            if (firstLabel == null) {
                firstLabel = label;
            }
            labels.add(label);
        }
        return new Node(n.id(), n.asMap(Neo4jConversionUtils::convertValue), labels);
    }

    public static String convertValue(Value val) {
        if (val == null) {
            return null;
        }
        try {
            String value = val.hasType(InternalTypeSystem.TYPE_SYSTEM.LIST()) || val.hasType(InternalTypeSystem.TYPE_SYSTEM.MAP()) ? JSON_MAPPER.writeValueAsString(val.asObject()) : val.asObject().toString();
            return value;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static org.apache.zeppelin.tabledata.Relationship toZeppelinRelationship(Relationship r) {
        return new org.apache.zeppelin.tabledata.Relationship(r.id(), r.asMap(Neo4jConversionUtils::convertValue), r.startNodeId(), r.endNodeId(), r.type());
    }

    public static String getRandomLabelColor() {
        char[] color = new char[7];
        color[0] = 35;
        for (int i = 1; i < color.length; ++i) {
            color[i] = LETTERS[(int)Math.floor(Math.random() * 16.0)].charAt(0);
        }
        return new String(color);
    }
}

