/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.function.Function;
import org.neo4j.driver.internal.shaded.reactor.core.CorePublisher;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxContextStart;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.util.context.Context;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

class ContextTrackingFunctionWrapper<T, V>
implements Function<CorePublisher<T>, CorePublisher<V>> {
    static final String CONTEXT_MARKER_PREFIX = "org.neo4j.driver.internal.shaded.reactor.core.context.marker.";
    final Function<? super Publisher<T>, ? extends Publisher<V>> transformer;

    ContextTrackingFunctionWrapper(Function<? super Publisher<T>, ? extends Publisher<V>> transformer) {
        this.transformer = transformer;
    }

    @Override
    public CorePublisher<V> apply(CorePublisher<T> self) {
        final String key = CONTEXT_MARKER_PREFIX + System.identityHashCode(self);
        final Publisher<V> newSource = Operators.liftPublisher((p, actual) -> {
            Context ctx = actual.currentContext();
            if (!ctx.hasKey(key)) {
                throw new IllegalStateException("Context loss after applying " + this.transformer);
            }
            Context newContext = ctx.delete(key);
            return new FluxContextStart.ContextStartSubscriber(actual, newContext);
        }).andThen(this.transformer).apply(self);
        return new CorePublisher<V>(){

            @Override
            public void subscribe(CoreSubscriber<? super V> actual) {
                Context ctx = actual.currentContext().put(key, true);
                FluxContextStart.ContextStartSubscriber subscriber = new FluxContextStart.ContextStartSubscriber(actual, ctx);
                if (newSource instanceof CorePublisher) {
                    ((CorePublisher)newSource).subscribe(subscriber);
                } else {
                    newSource.subscribe(subscriber);
                }
            }

            @Override
            public void subscribe(Subscriber<? super V> subscriber) {
                this.subscribe(Operators.toCoreSubscriber(subscriber));
            }
        };
    }
}

