/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.neo4j.driver.internal.shaded.reactor.core.Exceptions;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxProcessor;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.RingBuffer;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.neo4j.driver.internal.shaded.reactor.util.concurrent.Queues;
import org.neo4j.driver.internal.shaded.reactor.util.concurrent.WaitStrategy;
import org.neo4j.driver.internal.shaded.reactor.util.context.Context;
import org.reactivestreams.Subscription;

abstract class EventLoopProcessor<IN>
extends FluxProcessor<IN, IN>
implements Runnable {
    final ExecutorService executor;
    final ExecutorService requestTaskExecutor;
    final EventLoopContext contextClassLoader;
    final String name;
    final boolean autoCancel;
    final RingBuffer<Slot<IN>> ringBuffer;
    final WaitStrategy readWait = WaitStrategy.liteBlocking();
    Subscription upstreamSubscription;
    volatile boolean cancelled;
    volatile int terminated;
    volatile Throwable error;
    volatile int subscriberCount;
    static final int SHUTDOWN = 1;
    static final int FORCED_SHUTDOWN = 2;
    static final AtomicIntegerFieldUpdater<EventLoopProcessor> SUBSCRIBER_COUNT = AtomicIntegerFieldUpdater.newUpdater(EventLoopProcessor.class, "subscriberCount");
    static final AtomicIntegerFieldUpdater<EventLoopProcessor> TERMINATED = AtomicIntegerFieldUpdater.newUpdater(EventLoopProcessor.class, "terminated");

    static <E> Flux<E> coldSource(RingBuffer<Slot<E>> ringBuffer, @Nullable Throwable t, @Nullable Throwable error, RingBuffer.Sequence start) {
        Flux bufferIterable = EventLoopProcessor.generate(start::getAsLong, (seq, sink) -> {
            long s = seq + 1L;
            if (s > ringBuffer.getCursor()) {
                sink.complete();
            } else {
                Object d = ((Slot)ringBuffer.get((long)s)).value;
                if (d != null) {
                    sink.next(d);
                }
            }
            return s;
        });
        if (error != null) {
            if (t != null) {
                t = Exceptions.addSuppressed(t, error);
                return EventLoopProcessor.concat(bufferIterable, Flux.error(t));
            }
            return EventLoopProcessor.concat(bufferIterable, Flux.error(error));
        }
        return bufferIterable;
    }

    static Runnable createRequestTask(Subscription upstream, EventLoopProcessor<?> p, @Nullable Consumer<Long> postWaitCallback, LongSupplier readCount) {
        return new RequestTask(upstream, p, postWaitCallback, readCount);
    }

    static boolean waitRequestOrTerminalEvent(LongSupplier pendingRequest, RingBuffer.Reader barrier, AtomicBoolean isRunning, LongSupplier nextSequence, Runnable waiter) {
        try {
            while (pendingRequest.getAsLong() <= 0L) {
                long waitedSequence = nextSequence.getAsLong() + 1L;
                waiter.run();
                barrier.waitFor(waitedSequence, waiter);
                if (!isRunning.get()) {
                    WaitStrategy.alert();
                }
                LockSupport.parkNanos(1L);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            if (!isRunning.get() || WaitStrategy.isAlert(e)) {
                return false;
            }
            throw e;
        }
        return true;
    }

    static void addCap(RingBuffer.Sequence sequence, long toAdd) {
        long u;
        long r;
        do {
            if ((r = sequence.getAsLong()) != Long.MAX_VALUE) continue;
            return;
        } while (!sequence.compareAndSet(r, u = Operators.addCap(r, toAdd)));
    }

    static long getAndSub(RingBuffer.Sequence sequence, long toSub) {
        long u;
        long r;
        do {
            if ((r = sequence.getAsLong()) != 0L && r != Long.MAX_VALUE) continue;
            return r;
        } while (!sequence.compareAndSet(r, u = Operators.subOrZero(r, toSub)));
        return r;
    }

    EventLoopProcessor(int bufferSize, @Nullable ThreadFactory threadFactory, @Nullable ExecutorService executor, ExecutorService requestExecutor, boolean autoCancel, boolean multiproducers, Supplier<Slot<IN>> factory, WaitStrategy strategy) {
        if (!Queues.isPowerOfTwo(bufferSize)) {
            throw new IllegalArgumentException("bufferSize must be a power of 2 : " + bufferSize);
        }
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must be strictly positive, was: " + bufferSize);
        }
        this.autoCancel = autoCancel;
        this.contextClassLoader = new EventLoopContext(multiproducers);
        this.name = EventLoopProcessor.defaultName(threadFactory, this.getClass());
        this.requestTaskExecutor = Objects.requireNonNull(requestExecutor, "requestTaskExecutor");
        this.executor = executor == null ? Executors.newCachedThreadPool(threadFactory) : executor;
        this.ringBuffer = multiproducers ? RingBuffer.createMultiProducer(factory, bufferSize, strategy, this) : RingBuffer.createSingleProducer(factory, bufferSize, strategy, this);
    }

    public abstract long getPending();

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.upstreamSubscription;
        }
        return super.scanUnsafe(key);
    }

    protected static String defaultName(@Nullable ThreadFactory threadFactory, Class<? extends EventLoopProcessor> clazz) {
        String name = threadFactory instanceof Supplier ? ((Supplier)((Object)threadFactory)).get().toString() : null;
        return null != name ? name : clazz.getSimpleName();
    }

    protected static ExecutorService defaultRequestTaskExecutor(String name) {
        return Executors.newCachedThreadPool(r -> new Thread(r, name + "[request-task]"));
    }

    public final boolean alive() {
        return 0 == this.terminated;
    }

    public final boolean awaitAndShutdown() {
        return this.awaitAndShutdown(Duration.ofSeconds(-1L));
    }

    @Deprecated
    public final boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        try {
            this.shutdown();
            return this.executor.awaitTermination(timeout, timeUnit);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public final boolean awaitAndShutdown(Duration timeout) {
        long nanos = -1L;
        if (!timeout.isNegative()) {
            nanos = timeout.toNanos();
        }
        try {
            this.shutdown();
            return this.executor.awaitTermination(nanos, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public Stream<? extends Scannable> inners() {
        return Stream.empty();
    }

    public Flux<IN> drain() {
        return Flux.empty();
    }

    public final Flux<IN> forceShutdown() {
        int t = this.terminated;
        if (t != 2 && TERMINATED.compareAndSet(this, t, 2)) {
            this.executor.shutdownNow();
            this.requestTaskExecutor.shutdownNow();
        }
        return this.drain();
    }

    public final long getAvailableCapacity() {
        return this.ringBuffer.bufferSize() - this.ringBuffer.getPending();
    }

    @Override
    @Nullable
    public final Throwable getError() {
        return this.error;
    }

    @Override
    public final String toString() {
        return "/Processors/" + this.name + "/" + this.contextClassLoader.hashCode();
    }

    public final int hashCode() {
        return this.contextClassLoader.hashCode();
    }

    @Override
    public boolean isSerialized() {
        return this.contextClassLoader.multiproducer;
    }

    @Override
    public final boolean isTerminated() {
        return this.terminated > 0;
    }

    @Override
    public final void onComplete() {
        if (TERMINATED.compareAndSet(this, 0, 1)) {
            this.upstreamSubscription = null;
            this.doComplete();
            this.executor.shutdown();
            this.readWait.signalAllWhenBlocking();
        }
    }

    @Override
    public final void onError(Throwable t) {
        Objects.requireNonNull(t, "onError");
        if (TERMINATED.compareAndSet(this, 0, 1)) {
            this.error = t;
            this.upstreamSubscription = null;
            this.doError(t);
            this.executor.shutdown();
            this.readWait.signalAllWhenBlocking();
        } else {
            Operators.onErrorDropped(t, Context.empty());
        }
    }

    @Override
    public final void onNext(IN o) {
        Objects.requireNonNull(o, "onNext");
        long seqId = this.ringBuffer.next();
        Slot<IN> signal = this.ringBuffer.get(seqId);
        signal.value = o;
        this.ringBuffer.publish(seqId);
    }

    @Override
    public final void onSubscribe(Subscription s) {
        if (Operators.validate(this.upstreamSubscription, s)) {
            this.upstreamSubscription = s;
            try {
                if (s != Operators.emptySubscription()) {
                    this.requestTask(s);
                }
            }
            catch (Throwable t) {
                this.onError(Operators.onOperatorError(s, t, this.currentContext()));
            }
        }
    }

    @Override
    protected boolean serializeAlways() {
        return !this.contextClassLoader.multiproducer;
    }

    public final void shutdown() {
        try {
            this.onComplete();
            this.executor.shutdown();
            this.requestTaskExecutor.shutdown();
        }
        catch (Throwable t) {
            this.onError(Operators.onOperatorError(t, this.currentContext()));
        }
    }

    @Override
    public final int getBufferSize() {
        return this.ringBuffer.bufferSize();
    }

    final void cancel() {
        this.cancelled = true;
        if (TERMINATED.compareAndSet(this, 0, 1)) {
            this.executor.shutdown();
        }
        this.readWait.signalAllWhenBlocking();
    }

    protected void doComplete() {
    }

    protected void requestTask(Subscription s) {
    }

    final void decrementSubscribers() {
        Subscription subscription = this.upstreamSubscription;
        int subs = SUBSCRIBER_COUNT.decrementAndGet(this);
        if (subs == 0 && subscription != null && this.autoCancel) {
            this.upstreamSubscription = null;
            this.cancel();
        }
    }

    @Override
    public long downstreamCount() {
        return this.subscriberCount;
    }

    abstract void doError(Throwable var1);

    final boolean incrementSubscribers() {
        return SUBSCRIBER_COUNT.getAndIncrement(this) == 0;
    }

    static final class EventLoopFactory
    implements ThreadFactory,
    Supplier<String> {
        static final AtomicInteger COUNT = new AtomicInteger();
        final String name;
        final boolean daemon;

        EventLoopFactory(String name, boolean daemon) {
            this.name = name;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.name + "-" + COUNT.incrementAndGet());
            t.setDaemon(this.daemon);
            return t;
        }

        @Override
        public String get() {
            return this.name;
        }
    }

    public static final class Slot<T>
    implements Serializable {
        private static final long serialVersionUID = 5172014386416785095L;
        public T value;
    }

    static final class EventLoopContext
    extends ClassLoader {
        final boolean multiproducer;

        EventLoopContext(boolean multiproducer) {
            super(Thread.currentThread().getContextClassLoader());
            this.multiproducer = multiproducer;
        }
    }

    static final class RequestTask
    implements Runnable {
        final LongSupplier readCount;
        final Subscription upstream;
        final EventLoopProcessor<?> parent;
        final Consumer<Long> postWaitCallback;

        RequestTask(Subscription upstream, EventLoopProcessor<?> p, @Nullable Consumer<Long> postWaitCallback, LongSupplier readCount) {
            this.parent = p;
            this.readCount = readCount;
            this.postWaitCallback = postWaitCallback;
            this.upstream = upstream;
        }

        @Override
        public void run() {
            long bufferSize = this.parent.ringBuffer.bufferSize();
            long limit = bufferSize == 1L ? bufferSize : bufferSize - Math.max(bufferSize >> 2, 1L);
            long cursor = -1L;
            try {
                this.parent.run();
                this.upstream.request(bufferSize);
                while (true) {
                    long c = cursor + limit;
                    cursor = this.parent.readWait.waitFor(c, this.readCount, this.parent);
                    if (this.postWaitCallback != null) {
                        this.postWaitCallback.accept(cursor);
                    }
                    this.upstream.request(limit + (cursor - c));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                if (WaitStrategy.isAlert(t)) {
                    if (this.parent.cancelled) {
                        this.upstream.cancel();
                    }
                    return;
                }
                this.parent.onError(Operators.onOperatorError(t, this.parent.currentContext()));
            }
        }
    }
}

