/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Disposable;
import org.neo4j.driver.internal.shaded.reactor.core.Disposables;
import org.neo4j.driver.internal.shaded.reactor.core.Exceptions;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InnerOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InternalFluxOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.OperatorDisposables;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.UnicastProcessor;
import org.neo4j.driver.internal.shaded.reactor.core.scheduler.Scheduler;
import org.neo4j.driver.internal.shaded.reactor.util.concurrent.Queues;
import org.reactivestreams.Subscription;

final class FluxWindowTimeout<T>
extends InternalFluxOperator<T, Flux<T>> {
    final int maxSize;
    final long timespan;
    final Scheduler timer;

    FluxWindowTimeout(Flux<T> source, int maxSize, long timespan, Scheduler timer) {
        super(source);
        if (timespan <= 0L) {
            throw new IllegalArgumentException("Timeout period must be strictly positive");
        }
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be strictly positive");
        }
        this.timer = Objects.requireNonNull(timer, "Timer");
        this.timespan = timespan;
        this.maxSize = maxSize;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super Flux<T>> actual) {
        return new WindowTimeoutSubscriber(actual, this.maxSize, this.timespan, this.timer);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_ON) {
            return this.timer;
        }
        return super.scanUnsafe(key);
    }

    static final class WindowTimeoutSubscriber<T>
    implements InnerOperator<T, Flux<T>> {
        final CoreSubscriber<? super Flux<T>> actual;
        final long timespan;
        final Scheduler scheduler;
        final int maxSize;
        final Scheduler.Worker worker;
        final Queue<Object> queue;
        Throwable error;
        volatile boolean done;
        volatile boolean cancelled;
        volatile long requested;
        static final AtomicLongFieldUpdater<WindowTimeoutSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(WindowTimeoutSubscriber.class, "requested");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowTimeoutSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowTimeoutSubscriber.class, "wip");
        int count;
        long producerIndex;
        Subscription s;
        UnicastProcessor<T> window;
        volatile boolean terminated;
        volatile Disposable timer;
        static final AtomicReferenceFieldUpdater<WindowTimeoutSubscriber, Disposable> TIMER = AtomicReferenceFieldUpdater.newUpdater(WindowTimeoutSubscriber.class, Disposable.class, "timer");

        WindowTimeoutSubscriber(CoreSubscriber<? super Flux<T>> actual, int maxSize, long timespan, Scheduler scheduler) {
            this.actual = actual;
            this.queue = Queues.unboundedMultiproducer().get();
            this.timespan = timespan;
            this.scheduler = scheduler;
            this.maxSize = maxSize;
            this.worker = scheduler.createWorker();
        }

        @Override
        public CoreSubscriber<? super Flux<T>> actual() {
            return this.actual;
        }

        @Override
        public Stream<? extends Scannable> inners() {
            UnicastProcessor<T> w = this.window;
            return w == null ? Stream.empty() : Stream.of(w);
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.CAPACITY) {
                return this.maxSize;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.queue.size();
            }
            if (key == Scannable.Attr.RUN_ON) {
                return this.worker;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                CoreSubscriber a = this.actual;
                a.onSubscribe(this);
                if (this.cancelled) {
                    return;
                }
                UnicastProcessor w = UnicastProcessor.create();
                this.window = w;
                long r = this.requested;
                if (r != 0L) {
                    a.onNext(w);
                    if (r != Long.MAX_VALUE) {
                        REQUESTED.decrementAndGet(this);
                    }
                } else {
                    a.onError(Operators.onOperatorError(s, Exceptions.failWithOverflow(), this.actual.currentContext()));
                    return;
                }
                if (OperatorDisposables.replace(TIMER, this, this.newPeriod())) {
                    s.request(Long.MAX_VALUE);
                }
            }
        }

        Disposable newPeriod() {
            try {
                return this.worker.schedulePeriodically(new ConsumerIndexHolder(this.producerIndex, this), this.timespan, this.timespan, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                this.actual.onError(Operators.onRejectedExecution(e, this.s, null, null, this.actual.currentContext()));
                return Disposables.disposed();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onNext(T t) {
            if (this.terminated) {
                return;
            }
            if (WIP.get(this) == 0 && WIP.compareAndSet(this, 0, 1)) {
                UnicastProcessor<T> unicastProcessor = this.window;
                unicastProcessor.onNext(t);
                int c = this.count + 1;
                if (c >= this.maxSize) {
                    ++this.producerIndex;
                    this.count = 0;
                    unicastProcessor.onComplete();
                    long r = this.requested;
                    if (r == 0L) {
                        this.window = null;
                        this.actual.onError(Operators.onOperatorError(this.s, Exceptions.failWithOverflow(), t, this.actual.currentContext()));
                        this.timer.dispose();
                        this.worker.dispose();
                        return;
                    }
                    UnicastProcessor unicastProcessor2 = UnicastProcessor.create();
                    this.window = unicastProcessor2;
                    this.actual.onNext(unicastProcessor2);
                    if (r != Long.MAX_VALUE) {
                        REQUESTED.decrementAndGet(this);
                    }
                    Disposable tm = this.timer;
                    tm.dispose();
                    Disposable task = this.newPeriod();
                    if (!TIMER.compareAndSet(this, tm, task)) {
                        task.dispose();
                    }
                } else {
                    this.count = c;
                }
                if (WIP.decrementAndGet(this) == 0) {
                    return;
                }
            } else {
                this.queue.offer(t);
                if (!this.enter()) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.actual.onError(t);
            this.timer.dispose();
            this.worker.dispose();
        }

        @Override
        public void onComplete() {
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.actual.onComplete();
            this.timer.dispose();
            this.worker.dispose();
        }

        @Override
        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.addCap(REQUESTED, this, n);
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        void drainLoop() {
            Queue<Object> q = this.queue;
            CoreSubscriber<Flux<UnicastProcessor<Object>>> a = this.actual;
            UnicastProcessor<Object> w = this.window;
            int missed = 1;
            while (true) {
                if (this.terminated) {
                    this.s.cancel();
                    q.clear();
                    this.timer.dispose();
                    this.worker.dispose();
                    return;
                }
                boolean d = this.done;
                Object o = q.poll();
                boolean empty = o == null;
                boolean isHolder = o instanceof ConsumerIndexHolder;
                if (d && (empty || isHolder)) {
                    this.window = null;
                    q.clear();
                    Throwable err = this.error;
                    if (err != null) {
                        w.onError(err);
                    } else {
                        w.onComplete();
                    }
                    this.timer.dispose();
                    this.worker.dispose();
                    return;
                }
                if (!empty) {
                    if (isHolder) {
                        w.onComplete();
                        this.count = 0;
                        w = UnicastProcessor.create();
                        this.window = w;
                        long r = this.requested;
                        if (r != 0L) {
                            a.onNext(w);
                            if (r == Long.MAX_VALUE) continue;
                            REQUESTED.decrementAndGet(this);
                            continue;
                        }
                        this.window = null;
                        this.queue.clear();
                        a.onError(Operators.onOperatorError(this.s, Exceptions.failWithOverflow(), this.actual.currentContext()));
                        this.timer.dispose();
                        this.worker.dispose();
                        return;
                    }
                    w.onNext(o);
                    int c = this.count + 1;
                    if (c >= this.maxSize) {
                        ++this.producerIndex;
                        this.count = 0;
                        w.onComplete();
                        long r = this.requested;
                        if (r != 0L) {
                            w = UnicastProcessor.create();
                            this.window = w;
                            this.actual.onNext(w);
                            if (r != Long.MAX_VALUE) {
                                REQUESTED.decrementAndGet(this);
                            }
                            Disposable tm = this.timer;
                            tm.dispose();
                            Disposable task = this.newPeriod();
                            if (TIMER.compareAndSet(this, tm, task)) continue;
                            task.dispose();
                            continue;
                        }
                        this.window = null;
                        a.onError(Operators.onOperatorError(this.s, Exceptions.failWithOverflow(), o, this.actual.currentContext()));
                        this.timer.dispose();
                        this.worker.dispose();
                        return;
                    }
                    this.count = c;
                    continue;
                }
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
            }
        }

        boolean enter() {
            return WIP.getAndIncrement(this) == 0;
        }

        static final class ConsumerIndexHolder
        implements Runnable {
            final long index;
            final WindowTimeoutSubscriber<?> parent;

            ConsumerIndexHolder(long index, WindowTimeoutSubscriber<?> parent) {
                this.index = index;
                this.parent = parent;
            }

            @Override
            public void run() {
                WindowTimeoutSubscriber<?> p = this.parent;
                if (!p.cancelled) {
                    p.queue.offer(this);
                } else {
                    p.terminated = true;
                    p.timer.dispose();
                    p.worker.dispose();
                }
                if (p.enter()) {
                    p.drainLoop();
                }
            }
        }
    }
}

