/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.filter.Filter;

@JinjavaDoc(value="Evaluates to true if the value is divisible by the given number", input={@JinjavaParam(value="value", type="number", desc="The value to be divided", required=true)}, params={@JinjavaParam(value="divisor", type="number", desc="The divisor to check if the value is divisible by", required=true)}, snippets={@JinjavaSnippet(desc="This example is an alternative to using the is divisibleby expression test", code="{% set num = 10 %}\n{% if num|divisible(2) %}\n    The number is divisble by 2\n{% endif %}")})
public class DivisibleFilter
implements Filter {
    @Override
    public Object filter(Object object, JinjavaInterpreter interpreter, String ... arg) {
        if (object == null) {
            return false;
        }
        if (object instanceof Number) {
            if (arg.length < 1) {
                throw new TemplateSyntaxException(interpreter, this.getName(), "requires 1 argument (number to divide by)");
            }
            long factor = Long.parseLong(arg[0]);
            long value = ((Number)object).longValue();
            if (value % factor == 0L) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return "divisible";
    }
}

