/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.PrimitiveRegistry;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public abstract class AbstractAsyncPrimitive<A extends AsyncPrimitive, S>
implements AsyncPrimitive {
    private final ProxyClient<S> client;
    private final PrimitiveRegistry registry;

    protected AbstractAsyncPrimitive(ProxyClient<S> client, PrimitiveRegistry registry) {
        this.client = (ProxyClient)Preconditions.checkNotNull(client, (Object)"proxy cannot be null");
        this.registry = (PrimitiveRegistry)Preconditions.checkNotNull((Object)registry, (Object)"registry cannot be null");
        client.register(this);
    }

    @Override
    public String name() {
        return this.client.name();
    }

    @Override
    public PrimitiveType type() {
        return this.client.type();
    }

    @Override
    public PrimitiveProtocol protocol() {
        return this.client.protocol();
    }

    protected ProxyClient<S> getProxyClient() {
        return this.client;
    }

    @Override
    public void addStateChangeListener(Consumer<PrimitiveState> listener) {
        this.client.addStateChangeListener(listener);
    }

    @Override
    public void removeStateChangeListener(Consumer<PrimitiveState> listener) {
        this.client.removeStateChangeListener(listener);
    }

    public CompletableFuture<A> connect() {
        return this.registry.createPrimitive(this.name(), this.type()).thenApply(v -> this);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.client.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("proxy", this.client).toString();
    }
}

