/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.event;

import io.atomix.primitive.event.Event;
import io.atomix.primitive.event.EventType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class Events {
    public static Map<Method, EventType> getMethodMap(Class<?> serviceInterface) {
        if (!serviceInterface.isInterface()) {
            HashMap<Method, EventType> events = new HashMap<Method, EventType>();
            for (Class<?> iface : serviceInterface.getInterfaces()) {
                events.putAll(Events.findMethods(iface));
            }
            return events;
        }
        return Events.findMethods(serviceInterface);
    }

    private static Map<Method, EventType> findMethods(Class<?> type) {
        HashMap<Method, EventType> events = new HashMap<Method, EventType>();
        for (Method method : type.getDeclaredMethods()) {
            Event event = method.getAnnotation(Event.class);
            if (event == null) continue;
            String name = event.value().equals("") ? method.getName() : event.value();
            events.put(method, EventType.from(name));
        }
        for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
            events.putAll(Events.findMethods(genericDeclaration));
        }
        return events;
    }

    public static Map<EventType, Method> getEventMap(Class<?> serviceInterface) {
        if (!serviceInterface.isInterface()) {
            HashMap<EventType, Method> events = new HashMap<EventType, Method>();
            for (Class<?> type = serviceInterface; type != Object.class; type = type.getSuperclass()) {
                for (Class<?> iface : type.getInterfaces()) {
                    events.putAll(Events.findEvents(iface));
                }
            }
            return events;
        }
        return Events.findEvents(serviceInterface);
    }

    private static Map<EventType, Method> findEvents(Class<?> type) {
        HashMap<EventType, Method> events = new HashMap<EventType, Method>();
        for (Method method : type.getDeclaredMethods()) {
            Event event = method.getAnnotation(Event.class);
            if (event == null) continue;
            String name = event.value().equals("") ? method.getName() : event.value();
            events.put(EventType.from(name), method);
        }
        for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
            events.putAll(Events.findEvents(genericDeclaration));
        }
        return events;
    }

    private Events() {
    }
}

