/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.session.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.event.EventType;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.serializer.Serializer;
import java.util.function.Consumer;

public abstract class AbstractSession
implements Session {
    private final SessionId sessionId;
    private final String primitiveName;
    private final PrimitiveType primitiveType;
    private final MemberId memberId;
    private final Serializer serializer;

    protected AbstractSession(SessionId sessionId, String primitiveName, PrimitiveType primitiveType, MemberId memberId, Serializer serializer) {
        this.sessionId = (SessionId)((Object)Preconditions.checkNotNull((Object)((Object)sessionId)));
        this.primitiveName = (String)Preconditions.checkNotNull((Object)primitiveName);
        this.primitiveType = (PrimitiveType)Preconditions.checkNotNull((Object)primitiveType);
        this.memberId = (MemberId)Preconditions.checkNotNull((Object)memberId);
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer);
    }

    @Override
    public SessionId sessionId() {
        return this.sessionId;
    }

    @Override
    public String primitiveName() {
        return this.primitiveName;
    }

    @Override
    public PrimitiveType primitiveType() {
        return this.primitiveType;
    }

    @Override
    public MemberId memberId() {
        return this.memberId;
    }

    protected <T> byte[] encode(T object) {
        return object != null ? this.serializer.encode(object) : null;
    }

    protected <T> T decode(byte[] bytes) {
        return (T)(bytes != null ? this.serializer.decode(bytes) : null);
    }

    @Override
    public abstract void publish(PrimitiveEvent var1);

    public void publish(EventType eventType, Object event) {
        this.publish(PrimitiveEvent.event(eventType, this.encode(event)));
    }

    public void accept(Consumer event) {
        throw new UnsupportedOperationException();
    }
}

