/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import java.util.Map;
import org.apache.zeppelin.cluster.ClusterCallback;
import org.apache.zeppelin.cluster.ClusterManagerServer;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.ClusterInterpreterProcess;
import org.apache.zeppelin.interpreter.launcher.DockerInterpreterProcess;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterInterpreterCheckThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterInterpreterCheckThread.class);
    private InterpreterClient intpProcess;
    private String intpGroupId;
    private int connectTimeout;

    ClusterInterpreterCheckThread(InterpreterClient intpProcess, String intpGroupId, int connectTimeout) {
        this.intpProcess = intpProcess;
        this.intpGroupId = intpGroupId;
        this.connectTimeout = connectTimeout;
    }

    @Override
    public void run() {
        LOGGER.info("ClusterInterpreterCheckThread run() >>>");
        ClusterManagerServer clusterServer = ClusterManagerServer.getInstance((ZeppelinConfiguration)ZeppelinConfiguration.create());
        clusterServer.getIntpProcessStatus(this.intpGroupId, this.connectTimeout, (ClusterCallback)new ClusterCallback<Map<String, Object>>(){

            public InterpreterClient online(Map<String, Object> result) {
                String intpTSrvHost = (String)result.get("INTP_TSERVER_HOST");
                int intpTSrvPort = (Integer)result.get("INTP_TSERVER_PORT");
                LOGGER.info("Found cluster interpreter {}:{}", (Object)intpTSrvHost, (Object)intpTSrvPort);
                if (ClusterInterpreterCheckThread.this.intpProcess instanceof DockerInterpreterProcess) {
                    ((DockerInterpreterProcess)ClusterInterpreterCheckThread.this.intpProcess).processStarted(intpTSrvPort, intpTSrvHost);
                } else if (ClusterInterpreterCheckThread.this.intpProcess instanceof ClusterInterpreterProcess) {
                    ((ClusterInterpreterProcess)ClusterInterpreterCheckThread.this.intpProcess).processStarted(intpTSrvPort, intpTSrvHost);
                } else {
                    LOGGER.error("Unknown type !");
                }
                return null;
            }

            public void offline() {
                LOGGER.error("Can not found cluster interpreter!");
            }
        });
        LOGGER.info("ClusterInterpreterCheckThread run() <<<");
    }
}

