/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.bidi.support;

import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.util.XRLog;
import java.util.logging.Level;

public class ICUBidiReorderer
implements BidiReorderer {
    ArabicShaping shaper = new ArabicShaping(8);
    ArabicShaping deshaper = new ArabicShaping(16);

    public String reorderRTLTextToLTR(String text) {
        return Bidi.writeReverse((String)text, (int)2);
    }

    public String shapeText(String text) {
        try {
            return this.shaper.shape(text);
        }
        catch (ArabicShapingException e) {
            XRLog.general((Level)Level.WARNING, (String)"Exception while shaping text", (Throwable)e);
            return text;
        }
    }

    public String deshapeText(String text) {
        try {
            return this.deshaper.shape(text);
        }
        catch (ArabicShapingException e) {
            XRLog.general((Level)Level.WARNING, (String)"Exception while deshaping text", (Throwable)e);
            return text;
        }
    }

    public boolean isLiveImplementation() {
        return true;
    }
}

