/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.statistics;

import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageStatistics {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageStatistics.class);
    private final File file;
    private final MBeanServer mBeanServer;

    public StorageStatistics(File file) {
        this.file = file;
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    public long getUsableSpace() {
        return this.file.getUsableSpace();
    }

    public long getFreeSpace() {
        return this.file.getFreeSpace();
    }

    public long getTotalSpace() {
        return this.file.getTotalSpace();
    }

    public long getFreeMemory() {
        try {
            return (Long)this.mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "FreePhysicalMemorySize");
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("An exception occurred during memory check", (Throwable)e);
            }
            return -1L;
        }
    }

    public long getTotalMemory() {
        try {
            return (Long)this.mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize");
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("An exception occurred during memory check", (Throwable)e);
            }
            return -1L;
        }
    }
}

