/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree;

import org.apache.lucene.bkdtree.HeapLatLonReader;
import org.apache.lucene.bkdtree.LatLonReader;
import org.apache.lucene.bkdtree.LatLonWriter;
import org.apache.lucene.util.ArrayUtil;

final class GrowingHeapLatLonWriter
implements LatLonWriter {
    int[] latEncs = new int[16];
    int[] lonEncs = new int[16];
    int[] docIDs = new int[16];
    long[] ords = new long[16];
    private int nextWrite;
    final int maxSize;

    public GrowingHeapLatLonWriter(int maxSize) {
        this.maxSize = maxSize;
    }

    private int[] growExact(int[] arr, int size) {
        assert (size > arr.length);
        int[] newArr = new int[size];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        return newArr;
    }

    private long[] growExact(long[] arr, int size) {
        assert (size > arr.length);
        long[] newArr = new long[size];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        return newArr;
    }

    @Override
    public void append(int latEnc, int lonEnc, long ord, int docID) {
        assert (ord == (long)this.nextWrite);
        if (this.latEncs.length == this.nextWrite) {
            int nextSize = Math.min(this.maxSize, ArrayUtil.oversize(this.nextWrite + 1, 4));
            assert (nextSize > this.nextWrite) : "nextSize=" + nextSize + " vs nextWrite=" + this.nextWrite;
            this.latEncs = this.growExact(this.latEncs, nextSize);
            this.lonEncs = this.growExact(this.lonEncs, nextSize);
            this.ords = this.growExact(this.ords, nextSize);
            this.docIDs = this.growExact(this.docIDs, nextSize);
        }
        this.latEncs[this.nextWrite] = latEnc;
        this.lonEncs[this.nextWrite] = lonEnc;
        this.ords[this.nextWrite] = ord;
        this.docIDs[this.nextWrite] = docID;
        ++this.nextWrite;
    }

    @Override
    public LatLonReader getReader(long start) {
        return new HeapLatLonReader(this.latEncs, this.lonEncs, this.ords, this.docIDs, (int)start, this.nextWrite);
    }

    @Override
    public void close() {
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return "GrowingHeapLatLonWriter(count=" + this.nextWrite + " alloc=" + this.latEncs.length + ")";
    }
}

