/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BaseGlobalOrdinalScorer;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.ToStringUtils;

final class GlobalOrdinalsQuery
extends Query {
    private final LongBitSet foundOrds;
    private final String joinField;
    private final MultiDocValues.OrdinalMap globalOrds;
    private final Query toQuery;
    private final Query fromQuery;
    private final IndexReader indexReader;

    GlobalOrdinalsQuery(LongBitSet foundOrds, String joinField, MultiDocValues.OrdinalMap globalOrds, Query toQuery, Query fromQuery, IndexReader indexReader) {
        this.foundOrds = foundOrds;
        this.joinField = joinField;
        this.globalOrds = globalOrds;
        this.toQuery = toQuery;
        this.fromQuery = fromQuery;
        this.indexReader = indexReader;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new W(this, this.toQuery.createWeight(searcher, false));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GlobalOrdinalsQuery that = (GlobalOrdinalsQuery)o;
        if (!this.fromQuery.equals(that.fromQuery)) {
            return false;
        }
        if (!this.joinField.equals(that.joinField)) {
            return false;
        }
        if (!this.toQuery.equals(that.toQuery)) {
            return false;
        }
        return this.indexReader.equals(that.indexReader);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.joinField.hashCode();
        result = 31 * result + this.toQuery.hashCode();
        result = 31 * result + this.fromQuery.hashCode();
        result = 31 * result + this.indexReader.hashCode();
        return result;
    }

    @Override
    public String toString(String field) {
        return "GlobalOrdinalsQuery{joinField=" + this.joinField + '}' + ToStringUtils.boost(this.getBoost());
    }

    static final class SegmentOrdinalScorer
    extends BaseGlobalOrdinalScorer {
        final LongBitSet foundOrds;

        public SegmentOrdinalScorer(Weight weight, float score, LongBitSet foundOrds, SortedDocValues values, DocIdSetIterator approximationScorer) {
            super(weight, values, approximationScorer);
            this.score = score;
            this.foundOrds = foundOrds;
        }

        @Override
        protected TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator approximation) {
            return new TwoPhaseIterator(approximation){

                @Override
                public boolean matches() throws IOException {
                    long segmentOrd = SegmentOrdinalScorer.this.values.getOrd(this.approximation.docID());
                    return segmentOrd != -1L && SegmentOrdinalScorer.this.foundOrds.get(segmentOrd);
                }

                @Override
                public float matchCost() {
                    return 100.0f;
                }
            };
        }
    }

    static final class OrdinalMapScorer
    extends BaseGlobalOrdinalScorer {
        final LongBitSet foundOrds;
        final LongValues segmentOrdToGlobalOrdLookup;

        public OrdinalMapScorer(Weight weight, float score, LongBitSet foundOrds, SortedDocValues values, DocIdSetIterator approximationScorer, LongValues segmentOrdToGlobalOrdLookup) {
            super(weight, values, approximationScorer);
            this.score = score;
            this.foundOrds = foundOrds;
            this.segmentOrdToGlobalOrdLookup = segmentOrdToGlobalOrdLookup;
        }

        @Override
        protected TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator approximation) {
            return new TwoPhaseIterator(approximation){

                @Override
                public boolean matches() throws IOException {
                    long globalOrd;
                    long segmentOrd = OrdinalMapScorer.this.values.getOrd(this.approximation.docID());
                    return segmentOrd != -1L && OrdinalMapScorer.this.foundOrds.get(globalOrd = OrdinalMapScorer.this.segmentOrdToGlobalOrdLookup.get(segmentOrd));
                }

                @Override
                public float matchCost() {
                    return 100.0f;
                }
            };
        }
    }

    final class W
    extends ConstantScoreWeight {
        private final Weight approximationWeight;

        W(Query query, Weight approximationWeight) {
            super(query);
            this.approximationWeight = approximationWeight;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            SortedDocValues values = DocValues.getSorted(context.reader(), GlobalOrdinalsQuery.this.joinField);
            if (values == null) {
                return Explanation.noMatch("Not a match", new Explanation[0]);
            }
            int segmentOrd = values.getOrd(doc);
            if (segmentOrd == -1) {
                return Explanation.noMatch("Not a match", new Explanation[0]);
            }
            BytesRef joinValue = values.lookupOrd(segmentOrd);
            int ord = GlobalOrdinalsQuery.this.globalOrds != null ? (int)GlobalOrdinalsQuery.this.globalOrds.getGlobalOrds(context.ord).get(segmentOrd) : segmentOrd;
            if (!GlobalOrdinalsQuery.this.foundOrds.get(ord)) {
                return Explanation.noMatch("Not a match, join value " + Term.toString(joinValue), new Explanation[0]);
            }
            return Explanation.match(this.score(), "A match, join value " + Term.toString(joinValue), new Explanation[0]);
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            SortedDocValues values = DocValues.getSorted(context.reader(), GlobalOrdinalsQuery.this.joinField);
            if (values == null) {
                return null;
            }
            Scorer approximationScorer = this.approximationWeight.scorer(context);
            if (approximationScorer == null) {
                return null;
            }
            if (GlobalOrdinalsQuery.this.globalOrds != null) {
                return new OrdinalMapScorer(this, this.score(), GlobalOrdinalsQuery.this.foundOrds, values, approximationScorer.iterator(), GlobalOrdinalsQuery.this.globalOrds.getGlobalOrds(context.ord));
            }
            return new SegmentOrdinalScorer(this, this.score(), GlobalOrdinalsQuery.this.foundOrds, values, approximationScorer.iterator());
        }
    }
}

