/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldValueHitQueue;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.search.join.FakeScorer;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.apache.lucene.util.ArrayUtil;

public class ToParentBlockJoinCollector
implements Collector {
    private final Sort sort;
    private final Map<Query, Integer> joinQueryID = new HashMap<Query, Integer>();
    private final int numParentHits;
    private final FieldValueHitQueue<OneGroup> queue;
    private final FieldComparator<?>[] comparators;
    private final boolean trackMaxScore;
    private final boolean trackScores;
    private ToParentBlockJoinQuery.BlockJoinScorer[] joinScorers = new ToParentBlockJoinQuery.BlockJoinScorer[0];
    private boolean queueFull;
    private OneGroup bottom;
    private int totalHitCount;
    private float maxScore = Float.NaN;
    private OneGroup[] sortedGroups;

    public ToParentBlockJoinCollector(Sort sort, int numParentHits, boolean trackScores, boolean trackMaxScore) throws IOException {
        this.sort = sort;
        this.trackMaxScore = trackMaxScore;
        if (trackMaxScore) {
            this.maxScore = Float.MIN_VALUE;
        }
        this.trackScores = trackScores;
        this.numParentHits = numParentHits;
        this.queue = FieldValueHitQueue.create(sort.getSort(), numParentHits);
        this.comparators = this.queue.getComparators();
    }

    @Override
    public LeafCollector getLeafCollector(final LeafReaderContext context) throws IOException {
        final LeafFieldComparator[] comparators = this.queue.getComparators(context);
        final int[] reverseMul = this.queue.getReverseMul();
        final int docBase = context.docBase;
        return new LeafCollector(){
            private Scorer scorer;

            @Override
            public void setScorer(Scorer scorer) throws IOException {
                if (!(scorer instanceof ScoreCachingWrappingScorer)) {
                    scorer = new ScoreCachingWrappingScorer(scorer);
                }
                this.scorer = scorer;
                for (LeafFieldComparator comparator : comparators) {
                    comparator.setScorer(scorer);
                }
                Arrays.fill(ToParentBlockJoinCollector.this.joinScorers, null);
                LinkedList<Scorer> queue = new LinkedList<Scorer>();
                queue.add(scorer);
                while ((scorer = (Scorer)queue.poll()) != null) {
                    if (scorer instanceof ToParentBlockJoinQuery.BlockJoinScorer) {
                        ToParentBlockJoinCollector.this.enroll((ToParentBlockJoinQuery)scorer.getWeight().getQuery(), (ToParentBlockJoinQuery.BlockJoinScorer)scorer);
                    }
                    for (Scorer.ChildScorer sub : scorer.getChildren()) {
                        queue.add(sub.child);
                    }
                }
            }

            @Override
            public void collect(int parentDoc) throws IOException {
                block10: {
                    float score;
                    block9: {
                        ToParentBlockJoinCollector.this.totalHitCount++;
                        score = Float.NaN;
                        if (ToParentBlockJoinCollector.this.trackMaxScore) {
                            score = this.scorer.score();
                            ToParentBlockJoinCollector.this.maxScore = Math.max(ToParentBlockJoinCollector.this.maxScore, score);
                        }
                        if (!ToParentBlockJoinCollector.this.queueFull) break block9;
                        int c = 0;
                        for (int i = 0; i < comparators.length && (c = reverseMul[i] * comparators[i].compareBottom(parentDoc)) == 0; ++i) {
                        }
                        if (c <= 0) {
                            return;
                        }
                        for (LeafFieldComparator comparator : comparators) {
                            comparator.copy(((ToParentBlockJoinCollector)ToParentBlockJoinCollector.this).bottom.slot, parentDoc);
                        }
                        if (!ToParentBlockJoinCollector.this.trackMaxScore && ToParentBlockJoinCollector.this.trackScores) {
                            score = this.scorer.score();
                        }
                        ((ToParentBlockJoinCollector)ToParentBlockJoinCollector.this).bottom.doc = docBase + parentDoc;
                        ((ToParentBlockJoinCollector)ToParentBlockJoinCollector.this).bottom.readerContext = context;
                        ((ToParentBlockJoinCollector)ToParentBlockJoinCollector.this).bottom.score = score;
                        this.copyGroups(ToParentBlockJoinCollector.this.bottom);
                        ToParentBlockJoinCollector.this.bottom = (OneGroup)ToParentBlockJoinCollector.this.queue.updateTop();
                        for (LeafFieldComparator comparator : comparators) {
                            comparator.setBottom(((ToParentBlockJoinCollector)ToParentBlockJoinCollector.this).bottom.slot);
                        }
                        break block10;
                    }
                    int comparatorSlot = ToParentBlockJoinCollector.this.totalHitCount - 1;
                    for (LeafFieldComparator comparator : comparators) {
                        comparator.copy(comparatorSlot, parentDoc);
                    }
                    if (!ToParentBlockJoinCollector.this.trackMaxScore && ToParentBlockJoinCollector.this.trackScores) {
                        score = this.scorer.score();
                    }
                    OneGroup og = new OneGroup(comparatorSlot, docBase + parentDoc, score, ToParentBlockJoinCollector.this.joinScorers.length, ToParentBlockJoinCollector.this.trackScores);
                    og.readerContext = context;
                    this.copyGroups(og);
                    ToParentBlockJoinCollector.this.bottom = ToParentBlockJoinCollector.this.queue.add(og);
                    ToParentBlockJoinCollector.this.queueFull = ToParentBlockJoinCollector.this.totalHitCount == ToParentBlockJoinCollector.this.numParentHits;
                    if (!ToParentBlockJoinCollector.this.queueFull) break block10;
                    for (LeafFieldComparator comparator : comparators) {
                        comparator.setBottom(((ToParentBlockJoinCollector)ToParentBlockJoinCollector.this).bottom.slot);
                    }
                }
            }

            private void copyGroups(OneGroup og) {
                int numSubScorers = ToParentBlockJoinCollector.this.joinScorers.length;
                if (og.docs.length < numSubScorers) {
                    og.docs = ArrayUtil.grow(og.docs);
                }
                if (og.counts.length < numSubScorers) {
                    og.counts = ArrayUtil.grow(og.counts);
                }
                if (ToParentBlockJoinCollector.this.trackScores && og.scores.length < numSubScorers) {
                    og.scores = ArrayUtil.grow(og.scores);
                }
                for (int scorerIDX = 0; scorerIDX < numSubScorers; ++scorerIDX) {
                    ToParentBlockJoinQuery.BlockJoinScorer joinScorer = ToParentBlockJoinCollector.this.joinScorers[scorerIDX];
                    if (joinScorer != null && docBase + joinScorer.getParentDoc() == og.doc) {
                        og.counts[scorerIDX] = joinScorer.getChildCount();
                        og.docs[scorerIDX] = joinScorer.swapChildDocs(og.docs[scorerIDX]);
                        assert (og.docs[scorerIDX].length >= og.counts[scorerIDX]) : "length=" + og.docs[scorerIDX].length + " vs count=" + og.counts[scorerIDX];
                        if (!ToParentBlockJoinCollector.this.trackScores) continue;
                        og.scores[scorerIDX] = joinScorer.swapChildScores(og.scores[scorerIDX]);
                        assert (og.scores[scorerIDX].length >= og.counts[scorerIDX]) : "length=" + og.scores[scorerIDX].length + " vs count=" + og.counts[scorerIDX];
                        continue;
                    }
                    og.counts[scorerIDX] = 0;
                }
            }
        };
    }

    private void enroll(ToParentBlockJoinQuery query, ToParentBlockJoinQuery.BlockJoinScorer scorer) {
        scorer.trackPendingChildHits();
        Integer slot = this.joinQueryID.get(query);
        if (slot == null) {
            this.joinQueryID.put(query, this.joinScorers.length);
            ToParentBlockJoinQuery.BlockJoinScorer[] newArray = new ToParentBlockJoinQuery.BlockJoinScorer[1 + this.joinScorers.length];
            System.arraycopy(this.joinScorers, 0, newArray, 0, this.joinScorers.length);
            this.joinScorers = newArray;
            this.joinScorers[this.joinScorers.length - 1] = scorer;
        } else {
            this.joinScorers[slot.intValue()] = scorer;
        }
    }

    private void sortQueue() {
        this.sortedGroups = new OneGroup[this.queue.size()];
        for (int downTo = this.queue.size() - 1; downTo >= 0; --downTo) {
            this.sortedGroups[downTo] = (OneGroup)this.queue.pop();
        }
    }

    public TopGroups<Integer> getTopGroups(ToParentBlockJoinQuery query, Sort withinGroupSort, int offset, int maxDocsPerGroup, int withinGroupOffset, boolean fillSortFields) throws IOException {
        Integer _slot = this.joinQueryID.get(query);
        if (_slot == null && this.totalHitCount == 0) {
            return null;
        }
        if (this.sortedGroups == null) {
            if (offset >= this.queue.size()) {
                return null;
            }
            this.sortQueue();
        } else if (offset > this.sortedGroups.length) {
            return null;
        }
        return this.accumulateGroups(_slot == null ? -1 : _slot, offset, maxDocsPerGroup, withinGroupOffset, withinGroupSort, fillSortFields);
    }

    private TopGroups<Integer> accumulateGroups(int slot, int offset, int maxDocsPerGroup, int withinGroupOffset, Sort withinGroupSort, boolean fillSortFields) throws IOException {
        GroupDocs[] groups = new GroupDocs[this.sortedGroups.length - offset];
        FakeScorer fakeScorer = new FakeScorer();
        int totalGroupedHitCount = 0;
        for (int groupIDX = offset; groupIDX < this.sortedGroups.length; ++groupIDX) {
            Object[] groupSortValues;
            TopDocsCollector collector;
            OneGroup og = this.sortedGroups[groupIDX];
            int numChildDocs = slot == -1 || slot >= og.counts.length ? 0 : og.counts[slot];
            int numDocsInGroup = Math.max(1, Math.min(numChildDocs, maxDocsPerGroup));
            if (withinGroupSort == null) {
                if (!this.trackScores) {
                    throw new IllegalArgumentException("cannot sort by relevance within group: trackScores=false");
                }
                collector = TopScoreDocCollector.create(numDocsInGroup);
            } else {
                collector = TopFieldCollector.create(withinGroupSort, numDocsInGroup, fillSortFields, this.trackScores, this.trackMaxScore);
            }
            LeafCollector leafCollector = collector.getLeafCollector(og.readerContext);
            leafCollector.setScorer(fakeScorer);
            for (int docIDX = 0; docIDX < numChildDocs; ++docIDX) {
                int doc;
                fakeScorer.doc = doc = og.docs[slot][docIDX];
                if (this.trackScores) {
                    fakeScorer.score = og.scores[slot][docIDX];
                }
                leafCollector.collect(doc);
            }
            totalGroupedHitCount += numChildDocs;
            if (fillSortFields) {
                groupSortValues = new Object[this.comparators.length];
                for (int sortFieldIDX = 0; sortFieldIDX < this.comparators.length; ++sortFieldIDX) {
                    groupSortValues[sortFieldIDX] = this.comparators[sortFieldIDX].value(og.slot);
                }
            } else {
                groupSortValues = null;
            }
            TopDocs topDocs = collector.topDocs(withinGroupOffset, numDocsInGroup);
            groups[groupIDX - offset] = new GroupDocs<Integer>(og.score, topDocs.getMaxScore(), numChildDocs, topDocs.scoreDocs, og.doc, groupSortValues);
        }
        return new TopGroups<Integer>(new TopGroups(this.sort.getSort(), withinGroupSort == null ? null : withinGroupSort.getSort(), 0, totalGroupedHitCount, groups, this.maxScore), this.totalHitCount);
    }

    public TopGroups<Integer> getTopGroupsWithAllChildDocs(ToParentBlockJoinQuery query, Sort withinGroupSort, int offset, int withinGroupOffset, boolean fillSortFields) throws IOException {
        return this.getTopGroups(query, withinGroupSort, offset, Integer.MAX_VALUE, withinGroupOffset, fillSortFields);
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    @Override
    public boolean needsScores() {
        return true;
    }

    private static final class OneGroup
    extends FieldValueHitQueue.Entry {
        LeafReaderContext readerContext;
        int[][] docs;
        float[][] scores;
        int[] counts;

        public OneGroup(int comparatorSlot, int parentDoc, float parentScore, int numJoins, boolean doScores) {
            super(comparatorSlot, parentDoc, parentScore);
            int joinID;
            this.docs = new int[numJoins][];
            for (joinID = 0; joinID < numJoins; ++joinID) {
                this.docs[joinID] = new int[5];
            }
            if (doScores) {
                this.scores = new float[numJoins][];
                for (joinID = 0; joinID < numJoins; ++joinID) {
                    this.scores[joinID] = new float[5];
                }
            }
            this.counts = new int[numJoins];
        }
    }
}

