/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.suggest.analyzing.FSTUtil;
import org.apache.lucene.search.suggest.document.CompletionScorer;
import org.apache.lucene.search.suggest.document.TopSuggestDocsCollector;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PairOutputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public final class NRTSuggester
implements Accountable {
    private final FST<PairOutputs.Pair<Long, BytesRef>> fst;
    private final int maxAnalyzedPathsPerOutput;
    private final int payloadSep;
    private static final long MAX_TOP_N_QUEUE_SIZE = 5000L;

    private NRTSuggester(FST<PairOutputs.Pair<Long, BytesRef>> fst, int maxAnalyzedPathsPerOutput, int payloadSep) {
        this.fst = fst;
        this.maxAnalyzedPathsPerOutput = maxAnalyzedPathsPerOutput;
        this.payloadSep = payloadSep;
    }

    @Override
    public long ramBytesUsed() {
        return this.fst == null ? 0L : this.fst.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public void lookup(final CompletionScorer scorer, final Bits acceptDocs, final TopSuggestDocsCollector collector) throws IOException {
        double liveDocsRatio = NRTSuggester.calculateLiveDocRatio(scorer.reader.numDocs(), scorer.reader.maxDoc());
        if (liveDocsRatio == -1.0) {
            return;
        }
        List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> prefixPaths = FSTUtil.intersectPrefixPaths(scorer.automaton, this.fst);
        int topN = collector.getCountToCollect() * prefixPaths.size();
        int queueSize = this.getMaxTopNSearcherQueueSize(topN, scorer.reader.numDocs(), liveDocsRatio, scorer.filtered);
        Comparator<PairOutputs.Pair<Long, BytesRef>> comparator = NRTSuggester.getComparator();
        Util.TopNSearcher<PairOutputs.Pair<Long, BytesRef>> searcher = new Util.TopNSearcher<PairOutputs.Pair<Long, BytesRef>>(this.fst, topN, queueSize, comparator, (Comparator)new ScoringPathComparator(scorer)){
            private final CharsRefBuilder spare;
            {
                super(x0, x1, x2, x3, x4);
                this.spare = new CharsRefBuilder();
            }

            @Override
            protected boolean acceptResult(Util.FSTPath<PairOutputs.Pair<Long, BytesRef>> path) {
                int payloadSepIndex = PayLoadProcessor.parseSurfaceForm((BytesRef)((PairOutputs.Pair)path.cost).output2, NRTSuggester.this.payloadSep, this.spare);
                int docID = PayLoadProcessor.parseDocID((BytesRef)((PairOutputs.Pair)path.cost).output2, payloadSepIndex);
                if (!scorer.accept(docID, acceptDocs)) {
                    return false;
                }
                try {
                    float score = scorer.score(NRTSuggester.decode((Long)((PairOutputs.Pair)path.cost).output1), path.boost);
                    collector.collect(docID, this.spare.toCharsRef(), path.context, score);
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        for (FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>> path : prefixPaths) {
            scorer.weight.setNextMatch(path.input.get());
            searcher.addStartPaths(path.fstNode, (PairOutputs.Pair<Long, BytesRef>)path.output, false, path.input, scorer.weight.boost(), scorer.weight.context());
        }
        searcher.search();
    }

    private static Comparator<PairOutputs.Pair<Long, BytesRef>> getComparator() {
        return new Comparator<PairOutputs.Pair<Long, BytesRef>>(){

            @Override
            public int compare(PairOutputs.Pair<Long, BytesRef> o1, PairOutputs.Pair<Long, BytesRef> o2) {
                return Long.compare((Long)o1.output1, (Long)o2.output1);
            }
        };
    }

    private int getMaxTopNSearcherQueueSize(int topN, int numDocs, double liveDocsRatio, boolean filterEnabled) {
        long maxQueueSize = topN * this.maxAnalyzedPathsPerOutput;
        assert (liveDocsRatio <= 1.0);
        maxQueueSize = (long)((double)maxQueueSize / liveDocsRatio);
        if (filterEnabled) {
            maxQueueSize += (long)(numDocs / 2);
        }
        return (int)Math.min(5000L, maxQueueSize);
    }

    private static double calculateLiveDocRatio(int numDocs, int maxDocs) {
        return numDocs > 0 ? (double)numDocs / (double)maxDocs : -1.0;
    }

    public static NRTSuggester load(IndexInput input) throws IOException {
        FST<PairOutputs.Pair<Long, BytesRef>> fst = new FST<PairOutputs.Pair<Long, BytesRef>>(input, new PairOutputs<Long, BytesRef>(PositiveIntOutputs.getSingleton(), ByteSequenceOutputs.getSingleton()));
        int maxAnalyzedPathsPerOutput = input.readVInt();
        int endByte = input.readVInt();
        int payloadSep = input.readVInt();
        return new NRTSuggester(fst, maxAnalyzedPathsPerOutput, payloadSep);
    }

    static long encode(long input) {
        if (input < 0L || input > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("cannot encode value: " + input);
        }
        return Integer.MAX_VALUE - input;
    }

    static long decode(long output) {
        assert (output >= 0L && output <= Integer.MAX_VALUE) : "decoded output: " + output + " is not within 0 and Integer.MAX_VALUE";
        return Integer.MAX_VALUE - output;
    }

    static final class PayLoadProcessor {
        private static final int MAX_DOC_ID_LEN_WITH_SEP = 6;

        PayLoadProcessor() {
        }

        static int parseSurfaceForm(BytesRef output, int payloadSep, CharsRefBuilder spare) {
            int surfaceFormLen = -1;
            for (int i = 0; i < output.length; ++i) {
                if (output.bytes[output.offset + i] != payloadSep) continue;
                surfaceFormLen = i;
                break;
            }
            assert (surfaceFormLen != -1) : "no payloadSep found, unable to determine surface form";
            spare.copyUTF8Bytes(output.bytes, output.offset, surfaceFormLen);
            return surfaceFormLen;
        }

        static int parseDocID(BytesRef output, int payloadSepIndex) {
            assert (payloadSepIndex != -1) : "payload sep index can not be -1";
            ByteArrayDataInput input = new ByteArrayDataInput(output.bytes, payloadSepIndex + output.offset + 1, output.length - (payloadSepIndex + output.offset));
            return input.readVInt();
        }

        static BytesRef make(BytesRef surface, int docID, int payloadSep) throws IOException {
            int len = surface.length + 6;
            byte[] buffer = new byte[len];
            ByteArrayDataOutput output = new ByteArrayDataOutput(buffer);
            output.writeBytes(surface.bytes, surface.length - surface.offset);
            output.writeByte((byte)payloadSep);
            output.writeVInt(docID);
            return new BytesRef(buffer, 0, output.getPosition());
        }
    }

    private static class ScoringPathComparator
    implements Comparator<Util.FSTPath<PairOutputs.Pair<Long, BytesRef>>> {
        private final CompletionScorer scorer;

        public ScoringPathComparator(CompletionScorer scorer) {
            this.scorer = scorer;
        }

        @Override
        public int compare(Util.FSTPath<PairOutputs.Pair<Long, BytesRef>> first, Util.FSTPath<PairOutputs.Pair<Long, BytesRef>> second) {
            int cmp = Float.compare(this.scorer.score(NRTSuggester.decode((Long)((PairOutputs.Pair)second.cost).output1), second.boost), this.scorer.score(NRTSuggester.decode((Long)((PairOutputs.Pair)first.cost).output1), first.boost));
            return cmp != 0 ? cmp : first.input.get().compareTo(second.input.get());
        }
    }
}

