/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.tasks.cancel;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.elasticsearch.action.admin.cluster.node.tasks.list.TaskInfo;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Consumer;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class TransportCancelTasksAction
extends TransportTasksAction<CancellableTask, CancelTasksRequest, CancelTasksResponse, TaskInfo> {
    public static final String BAN_PARENT_ACTION_NAME = "internal:admin/tasks/ban";

    @Inject
    public TransportCancelTasksAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/tasks/cancel", clusterName, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, new Callable<CancelTasksRequest>(){

            @Override
            public CancelTasksRequest call() throws Exception {
                return new CancelTasksRequest();
            }
        }, "management");
        transportService.registerRequestHandler(BAN_PARENT_ACTION_NAME, new Callable<BanParentTaskRequest>(){

            @Override
            public BanParentTaskRequest call() throws Exception {
                return new BanParentTaskRequest();
            }
        }, "same", new BanParentRequestHandler());
    }

    @Override
    protected CancelTasksResponse newResponse(CancelTasksRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new CancelTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }

    @Override
    protected TaskInfo readTaskResponse(StreamInput in) throws IOException {
        return new TaskInfo(in);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void processTasks(CancelTasksRequest request, Consumer<CancellableTask> operation) {
        if (request.getTaskId().isSet()) {
            CancellableTask task = this.taskManager.getCancellableTask(request.getTaskId().getId());
            if (task != null) {
                if (!request.match(task)) throw new IllegalArgumentException("task [" + request.getTaskId() + "] doesn't support this operation");
                operation.accept(task);
                return;
            }
            if (this.taskManager.getTask(request.getTaskId().getId()) != null) {
                throw new IllegalArgumentException("task [" + request.getTaskId() + "] doesn't support cancellation");
            }
            throw new ResourceNotFoundException("task [{}] doesn't support cancellation", request.getTaskId());
        }
        Iterator<CancellableTask> i$ = this.taskManager.getCancellableTasks().values().iterator();
        while (i$.hasNext()) {
            CancellableTask task = i$.next();
            if (!request.match(task)) continue;
            operation.accept(task);
        }
    }

    @Override
    protected synchronized TaskInfo taskOperation(CancelTasksRequest request, final CancellableTask cancellableTask) {
        final BanLock banLock = new BanLock(new Consumer<Set<String>>(){

            @Override
            public void accept(Set<String> nodes) {
                TransportCancelTasksAction.this.removeBanOnNodes(cancellableTask, nodes);
            }
        });
        Set<String> childNodes = this.taskManager.cancel(cancellableTask, request.getReason(), new Consumer<Set<String>>(){

            @Override
            public void accept(Set<String> nodes) {
                banLock.onTaskFinished(nodes);
            }
        });
        if (childNodes != null) {
            if (childNodes.isEmpty()) {
                this.logger.trace("cancelling task {} with no children", cancellableTask.getId());
                return cancellableTask.taskInfo(this.clusterService.localNode(), false);
            }
            this.logger.trace("cancelling task {} with children on nodes [{}]", cancellableTask.getId(), childNodes);
            this.setBanOnNodes(request.getReason(), cancellableTask, childNodes, banLock);
            return cancellableTask.taskInfo(this.clusterService.localNode(), false);
        }
        this.logger.trace("task {} is already cancelled", cancellableTask.getId());
        throw new IllegalStateException("task with id " + cancellableTask.getId() + " is already cancelled");
    }

    @Override
    protected boolean accumulateExceptions() {
        return true;
    }

    private void setBanOnNodes(String reason, CancellableTask task, Set<String> nodes, BanLock banLock) {
        this.sendSetBanRequest(nodes, BanParentTaskRequest.createSetBanParentTaskRequest(new TaskId(this.clusterService.localNode().getId(), task.getId()), reason), banLock);
    }

    private void removeBanOnNodes(CancellableTask task, Set<String> nodes) {
        this.sendRemoveBanRequest(nodes, BanParentTaskRequest.createRemoveBanParentTaskRequest(new TaskId(this.clusterService.localNode().getId(), task.getId())));
    }

    private void sendSetBanRequest(Set<String> nodes, BanParentTaskRequest request, final BanLock banLock) {
        ClusterState clusterState = this.clusterService.state();
        for (String node : nodes) {
            DiscoveryNode discoveryNode = clusterState.getNodes().get(node);
            if (discoveryNode != null && discoveryNode.version().onOrAfter(Version.V_2_3_0)) {
                this.logger.debug("Sending ban for tasks with the parent [{}] to the node [{}], ban [{}]", request.parentTaskId, node, request.ban);
                this.transportService.sendRequest(discoveryNode, BAN_PARENT_ACTION_NAME, request, new EmptyTransportResponseHandler("same"){

                    @Override
                    public void handleResponse(TransportResponse.Empty response) {
                        banLock.onBanSet();
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        banLock.onBanSet();
                    }
                });
                continue;
            }
            banLock.onBanSet();
            this.logger.debug("Cannot send ban for tasks with the parent [{}] to the node [{}] - the node no longer in the cluster or has an old version", request.parentTaskId, node);
        }
    }

    private void sendRemoveBanRequest(Set<String> nodes, BanParentTaskRequest request) {
        ClusterState clusterState = this.clusterService.state();
        for (String node : nodes) {
            DiscoveryNode discoveryNode = clusterState.getNodes().get(node);
            if (discoveryNode != null && discoveryNode.version().onOrAfter(Version.V_2_3_0)) {
                this.logger.debug("Sending remove ban for tasks with the parent [{}] to the node [{}]", request.parentTaskId, node);
                this.transportService.sendRequest(discoveryNode, BAN_PARENT_ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
                continue;
            }
            this.logger.debug("Cannot send remove ban request for tasks with the parent [{}] to the node [{}] - the node no longer in the cluster or has an old version", request.parentTaskId, node);
        }
    }

    class BanParentRequestHandler
    extends TransportRequestHandler<BanParentTaskRequest> {
        BanParentRequestHandler() {
        }

        @Override
        public void messageReceived(BanParentTaskRequest request, TransportChannel channel) throws Exception {
            if (request.ban) {
                TransportCancelTasksAction.this.logger.debug("Received ban for the parent [{}] on the node [{}], reason: [{}]", request.parentTaskId, TransportCancelTasksAction.this.clusterService.localNode().getId(), request.reason);
                TransportCancelTasksAction.this.taskManager.setBan(request.parentTaskId, request.reason);
            } else {
                TransportCancelTasksAction.this.logger.debug("Removing ban for the parent [{}] on the node [{}]", request.parentTaskId, TransportCancelTasksAction.this.clusterService.localNode().getId());
                TransportCancelTasksAction.this.taskManager.removeBan(request.parentTaskId);
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    private static class BanParentTaskRequest
    extends TransportRequest {
        private TaskId parentTaskId;
        private boolean ban;
        private String reason;

        static BanParentTaskRequest createSetBanParentTaskRequest(TaskId parentTaskId, String reason) {
            return new BanParentTaskRequest(parentTaskId, reason);
        }

        static BanParentTaskRequest createRemoveBanParentTaskRequest(TaskId parentTaskId) {
            return new BanParentTaskRequest(parentTaskId);
        }

        private BanParentTaskRequest(TaskId parentTaskId, String reason) {
            this.parentTaskId = parentTaskId;
            this.ban = true;
            this.reason = reason;
        }

        private BanParentTaskRequest(TaskId parentTaskId) {
            this.parentTaskId = parentTaskId;
            this.ban = false;
        }

        public BanParentTaskRequest() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.parentTaskId = new TaskId(in);
            this.ban = in.readBoolean();
            if (this.ban) {
                this.reason = in.readString();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.parentTaskId.writeTo(out);
            out.writeBoolean(this.ban);
            if (this.ban) {
                out.writeString(this.reason);
            }
        }
    }

    private static class BanLock {
        private final Consumer<Set<String>> finish;
        private final AtomicInteger counter;
        private final AtomicReference<Set<String>> nodes = new AtomicReference();

        public BanLock(Consumer<Set<String>> finish) {
            this.counter = new AtomicInteger(0);
            this.finish = finish;
        }

        public void onBanSet() {
            if (this.counter.decrementAndGet() == 0) {
                this.finish();
            }
        }

        public void onTaskFinished(Set<String> nodes) {
            this.nodes.set(nodes);
            if (this.counter.addAndGet(nodes.size()) == 0) {
                this.finish();
            }
        }

        public void finish() {
            this.finish.accept(this.nodes.get());
        }
    }
}

