/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentFactory;

public class MultiSearchResponse
extends ActionResponse
implements Iterable<Item>,
ToXContent {
    private Item[] items;

    MultiSearchResponse() {
    }

    public MultiSearchResponse(Item[] items) {
        this.items = items;
    }

    @Override
    public Iterator<Item> iterator() {
        return Iterators.forArray(this.items);
    }

    public Item[] getResponses() {
        return this.items;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.items = new Item[in.readVInt()];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = Item.readItem(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.items.length);
        for (Item item : this.items) {
            item.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Fields.RESPONSES);
        for (Item item : this.items) {
            builder.startObject();
            if (item.isFailure()) {
                ElasticsearchException.renderThrowable(builder, params, item.getFailure());
            } else {
                item.getResponse().toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    static final class Fields {
        static final XContentBuilderString RESPONSES = new XContentBuilderString("responses");
        static final XContentBuilderString ERROR = new XContentBuilderString("error");
        static final XContentBuilderString ROOT_CAUSE = new XContentBuilderString("root_cause");

        Fields() {
        }
    }

    public static class Item
    implements Streamable {
        private SearchResponse response;
        private Throwable throwable;

        Item() {
        }

        public Item(SearchResponse response, Throwable throwable) {
            this.response = response;
            this.throwable = throwable;
        }

        public boolean isFailure() {
            return this.throwable != null;
        }

        @Nullable
        public String getFailureMessage() {
            return this.throwable == null ? null : this.throwable.getMessage();
        }

        @Nullable
        public SearchResponse getResponse() {
            return this.response;
        }

        public static Item readItem(StreamInput in) throws IOException {
            Item item = new Item();
            item.readFrom(in);
            return item;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.response = new SearchResponse();
                this.response.readFrom(in);
            } else {
                this.throwable = in.readThrowable();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (this.response != null) {
                out.writeBoolean(true);
                this.response.writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeThrowable(this.throwable);
            }
        }

        public Throwable getFailure() {
            return this.throwable;
        }
    }
}

