/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import com.google.common.collect.ImmutableMap;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.threadpool.ThreadPool;

class SearchScanAsyncAction
extends AbstractSearchAsyncAction<QuerySearchResult> {
    SearchScanAsyncAction(ESLogger logger, SearchServiceTransportAction searchService, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, SearchPhaseController searchPhaseController, ThreadPool threadPool, SearchRequest request, ActionListener<SearchResponse> listener) {
        super(logger, searchService, clusterService, indexNameExpressionResolver, searchPhaseController, threadPool, request, listener);
    }

    @Override
    protected String firstPhaseName() {
        return "init_scan";
    }

    @Override
    protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchTransportRequest request, ActionListener<QuerySearchResult> listener) {
        this.searchService.sendExecuteScan(node, request, listener);
    }

    @Override
    protected void moveToSecondPhase() throws Exception {
        InternalSearchResponse internalResponse = this.searchPhaseController.merge(SearchPhaseController.EMPTY_DOCS, this.firstResults, (AtomicArray)AtomicArray.empty(), this.request);
        String scrollId = null;
        if (this.request.scroll() != null) {
            scrollId = TransportSearchHelper.buildScrollId(this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)this.firstResults, ImmutableMap.of("total_hits", Long.toString(internalResponse.hits().totalHits())));
        }
        this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.expectedSuccessfulOps, this.successfulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
    }
}

