/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndicesService;

public class MetaDataIndexAliasesService
extends AbstractComponent {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AliasValidator aliasValidator;

    @Inject
    public MetaDataIndexAliasesService(Settings settings, ClusterService clusterService, IndicesService indicesService, AliasValidator aliasValidator) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.aliasValidator = aliasValidator;
    }

    public void indicesAliases(final IndicesAliasesClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("index-aliases", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClusterState execute(ClusterState currentState) {
                ArrayList<String> indicesToClose = new ArrayList<String>();
                HashMap<String, IndexService> indices = Maps.newHashMap();
                try {
                    ClusterState updatedState;
                    for (AliasAction aliasAction : request.actions()) {
                        MetaDataIndexAliasesService.this.aliasValidator.validateAliasAction(aliasAction, currentState.metaData());
                        if (currentState.metaData().hasIndex(aliasAction.index())) continue;
                        throw new IndexNotFoundException(aliasAction.index());
                    }
                    boolean changed = false;
                    MetaData.Builder builder = MetaData.builder(currentState.metaData());
                    for (AliasAction aliasAction : request.actions()) {
                        IndexMetaData indexMetaData = builder.get(aliasAction.index());
                        if (indexMetaData == null) {
                            throw new IndexNotFoundException(aliasAction.index());
                        }
                        IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.builder(indexMetaData);
                        if (aliasAction.actionType() == AliasAction.Type.ADD) {
                            String filter = aliasAction.filter();
                            if (Strings.hasLength(filter)) {
                                IndexService indexService = (IndexService)indices.get(indexMetaData.getIndex());
                                if (indexService == null) {
                                    indexService = MetaDataIndexAliasesService.this.indicesService.indexService(indexMetaData.getIndex());
                                    if (indexService == null) {
                                        try {
                                            indexService = MetaDataIndexAliasesService.this.indicesService.createIndex(indexMetaData.getIndex(), indexMetaData.getSettings(), MetaDataIndexAliasesService.this.clusterService.localNode().id());
                                            for (ObjectCursor<MappingMetaData> objectCursor : indexMetaData.getMappings().values()) {
                                                MappingMetaData mappingMetaData = (MappingMetaData)objectCursor.value;
                                                indexService.mapperService().merge(mappingMetaData.type(), mappingMetaData.source(), MapperService.MergeReason.MAPPING_RECOVERY, false);
                                            }
                                        }
                                        catch (Exception e) {
                                            MetaDataIndexAliasesService.this.logger.warn("[{}] failed to temporary create in order to apply alias action", e, indexMetaData.getIndex());
                                            continue;
                                        }
                                        indicesToClose.add(indexMetaData.getIndex());
                                    }
                                    indices.put(indexMetaData.getIndex(), indexService);
                                }
                                MetaDataIndexAliasesService.this.aliasValidator.validateAliasFilter(aliasAction.alias(), filter, indexService.queryParserService());
                            }
                            AliasMetaData newAliasMd = AliasMetaData.newAliasMetaDataBuilder(aliasAction.alias()).filter(filter).indexRouting(aliasAction.indexRouting()).searchRouting(aliasAction.searchRouting()).build();
                            AliasMetaData aliasMd = indexMetaData.getAliases().get(aliasAction.alias());
                            if (aliasMd != null && aliasMd.equals(newAliasMd)) continue;
                            indexMetaDataBuilder.putAlias(newAliasMd);
                        } else if (aliasAction.actionType() == AliasAction.Type.REMOVE) {
                            if (!indexMetaData.getAliases().containsKey(aliasAction.alias())) continue;
                            indexMetaDataBuilder.removeAlias(aliasAction.alias());
                        }
                        changed = true;
                        builder.put(indexMetaDataBuilder);
                    }
                    if (changed && !(updatedState = ClusterState.builder(currentState).metaData(builder).build()).metaData().equalsAliases(currentState.metaData())) {
                        ClusterState len$ = updatedState;
                        return len$;
                    }
                    ClusterState clusterState = currentState;
                    return clusterState;
                }
                finally {
                    for (String index : indicesToClose) {
                        MetaDataIndexAliasesService.this.indicesService.removeIndex(index, "created for alias processing");
                    }
                }
            }
        });
    }
}

