/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.Strings;

public class Table {
    private List<Cell> headers = new ArrayList<Cell>();
    private List<List<Cell>> rows = new ArrayList<List<Cell>>();
    private Map<String, List<Cell>> map = Maps.newHashMap();
    private Map<String, Cell> headerMap = Maps.newHashMap();
    private List<Cell> currentCells;
    private boolean inHeaders = false;

    public Table startHeaders() {
        this.inHeaders = true;
        this.currentCells = new ArrayList<Cell>();
        return this;
    }

    public Table endHeaders() {
        if (this.currentCells == null || this.currentCells.isEmpty()) {
            throw new IllegalStateException("no headers added...");
        }
        this.inHeaders = false;
        this.headers = this.currentCells;
        this.currentCells = null;
        for (Cell header : this.headers) {
            this.map.put(header.value.toString(), new ArrayList());
            this.headerMap.put(header.value.toString(), header);
        }
        return this;
    }

    public Table startRow() {
        if (this.headers.isEmpty()) {
            throw new IllegalStateException("no headers added...");
        }
        this.currentCells = new ArrayList<Cell>(this.headers.size());
        return this;
    }

    public Table endRow(boolean check) {
        if (this.currentCells == null) {
            throw new IllegalStateException("no row started...");
        }
        if (check && this.currentCells.size() != this.headers.size()) {
            StringBuilder s = new StringBuilder();
            s.append("mismatch on number of cells ");
            s.append(this.currentCells.size());
            s.append(" in a row compared to header ");
            s.append(this.headers.size());
            throw new IllegalStateException(s.toString());
        }
        this.rows.add(this.currentCells);
        this.currentCells = null;
        return this;
    }

    public Table endRow() {
        this.endRow(true);
        return this;
    }

    public Table addCell(Object value) {
        return this.addCell(value, "");
    }

    public Table addCell(Object value, String attributes) {
        Map<Object, Object> mAttr;
        if (this.currentCells == null) {
            throw new IllegalStateException("no block started...");
        }
        if (!this.inHeaders && this.currentCells.size() == this.headers.size()) {
            throw new IllegalStateException("can't add more cells to a row than the header");
        }
        if (attributes.length() == 0) {
            mAttr = this.inHeaders ? ImmutableMap.of() : this.headers.get((int)this.currentCells.size()).attr;
        } else {
            String[] sAttrs;
            mAttr = new HashMap();
            if (!this.inHeaders) {
                mAttr.putAll(this.headers.get((int)this.currentCells.size()).attr);
            }
            for (String sAttr : sAttrs = Strings.splitStringToArray(attributes, ';')) {
                if (sAttr.length() == 0) continue;
                int idx = sAttr.indexOf(58);
                mAttr.put(sAttr.substring(0, idx), sAttr.substring(idx + 1));
            }
        }
        Cell cell = new Cell(value, mAttr);
        int cellIndex = this.currentCells.size();
        this.currentCells.add(cell);
        if (!this.inHeaders) {
            String hdr = (String)this.headers.get((int)cellIndex).value;
            this.map.get(hdr).add(cell);
        }
        return this;
    }

    public List<Cell> getHeaders() {
        return this.headers;
    }

    public List<List<Cell>> getRows() {
        return this.rows;
    }

    public Map<String, List<Cell>> getAsMap() {
        return this.map;
    }

    public Map<String, Cell> getHeaderMap() {
        return this.headerMap;
    }

    public Cell findHeaderByName(String header) {
        for (Cell cell : this.headers) {
            if (!cell.value.toString().equals(header)) continue;
            return cell;
        }
        return null;
    }

    public static class Cell {
        public final Object value;
        public final Map<String, String> attr;

        public Cell(Object value, Cell other) {
            this.value = value;
            this.attr = other.attr;
        }

        public Cell(Object value) {
            this.value = value;
            this.attr = new HashMap<String, String>();
        }

        public Cell(Object value, Map<String, String> attr) {
            this.value = value;
            this.attr = attr;
        }
    }
}

