/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import org.apache.lucene.util.InfoStream;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public final class LoggerInfoStream
extends InfoStream {
    private final ESLogger logger;
    private final ESLogger ifdLogger;

    public LoggerInfoStream(ESLogger parentLogger) {
        this.logger = Loggers.getLogger(parentLogger, ".lucene.iw");
        this.ifdLogger = Loggers.getLogger(parentLogger, ".lucene.iw.ifd");
    }

    @Override
    public void message(String component, String message) {
        this.getLogger(component).trace("{} {}: {}", Thread.currentThread().getName(), component, message);
    }

    @Override
    public boolean isEnabled(String component) {
        return this.getLogger(component).isTraceEnabled() && !component.equals("TP");
    }

    private ESLogger getLogger(String component) {
        if (component.equals("IFD")) {
            return this.ifdLogger;
        }
        return this.logger;
    }

    @Override
    public void close() {
    }
}

