/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.transport;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.transport.DummyTransportAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.LocalTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public abstract class TransportAddressSerializers {
    private static final ESLogger logger = Loggers.getLogger(TransportAddressSerializers.class);
    private static ImmutableMap<Short, TransportAddress> ADDRESS_REGISTRY = ImmutableMap.of();

    public static synchronized void addAddressType(TransportAddress address) throws Exception {
        if (ADDRESS_REGISTRY.containsKey(address.uniqueAddressTypeId())) {
            throw new IllegalStateException("Address [" + address.uniqueAddressTypeId() + "] already bound");
        }
        ADDRESS_REGISTRY = MapBuilder.newMapBuilder(ADDRESS_REGISTRY).put(address.uniqueAddressTypeId(), address).immutableMap();
    }

    public static TransportAddress addressFromStream(StreamInput input) throws IOException {
        short addressUniqueId = input.readShort();
        TransportAddress addressType = ADDRESS_REGISTRY.get(addressUniqueId);
        if (addressType == null) {
            throw new IOException("No transport address mapped to [" + addressUniqueId + "]");
        }
        return (TransportAddress)addressType.readFrom(input);
    }

    public static void addressToStream(StreamOutput out, TransportAddress address) throws IOException {
        out.writeShort(address.uniqueAddressTypeId());
        address.writeTo(out);
    }

    static {
        try {
            TransportAddressSerializers.addAddressType(DummyTransportAddress.INSTANCE);
            TransportAddressSerializers.addAddressType(InetSocketTransportAddress.PROTO);
            TransportAddressSerializers.addAddressType(LocalTransportAddress.PROTO);
        }
        catch (Exception e) {
            logger.warn("Failed to add InetSocketTransportAddress", e, new Object[0]);
        }
    }
}

