/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.local;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateNonMasterUpdateTask;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.discovery.AckClusterStatePublishResponseHandler;
import org.elasticsearch.discovery.BlockingClusterStatePublishResponseHandler;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.InitialStateDiscoveryListener;
import org.elasticsearch.node.service.NodeService;

public class LocalDiscovery
extends AbstractLifecycleComponent<Discovery>
implements Discovery {
    private static final LocalDiscovery[] NO_MEMBERS = new LocalDiscovery[0];
    private final ClusterService clusterService;
    private RoutingService routingService;
    private final ClusterName clusterName;
    private final DiscoverySettings discoverySettings;
    private volatile boolean master = false;
    private final AtomicBoolean initialStateSent = new AtomicBoolean();
    private final CopyOnWriteArrayList<InitialStateDiscoveryListener> initialStateListeners = new CopyOnWriteArrayList();
    private static final ConcurrentMap<ClusterName, ClusterGroup> clusterGroups = ConcurrentCollections.newConcurrentMap();
    private volatile ClusterState lastProcessedClusterState;

    @Inject
    public LocalDiscovery(Settings settings, ClusterName clusterName, ClusterService clusterService, DiscoverySettings discoverySettings) {
        super(settings);
        this.clusterName = clusterName;
        this.clusterService = clusterService;
        this.discoverySettings = discoverySettings;
    }

    @Override
    public void setNodeService(@Nullable NodeService nodeService) {
    }

    @Override
    public void setRoutingService(RoutingService routingService) {
        this.routingService = routingService;
    }

    @Override
    protected void doStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startInitialJoin() {
        ConcurrentMap<ClusterName, ClusterGroup> concurrentMap = clusterGroups;
        synchronized (concurrentMap) {
            Object master;
            ClusterGroup clusterGroup = (ClusterGroup)clusterGroups.get(this.clusterName);
            if (clusterGroup == null) {
                clusterGroup = new ClusterGroup();
                clusterGroups.put(this.clusterName, clusterGroup);
            }
            this.logger.debug("Connected to cluster [{}]", this.clusterName);
            clusterGroup.members().add(this);
            Object firstMaster = null;
            for (LocalDiscovery localDiscovery : clusterGroup.members()) {
                if (!localDiscovery.localNode().masterNode()) continue;
                firstMaster = localDiscovery;
                break;
            }
            if (firstMaster != null && firstMaster.equals(this)) {
                this.master = true;
                master = firstMaster;
                this.clusterService.submitStateUpdateTask("local-disco-initial_connect(master)", new ClusterStateUpdateTask((LocalDiscovery)master){
                    final /* synthetic */ LocalDiscovery val$master;
                    {
                        this.val$master = localDiscovery2;
                    }

                    @Override
                    public boolean runOnlyOnMaster() {
                        return false;
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.builder();
                        for (LocalDiscovery discovery : ((ClusterGroup)clusterGroups.get(LocalDiscovery.this.clusterName)).members()) {
                            nodesBuilder.put(discovery.localNode());
                        }
                        nodesBuilder.localNodeId(this.val$master.localNode().id()).masterNodeId(this.val$master.localNode().id());
                        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks()).removeGlobalBlock(LocalDiscovery.this.discoverySettings.getNoMasterBlock());
                        return ClusterState.builder(currentState).nodes(nodesBuilder).blocks(blocks).build();
                    }

                    @Override
                    public void onFailure(String source, Throwable t) {
                        LocalDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        LocalDiscovery.this.sendInitialStateEventIfNeeded();
                    }
                });
            } else if (firstMaster != null) {
                master = firstMaster;
                ((LocalDiscovery)firstMaster).clusterService.submitStateUpdateTask("local-disco-receive(from node[" + this.localNode() + "])", new ClusterStateUpdateTask((LocalDiscovery)master){
                    final /* synthetic */ LocalDiscovery val$master;
                    {
                        this.val$master = localDiscovery2;
                    }

                    @Override
                    public boolean runOnlyOnMaster() {
                        return false;
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.builder();
                        for (LocalDiscovery discovery : ((ClusterGroup)clusterGroups.get(LocalDiscovery.this.clusterName)).members()) {
                            nodesBuilder.put(discovery.localNode());
                        }
                        nodesBuilder.localNodeId(this.val$master.localNode().id()).masterNodeId(this.val$master.localNode().id());
                        return ClusterState.builder(currentState).nodes(nodesBuilder).build();
                    }

                    @Override
                    public void onFailure(String source, Throwable t) {
                        LocalDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        LocalDiscovery.this.sendInitialStateEventIfNeeded();
                        this.val$master.routingService.reroute("post_node_add");
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        ConcurrentMap<ClusterName, ClusterGroup> concurrentMap = clusterGroups;
        synchronized (concurrentMap) {
            ClusterGroup clusterGroup = (ClusterGroup)clusterGroups.get(this.clusterName);
            if (clusterGroup == null) {
                this.logger.warn("Illegal state, should not have an empty cluster group when stopping, I should be there at teh very least...", new Object[0]);
                return;
            }
            clusterGroup.members().remove(this);
            if (clusterGroup.members().isEmpty()) {
                clusterGroups.remove(this.clusterName);
                return;
            }
            LocalDiscovery firstMaster = null;
            for (LocalDiscovery localDiscovery : clusterGroup.members()) {
                if (!localDiscovery.localNode().masterNode()) continue;
                firstMaster = localDiscovery;
                break;
            }
            if (firstMaster != null) {
                if (this.master) {
                    firstMaster.master = true;
                }
                final HashSet<String> newMembers = Sets.newHashSet();
                for (LocalDiscovery discovery : clusterGroup.members()) {
                    newMembers.add(discovery.localNode().id());
                }
                final LocalDiscovery master = firstMaster;
                master.clusterService.submitStateUpdateTask("local-disco-update", new ClusterStateNonMasterUpdateTask(){

                    @Override
                    public ClusterState execute(ClusterState currentState) {
                        DiscoveryNodes newNodes = currentState.nodes().removeDeadMembers(newMembers, master.localNode().id());
                        DiscoveryNodes.Delta delta = newNodes.delta(currentState.nodes());
                        if (delta.added()) {
                            LocalDiscovery.this.logger.warn("No new nodes should be created when a new discovery view is accepted", new Object[0]);
                        }
                        ClusterState updatedState = ClusterState.builder(currentState).nodes(newNodes).build();
                        RoutingAllocation.Result routingResult = master.routingService.getAllocationService().reroute(ClusterState.builder(updatedState).build(), "elected as master");
                        return ClusterState.builder(updatedState).routingResult(routingResult).build();
                    }

                    @Override
                    public void onFailure(String source, Throwable t) {
                        LocalDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                    }
                });
            }
        }
    }

    @Override
    protected void doClose() {
    }

    @Override
    public DiscoveryNode localNode() {
        return this.clusterService.localNode();
    }

    @Override
    public void addListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.add(listener);
    }

    @Override
    public void removeListener(InitialStateDiscoveryListener listener) {
        this.initialStateListeners.remove(listener);
    }

    @Override
    public String nodeDescription() {
        return this.clusterName.value() + "/" + this.localNode().id();
    }

    @Override
    public void publish(ClusterChangedEvent clusterChangedEvent, Discovery.AckListener ackListener) {
        if (!this.master) {
            throw new IllegalStateException("Shouldn't publish state when not master");
        }
        LocalDiscovery[] members = this.members();
        if (members.length > 0) {
            HashSet<DiscoveryNode> nodesToPublishTo = new HashSet<DiscoveryNode>(members.length);
            for (LocalDiscovery localDiscovery : members) {
                if (localDiscovery.master) continue;
                nodesToPublishTo.add(localDiscovery.localNode());
            }
            this.publish(members, clusterChangedEvent, new AckClusterStatePublishResponseHandler(nodesToPublishTo, ackListener));
        }
    }

    private LocalDiscovery[] members() {
        ClusterGroup clusterGroup = (ClusterGroup)clusterGroups.get(this.clusterName);
        if (clusterGroup == null) {
            return NO_MEMBERS;
        }
        Queue<LocalDiscovery> members = clusterGroup.members();
        return members.toArray(new LocalDiscovery[members.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(LocalDiscovery[] members, ClusterChangedEvent clusterChangedEvent, final BlockingClusterStatePublishResponseHandler publishResponseHandler) {
        block18: {
            try {
                byte[] clusterStateBytes = null;
                byte[] clusterStateDiffBytes = null;
                ClusterState clusterState = clusterChangedEvent.state();
                for (final LocalDiscovery discovery : members) {
                    if (discovery.master) continue;
                    ClusterState newNodeSpecificClusterState = null;
                    LocalDiscovery localDiscovery = this;
                    synchronized (localDiscovery) {
                        if (discovery.lastProcessedClusterState != null && clusterChangedEvent.previousState().nodes().nodeExists(discovery.localNode().id())) {
                            if (clusterStateDiffBytes == null) {
                                Diff diff = clusterState.diff(clusterChangedEvent.previousState());
                                BytesStreamOutput os = new BytesStreamOutput();
                                diff.writeTo(os);
                                clusterStateDiffBytes = os.bytes().toBytes();
                            }
                            try {
                                newNodeSpecificClusterState = discovery.lastProcessedClusterState.readDiffFrom(StreamInput.wrap(clusterStateDiffBytes)).apply(discovery.lastProcessedClusterState);
                                this.logger.trace("sending diff cluster state version [{}] with size {} to [{}]", clusterState.version(), clusterStateDiffBytes.length, discovery.localNode().getName());
                            }
                            catch (IncompatibleClusterStateVersionException ex) {
                                this.logger.warn("incompatible cluster state version - resending complete cluster state", ex, new Object[0]);
                            }
                        }
                        if (newNodeSpecificClusterState == null) {
                            if (clusterStateBytes == null) {
                                clusterStateBytes = ClusterState.Builder.toBytes(clusterState);
                            }
                            newNodeSpecificClusterState = ClusterState.Builder.fromBytes(clusterStateBytes, discovery.localNode());
                        }
                        discovery.lastProcessedClusterState = newNodeSpecificClusterState;
                    }
                    final ClusterState nodeSpecificClusterState = newNodeSpecificClusterState;
                    nodeSpecificClusterState.status(ClusterState.ClusterStateStatus.RECEIVED);
                    if (nodeSpecificClusterState.nodes().localNode() != null) {
                        assert (nodeSpecificClusterState.nodes().masterNode() != null) : "received a cluster state without a master";
                        assert (!nodeSpecificClusterState.blocks().hasGlobalBlock(this.discoverySettings.getNoMasterBlock())) : "received a cluster state with a master block";
                        discovery.clusterService.submitStateUpdateTask("local-disco-receive(from master)", new ClusterStateUpdateTask(){

                            @Override
                            public boolean runOnlyOnMaster() {
                                return false;
                            }

                            @Override
                            public ClusterState execute(ClusterState currentState) {
                                if (nodeSpecificClusterState.version() < currentState.version() && Objects.equals(nodeSpecificClusterState.nodes().masterNodeId(), currentState.nodes().masterNodeId())) {
                                    return currentState;
                                }
                                if (currentState.blocks().hasGlobalBlock(LocalDiscovery.this.discoverySettings.getNoMasterBlock())) {
                                    LocalDiscovery.this.logger.debug("got first state from fresh master [{}]", nodeSpecificClusterState.nodes().masterNodeId());
                                    return nodeSpecificClusterState;
                                }
                                ClusterState.Builder builder = ClusterState.builder(nodeSpecificClusterState);
                                if (nodeSpecificClusterState.routingTable().version() == currentState.routingTable().version()) {
                                    builder.routingTable(currentState.routingTable());
                                }
                                if (nodeSpecificClusterState.metaData().version() == currentState.metaData().version()) {
                                    builder.metaData(currentState.metaData());
                                }
                                return builder.build();
                            }

                            @Override
                            public void onFailure(String source, Throwable t) {
                                LocalDiscovery.this.logger.error("unexpected failure during [{}]", t, source);
                                publishResponseHandler.onFailure(discovery.localNode(), t);
                            }

                            @Override
                            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                                LocalDiscovery.this.sendInitialStateEventIfNeeded();
                                publishResponseHandler.onResponse(discovery.localNode());
                            }
                        });
                        continue;
                    }
                    publishResponseHandler.onResponse(discovery.localNode());
                }
                TimeValue publishTimeout = this.discoverySettings.getPublishTimeout();
                if (publishTimeout.millis() <= 0L) break block18;
                try {
                    DiscoveryNode[] pendingNodes;
                    boolean awaited = publishResponseHandler.awaitAllNodes(publishTimeout);
                    if (!awaited && (pendingNodes = publishResponseHandler.pendingNodes()).length > 0) {
                        this.logger.warn("timed out waiting for all nodes to process published state [{}] (timeout [{}], pending nodes: {})", clusterState.version(), publishTimeout, pendingNodes);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Cluster state failed to serialize", e);
            }
        }
    }

    private void sendInitialStateEventIfNeeded() {
        if (this.initialStateSent.compareAndSet(false, true)) {
            for (InitialStateDiscoveryListener listener : this.initialStateListeners) {
                listener.initialStateProcessed();
            }
        }
    }

    private class ClusterGroup {
        private Queue<LocalDiscovery> members = ConcurrentCollections.newQueue();

        private ClusterGroup() {
        }

        Queue<LocalDiscovery> members() {
            return this.members;
        }
    }
}

