/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;

final class ParentChildIntersectTermsEnum
extends TermsEnum {
    private final List<TermsEnumState> states;
    private final IntArrayList stateSlots;
    private BytesRef current;

    ParentChildIntersectTermsEnum(LeafReader atomicReader, String ... fields) throws IOException {
        ArrayList<TermsEnum> fieldEnums = new ArrayList<TermsEnum>();
        for (String field : fields) {
            Terms terms = atomicReader.terms(field);
            if (terms == null) continue;
            fieldEnums.add(terms.iterator());
        }
        this.states = new ArrayList<TermsEnumState>(fieldEnums.size());
        for (TermsEnum tEnum : fieldEnums) {
            this.states.add(new TermsEnumState(tEnum));
        }
        this.stateSlots = new IntArrayList(this.states.size());
    }

    @Override
    public BytesRef term() throws IOException {
        return this.current;
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        int size = this.stateSlots.size();
        assert (size > 0);
        if (size == 1) {
            return this.states.get((int)this.stateSlots.get((int)0)).termsEnum.postings(null, flags);
        }
        ArrayList<PostingsEnum> docsEnums = new ArrayList<PostingsEnum>(this.stateSlots.size());
        for (int i = 0; i < this.stateSlots.size(); ++i) {
            docsEnums.add(this.states.get((int)this.stateSlots.get((int)i)).termsEnum.postings(null, flags));
        }
        return new CompoundDocsEnum(docsEnums);
    }

    @Override
    public BytesRef next() throws IOException {
        if (this.states.isEmpty()) {
            return null;
        }
        if (this.current == null) {
            for (TermsEnumState state : this.states) {
                state.initialize();
            }
        } else {
            int removed = 0;
            for (int i = 0; i < this.stateSlots.size(); ++i) {
                int stateSlot = this.stateSlots.get(i);
                if (this.states.get(stateSlot - removed).next() != null) continue;
                this.states.remove(stateSlot - removed);
                ++removed;
            }
            if (this.states.isEmpty()) {
                return null;
            }
            this.stateSlots.clear();
        }
        BytesRef lowestTerm = this.states.get((int)0).term;
        this.stateSlots.add(0);
        for (int i = 1; i < this.states.size(); ++i) {
            TermsEnumState state = this.states.get(i);
            int cmp = lowestTerm.compareTo(state.term);
            if (cmp > 0) {
                lowestTerm = state.term;
                this.stateSlots.clear();
                this.stateSlots.add(i);
                continue;
            }
            if (cmp != 0) continue;
            this.stateSlots.add(i);
        }
        this.current = lowestTerm;
        return this.current;
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
        if (this.states.isEmpty()) {
            return TermsEnum.SeekStatus.END;
        }
        boolean found = false;
        if (this.current == null) {
            Iterator<TermsEnumState> iterator = this.states.iterator();
            while (iterator.hasNext()) {
                TermsEnum.SeekStatus seekStatus = iterator.next().seekCeil(text);
                if (seekStatus == TermsEnum.SeekStatus.END) {
                    iterator.remove();
                    continue;
                }
                if (seekStatus != TermsEnum.SeekStatus.FOUND) continue;
                found = true;
            }
        } else {
            int removed = 0;
            for (int i = 0; i < this.stateSlots.size(); ++i) {
                int stateSlot = this.stateSlots.get(i);
                TermsEnum.SeekStatus seekStatus = this.states.get(stateSlot - removed).seekCeil(text);
                if (seekStatus == TermsEnum.SeekStatus.END) {
                    this.states.remove(stateSlot - removed);
                    ++removed;
                    continue;
                }
                if (seekStatus != TermsEnum.SeekStatus.FOUND) continue;
                found = true;
            }
        }
        if (this.states.isEmpty()) {
            return TermsEnum.SeekStatus.END;
        }
        this.stateSlots.clear();
        if (found) {
            for (int i = 0; i < this.states.size(); ++i) {
                if (!this.states.get((int)i).term.equals(text)) continue;
                this.stateSlots.add(i);
            }
            this.current = text;
            return TermsEnum.SeekStatus.FOUND;
        }
        BytesRef lowestTerm = this.states.get((int)0).term;
        this.stateSlots.add(0);
        for (int i = 1; i < this.states.size(); ++i) {
            TermsEnumState state = this.states.get(i);
            int cmp = lowestTerm.compareTo(state.term);
            if (cmp > 0) {
                lowestTerm = state.term;
                this.stateSlots.clear();
                this.stateSlots.add(i);
                continue;
            }
            if (cmp != 0) continue;
            this.stateSlots.add(i);
        }
        this.current = lowestTerm;
        return TermsEnum.SeekStatus.NOT_FOUND;
    }

    @Override
    public long ord() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekExact(long ord) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int docFreq() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long totalTermFreq() throws IOException {
        throw new UnsupportedOperationException();
    }

    class CompoundDocsEnum
    extends PostingsEnum {
        final List<State> states;
        int current = -1;

        CompoundDocsEnum(List<PostingsEnum> docsEnums) {
            this.states = new ArrayList<State>(docsEnums.size());
            for (PostingsEnum docsEnum : docsEnums) {
                this.states.add(new State(docsEnum));
            }
        }

        @Override
        public int freq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docID() {
            return this.current;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.states.isEmpty()) {
                this.current = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (this.current == -1) {
                for (State state : this.states) {
                    state.initialize();
                }
            }
            int lowestIndex = 0;
            int lowestDocId = this.states.get((int)0).current;
            for (int i = 1; i < this.states.size(); ++i) {
                State state = this.states.get(i);
                if (lowestDocId <= state.current) continue;
                lowestDocId = state.current;
                lowestIndex = i;
            }
            if (this.states.get(lowestIndex).next() == Integer.MAX_VALUE) {
                this.states.remove(lowestIndex);
            }
            this.current = lowestDocId;
            return this.current;
        }

        @Override
        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int endOffset() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytesRef getPayload() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextPosition() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int startOffset() throws IOException {
            throw new UnsupportedOperationException();
        }

        class State {
            final PostingsEnum docsEnum;
            int current = -1;

            State(PostingsEnum docsEnum) {
                this.docsEnum = docsEnum;
            }

            void initialize() throws IOException {
                this.current = this.docsEnum.nextDoc();
            }

            int next() throws IOException {
                this.current = this.docsEnum.nextDoc();
                return this.current;
            }
        }
    }

    class TermsEnumState {
        final TermsEnum termsEnum;
        BytesRef term;
        TermsEnum.SeekStatus lastSeekStatus;

        TermsEnumState(TermsEnum termsEnum) {
            this.termsEnum = termsEnum;
        }

        void initialize() throws IOException {
            this.term = this.termsEnum.next();
        }

        BytesRef next() throws IOException {
            this.term = this.termsEnum.next();
            return this.term;
        }

        TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            this.lastSeekStatus = this.termsEnum.seekCeil(text);
            if (this.lastSeekStatus != TermsEnum.SeekStatus.END) {
                this.term = this.termsEnum.term();
            }
            return this.lastSeekStatus;
        }
    }
}

