/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.FiltersFunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.lucene.search.function.WeightFactorFunction;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParserMapper;
import org.elasticsearch.index.query.functionscore.factor.FactorParser;

public class FunctionScoreQueryParser
implements QueryParser {
    public static final String NAME = "function_score";
    static final String MISPLACED_FUNCTION_MESSAGE_PREFIX = "you can either define [functions] array or a single function, not both. ";
    static final String MISPLACED_BOOST_FUNCTION_MESSAGE_SUFFIX = " did you mean [boost] instead?";
    public static final ParseField WEIGHT_FIELD = new ParseField("weight", new String[0]);
    private static final ParseField FILTER_FIELD = new ParseField("filter", new String[0]).withAllDeprecated("query");
    ScoreFunctionParserMapper functionParserMapper;
    private static final ImmutableMap<String, CombineFunction> combineFunctionsMap;

    @Inject
    public FunctionScoreQueryParser(ScoreFunctionParserMapper functionParserMapper) {
        this.functionParserMapper = functionParserMapper;
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query query = null;
        Query filter = null;
        float boost = 1.0f;
        FiltersFunctionScoreQuery.ScoreMode scoreMode = FiltersFunctionScoreQuery.ScoreMode.Multiply;
        ArrayList<FiltersFunctionScoreQuery.FilterFunction> filterFunctions = new ArrayList<FiltersFunctionScoreQuery.FilterFunction>();
        Float maxBoost = null;
        Float minScore = null;
        String currentFieldName = null;
        CombineFunction combineFunction = CombineFunction.MULT;
        boolean functionArrayFound = false;
        boolean singleFunctionFound = false;
        String singleFunctionName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if ("query".equals(currentFieldName)) {
                query = parseContext.parseInnerQuery();
                continue;
            }
            if (parseContext.parseFieldMatcher().match(currentFieldName, FILTER_FIELD)) {
                filter = parseContext.parseInnerFilter();
                continue;
            }
            if ("score_mode".equals(currentFieldName) || "scoreMode".equals(currentFieldName)) {
                scoreMode = this.parseScoreMode(parseContext, parser);
                continue;
            }
            if ("boost_mode".equals(currentFieldName) || "boostMode".equals(currentFieldName)) {
                combineFunction = this.parseBoostMode(parseContext, parser);
                continue;
            }
            if ("max_boost".equals(currentFieldName) || "maxBoost".equals(currentFieldName)) {
                maxBoost = Float.valueOf(parser.floatValue());
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("min_score".equals(currentFieldName) || "minScore".equals(currentFieldName)) {
                minScore = Float.valueOf(parser.floatValue());
                continue;
            }
            if ("functions".equals(currentFieldName)) {
                if (singleFunctionFound) {
                    String errorString = "already found [" + singleFunctionName + "], now encountering [functions].";
                    this.handleMisplacedFunctionsDeclaration(errorString, singleFunctionName);
                }
                currentFieldName = this.parseFiltersAndFunctions(parseContext, parser, filterFunctions, currentFieldName);
                functionArrayFound = true;
                continue;
            }
            ScoreFunction scoreFunction = currentFieldName.equals("weight") ? new WeightFactorFunction(parser.floatValue()) : this.functionParserMapper.get(parseContext, currentFieldName).parse(parseContext, parser);
            if (functionArrayFound) {
                String errorString = "already found [functions] array, now encountering [" + currentFieldName + "].";
                this.handleMisplacedFunctionsDeclaration(errorString, currentFieldName);
            }
            if (filterFunctions.size() > 0) {
                throw new ElasticsearchParseException("failed to parse [{}] query. already found function [{}], now encountering [{}]. use [functions] array if you want to define several functions.", NAME, singleFunctionName, currentFieldName);
            }
            filterFunctions.add(new FiltersFunctionScoreQuery.FilterFunction(null, scoreFunction));
            singleFunctionFound = true;
            singleFunctionName = currentFieldName;
        }
        if (query == null && filter == null) {
            query = Queries.newMatchAllQuery();
        } else if (query == null && filter != null) {
            query = new ConstantScoreQuery(filter);
        } else if (query != null && filter != null) {
            BooleanQuery.Builder filtered = new BooleanQuery.Builder();
            filtered.add(query, BooleanClause.Occur.MUST);
            filtered.add(filter, BooleanClause.Occur.FILTER);
            query = filtered.build();
        }
        if (filterFunctions.isEmpty() && combineFunction == null) {
            return query;
        }
        if (maxBoost == null) {
            maxBoost = Float.valueOf(Float.MAX_VALUE);
        }
        if (filterFunctions.size() == 0 || filterFunctions.size() == 1 && (((FiltersFunctionScoreQuery.FilterFunction)filterFunctions.get((int)0)).filter == null || Queries.isConstantMatchAllQuery(((FiltersFunctionScoreQuery.FilterFunction)filterFunctions.get((int)0)).filter))) {
            ScoreFunction function = filterFunctions.size() == 0 ? null : ((FiltersFunctionScoreQuery.FilterFunction)filterFunctions.get((int)0)).function;
            FunctionScoreQuery theQuery = new FunctionScoreQuery(query, function, minScore);
            if (combineFunction != null) {
                theQuery.setCombineFunction(combineFunction);
            }
            theQuery.setBoost(boost);
            theQuery.setMaxBoost(maxBoost.floatValue());
            return theQuery;
        }
        FiltersFunctionScoreQuery functionScoreQuery = new FiltersFunctionScoreQuery(query, scoreMode, filterFunctions.toArray(new FiltersFunctionScoreQuery.FilterFunction[filterFunctions.size()]), maxBoost.floatValue(), minScore);
        if (combineFunction != null) {
            functionScoreQuery.setCombineFunction(combineFunction);
        }
        functionScoreQuery.setBoost(boost);
        return functionScoreQuery;
    }

    private void handleMisplacedFunctionsDeclaration(String errorString, String functionName) {
        errorString = MISPLACED_FUNCTION_MESSAGE_PREFIX + errorString;
        if (Arrays.asList(FactorParser.NAMES).contains(functionName)) {
            errorString = errorString + MISPLACED_BOOST_FUNCTION_MESSAGE_SUFFIX;
        }
        throw new ElasticsearchParseException("failed to parse [{}] query. [{}]", NAME, errorString);
    }

    private String parseFiltersAndFunctions(QueryParseContext parseContext, XContentParser parser, ArrayList<FiltersFunctionScoreQuery.FilterFunction> filterFunctions, String currentFieldName) throws IOException {
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            Query filter = null;
            ScoreFunction scoreFunction = null;
            Float functionWeight = null;
            if (token != XContentParser.Token.START_OBJECT) {
                throw new QueryParsingException(parseContext, "failed to parse [{}]. malformed query, expected a [{}] while parsing functions but got a [{}] instead", new Object[]{XContentParser.Token.START_OBJECT, token, NAME});
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, WEIGHT_FIELD)) {
                    functionWeight = Float.valueOf(parser.floatValue());
                    continue;
                }
                if ("filter".equals(currentFieldName)) {
                    filter = parseContext.parseInnerFilter();
                    continue;
                }
                ScoreFunctionParser functionParser = this.functionParserMapper.get(parseContext, currentFieldName);
                scoreFunction = functionParser.parse(parseContext, parser);
            }
            if (functionWeight != null) {
                scoreFunction = new WeightFactorFunction(functionWeight.floatValue(), scoreFunction);
            }
            if (filter == null) {
                filter = Queries.newMatchAllQuery();
            }
            if (scoreFunction == null) {
                throw new ElasticsearchParseException("failed to parse [{}] query. an entry in functions list is missing a function.", NAME);
            }
            filterFunctions.add(new FiltersFunctionScoreQuery.FilterFunction(filter, scoreFunction));
        }
        return currentFieldName;
    }

    private FiltersFunctionScoreQuery.ScoreMode parseScoreMode(QueryParseContext parseContext, XContentParser parser) throws IOException {
        String scoreMode = parser.text();
        if ("avg".equals(scoreMode)) {
            return FiltersFunctionScoreQuery.ScoreMode.Avg;
        }
        if ("max".equals(scoreMode)) {
            return FiltersFunctionScoreQuery.ScoreMode.Max;
        }
        if ("min".equals(scoreMode)) {
            return FiltersFunctionScoreQuery.ScoreMode.Min;
        }
        if ("sum".equals(scoreMode)) {
            return FiltersFunctionScoreQuery.ScoreMode.Sum;
        }
        if ("multiply".equals(scoreMode)) {
            return FiltersFunctionScoreQuery.ScoreMode.Multiply;
        }
        if ("first".equals(scoreMode)) {
            return FiltersFunctionScoreQuery.ScoreMode.First;
        }
        throw new QueryParsingException(parseContext, "failed to parse [{}] query. illegal score_mode [{}]", NAME, scoreMode);
    }

    private CombineFunction parseBoostMode(QueryParseContext parseContext, XContentParser parser) throws IOException {
        String boostMode = parser.text();
        CombineFunction cf = combineFunctionsMap.get(boostMode);
        if (cf == null) {
            throw new QueryParsingException(parseContext, "failed to parse [{}] query. illegal boost_mode [{}]", NAME, boostMode);
        }
        return cf;
    }

    static {
        CombineFunction[] values = CombineFunction.values();
        ImmutableMap.Builder<String, CombineFunction> combineFunctionMapBuilder = ImmutableMap.builder();
        for (CombineFunction combineFunction : values) {
            combineFunctionMapBuilder.put(combineFunction.getName(), combineFunction);
        }
        combineFunctionsMap = combineFunctionMapBuilder.build();
    }
}

