/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.filters.InternalFilters;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.internal.ContextIndexSearcher;

public class FiltersAggregator
extends BucketsAggregator {
    private final String[] keys;
    private final Weight[] filters;
    private final boolean keyed;
    private final boolean showOtherBucket;
    private final String otherBucketKey;
    private final int totalNumKeys;

    public FiltersAggregator(String name, AggregatorFactories factories, String[] keys, Weight[] filters, boolean keyed, String otherBucketKey, AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, aggregationContext, parent, pipelineAggregators, metaData);
        this.keyed = keyed;
        this.keys = keys;
        this.filters = filters;
        this.showOtherBucket = otherBucketKey != null;
        this.otherBucketKey = otherBucketKey;
        this.totalNumKeys = this.showOtherBucket ? keys.length + 1 : keys.length;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final Bits[] bits = new Bits[this.filters.length];
        for (int i = 0; i < this.filters.length; ++i) {
            bits[i] = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), this.filters[i].scorer(ctx));
        }
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                boolean matched = false;
                for (int i = 0; i < bits.length; ++i) {
                    if (!bits[i].get(doc)) continue;
                    FiltersAggregator.this.collectBucket(sub, doc, FiltersAggregator.this.bucketOrd(bucket, i));
                    matched = true;
                }
                if (FiltersAggregator.this.showOtherBucket && !matched) {
                    FiltersAggregator.this.collectBucket(sub, doc, FiltersAggregator.this.bucketOrd(bucket, bits.length));
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        ArrayList<InternalFilters.Bucket> buckets = new ArrayList<InternalFilters.Bucket>(this.filters.length);
        for (int i = 0; i < this.keys.length; ++i) {
            long bucketOrd = this.bucketOrd(owningBucketOrdinal, i);
            InternalFilters.Bucket bucket = new InternalFilters.Bucket(this.keys[i], this.bucketDocCount(bucketOrd), this.bucketAggregations(bucketOrd), this.keyed);
            buckets.add(bucket);
        }
        if (this.showOtherBucket) {
            long bucketOrd = this.bucketOrd(owningBucketOrdinal, this.keys.length);
            InternalFilters.Bucket bucket = new InternalFilters.Bucket(this.otherBucketKey, this.bucketDocCount(bucketOrd), this.bucketAggregations(bucketOrd), this.keyed);
            buckets.add(bucket);
        }
        return new InternalFilters(this.name, buckets, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalAggregations subAggs = this.buildEmptySubAggregations();
        ArrayList<InternalFilters.Bucket> buckets = new ArrayList<InternalFilters.Bucket>(this.filters.length);
        for (int i = 0; i < this.keys.length; ++i) {
            InternalFilters.Bucket bucket = new InternalFilters.Bucket(this.keys[i], 0L, subAggs, this.keyed);
            buckets.add(bucket);
        }
        if (this.showOtherBucket) {
            InternalFilters.Bucket bucket = new InternalFilters.Bucket(this.otherBucketKey, 0L, subAggs, this.keyed);
            buckets.add(bucket);
        }
        return new InternalFilters(this.name, buckets, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    final long bucketOrd(long owningBucketOrdinal, int filterOrd) {
        return owningBucketOrdinal * (long)this.totalNumKeys + (long)filterOrd;
    }

    public static class Factory
    extends AggregatorFactory {
        private final List<KeyedFilter> filters;
        private final String[] keys;
        private final boolean keyed;
        private final String otherBucketKey;
        private IndexSearcher searcher;
        private Weight[] weights;

        public Factory(String name, List<KeyedFilter> filters, boolean keyed, String otherBucketKey) {
            super(name, InternalFilters.TYPE.name());
            this.filters = filters;
            this.keyed = keyed;
            this.otherBucketKey = otherBucketKey;
            this.keys = new String[filters.size()];
            for (int i = 0; i < filters.size(); ++i) {
                KeyedFilter keyedFilter = filters.get(i);
                this.keys[i] = keyedFilter.key;
            }
        }

        @Override
        public Aggregator createInternal(AggregationContext context, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            ContextIndexSearcher contextSearcher = context.searchContext().searcher();
            if (this.searcher != contextSearcher) {
                this.searcher = contextSearcher;
                this.weights = new Weight[this.filters.size()];
                for (int i = 0; i < this.filters.size(); ++i) {
                    KeyedFilter keyedFilter = this.filters.get(i);
                    this.weights[i] = ((IndexSearcher)contextSearcher).createNormalizedWeight(keyedFilter.filter, false);
                }
            }
            return new FiltersAggregator(this.name, this.factories, this.keys, this.weights, this.keyed, this.otherBucketKey, context, parent, pipelineAggregators, metaData);
        }
    }

    static class KeyedFilter {
        final String key;
        final Query filter;

        KeyedFilter(String key, Query filter) {
            this.key = key;
            this.filter = filter;
        }
    }
}

