/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.significant.BucketSignificancePriorityQueue;
import org.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.ContextIndexSearcher;

public class GlobalOrdinalsSignificantTermsAggregator
extends GlobalOrdinalsStringTermsAggregator {
    protected long numCollectedDocs;
    protected final SignificantTermsAggregatorFactory termsAggFactory;

    public GlobalOrdinalsSignificantTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.OrdinalsFilter includeExclude, AggregationContext aggregationContext, Aggregator parent, SignificantTermsAggregatorFactory termsAggFactory, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, valuesSource, null, bucketCountThresholds, includeExclude, aggregationContext, parent, Aggregator.SubAggCollectionMode.DEPTH_FIRST, false, pipelineAggregators, metaData);
        this.termsAggFactory = termsAggFactory;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        return new LeafBucketCollectorBase(super.getLeafCollector(ctx, sub), null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                super.collect(doc, bucket);
                ++GlobalOrdinalsSignificantTermsAggregator.this.numCollectedDocs;
            }
        };
    }

    @Override
    public SignificantStringTerms buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        if (this.globalOrds == null) {
            return this.buildEmptyAggregation();
        }
        int size = this.bucketCountThresholds.getMinDocCount() == 0L ? (int)Math.min(this.globalOrds.getValueCount(), (long)this.bucketCountThresholds.getShardSize()) : (int)Math.min(this.maxBucketOrd(), (long)this.bucketCountThresholds.getShardSize());
        long supersetSize = this.termsAggFactory.prepareBackground(this.context);
        long subsetSize = this.numCollectedDocs;
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        SignificantStringTerms.Bucket spare = null;
        for (long globalTermOrd = 0L; globalTermOrd < this.globalOrds.getValueCount(); ++globalTermOrd) {
            int bucketDocCount;
            if (this.includeExclude != null && !this.acceptedGlobalOrdinals.get(globalTermOrd)) continue;
            long bucketOrd = this.getBucketOrd(globalTermOrd);
            int n = bucketDocCount = bucketOrd < 0L ? 0 : this.bucketDocCount(bucketOrd);
            if (this.bucketCountThresholds.getMinDocCount() > 0L && bucketDocCount == 0 || (long)bucketDocCount < this.bucketCountThresholds.getShardMinDocCount()) continue;
            if (spare == null) {
                spare = new SignificantStringTerms.Bucket(new BytesRef(), 0L, 0L, 0L, 0L, null);
            }
            spare.bucketOrd = bucketOrd;
            GlobalOrdinalsSignificantTermsAggregator.copy(this.globalOrds.lookupOrd(globalTermOrd), spare.termBytes);
            spare.subsetDf = bucketDocCount;
            spare.subsetSize = subsetSize;
            spare.supersetDf = this.termsAggFactory.getBackgroundFrequency(spare.termBytes);
            spare.supersetSize = supersetSize;
            spare.updateScore(this.termsAggFactory.getSignificanceHeuristic());
            spare = ordered.insertWithOverflow(spare);
        }
        InternalSignificantTerms.Bucket[] list = new InternalSignificantTerms.Bucket[ordered.size()];
        for (int i = ordered.size() - 1; i >= 0; --i) {
            SignificantStringTerms.Bucket bucket = (SignificantStringTerms.Bucket)ordered.pop();
            bucket.termBytes = BytesRef.deepCopyOf(bucket.termBytes);
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            list[i] = bucket;
        }
        return new SignificantStringTerms(subsetSize, supersetSize, this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.termsAggFactory.getSignificanceHeuristic(), Arrays.asList(list), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public SignificantStringTerms buildEmptyAggregation() {
        ContextIndexSearcher searcher = this.context.searchContext().searcher();
        IndexReader topReader = searcher.getIndexReader();
        int supersetSize = topReader.numDocs();
        return new SignificantStringTerms(0L, supersetSize, this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.termsAggFactory.getSignificanceHeuristic(), Collections.emptyList(), this.pipelineAggregators(), this.metaData());
    }

    @Override
    protected void doClose() {
        Releasables.close(this.termsAggFactory);
    }

    public static class WithHash
    extends GlobalOrdinalsSignificantTermsAggregator {
        private final LongHash bucketOrds;

        public WithHash(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.OrdinalsFilter includeExclude, AggregationContext aggregationContext, Aggregator parent, SignificantTermsAggregatorFactory termsAggFactory, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            super(name, factories, valuesSource, bucketCountThresholds, includeExclude, aggregationContext, parent, termsAggFactory, pipelineAggregators, metaData);
            this.bucketOrds = new LongHash(1L, aggregationContext.bigArrays());
        }

        @Override
        public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
            return new LeafBucketCollectorBase(super.getLeafCollector(ctx, sub), null){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    assert (bucket == 0L);
                    ++WithHash.this.numCollectedDocs;
                    WithHash.this.globalOrds.setDocument(doc);
                    int numOrds = WithHash.this.globalOrds.cardinality();
                    for (int i = 0; i < numOrds; ++i) {
                        long globalOrd = WithHash.this.globalOrds.ordAt(i);
                        long bucketOrd = WithHash.this.bucketOrds.add(globalOrd);
                        if (bucketOrd < 0L) {
                            bucketOrd = -1L - bucketOrd;
                            WithHash.this.collectExistingBucket(sub, doc, bucketOrd);
                            continue;
                        }
                        WithHash.this.collectBucket(sub, doc, bucketOrd);
                    }
                }
            };
        }

        @Override
        protected long getBucketOrd(long termOrd) {
            return this.bucketOrds.find(termOrd);
        }

        @Override
        protected void doClose() {
            Releasables.close(this.termsAggFactory, this.bucketOrds);
        }
    }
}

