/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support.format;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.lucene.spatial.util.GeoHashUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.ip.IpFieldMapper;
import org.joda.time.DateTimeZone;

public interface ValueFormatter
extends Streamable {
    public static final ValueFormatter RAW = new Raw();
    public static final ValueFormatter IPv4 = new IPv4Formatter();
    public static final ValueFormatter GEOHASH = new GeoHash();
    public static final ValueFormatter BOOLEAN = new BooleanFormatter();

    public byte id();

    public String format(long var1);

    public String format(double var1);

    public static class BooleanFormatter
    implements ValueFormatter {
        static final byte ID = 10;

        @Override
        public byte id() {
            return 10;
        }

        @Override
        public String format(long value) {
            return Boolean.valueOf(value != 0L).toString();
        }

        @Override
        public String format(double value) {
            return Boolean.valueOf(value != 0.0).toString();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }
    }

    public static class GeoHash
    implements ValueFormatter {
        static final byte ID = 8;

        @Override
        public byte id() {
            return 8;
        }

        @Override
        public String format(long value) {
            return GeoHashUtils.stringEncode(value);
        }

        @Override
        public String format(double value) {
            return this.format((long)value);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }
    }

    public static class IPv4Formatter
    implements ValueFormatter {
        static final byte ID = 6;

        @Override
        public byte id() {
            return 6;
        }

        @Override
        public String format(long value) {
            return IpFieldMapper.longToIp(value);
        }

        @Override
        public String format(double value) {
            return this.format((long)value);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }
    }

    public static abstract class Number
    implements ValueFormatter {
        NumberFormat format;

        Number() {
        }

        Number(NumberFormat format) {
            this.format = format;
        }

        @Override
        public String format(long value) {
            return this.format.format(value);
        }

        @Override
        public String format(double value) {
            return this.format.format(value);
        }

        public static class Pattern
        extends Number {
            private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols(Locale.ROOT);
            static final byte ID = 4;
            String pattern;

            Pattern() {
            }

            public Pattern(String pattern) {
                super(new DecimalFormat(pattern, SYMBOLS));
                this.pattern = pattern;
            }

            @Override
            public byte id() {
                return 4;
            }

            @Override
            public void readFrom(StreamInput in) throws IOException {
                this.pattern = in.readString();
                this.format = new DecimalFormat(this.pattern, SYMBOLS);
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.pattern);
            }
        }
    }

    public static class DateTime
    implements ValueFormatter {
        public static final ValueFormatter DEFAULT = new DateTime(DateFieldMapper.Defaults.DATE_TIME_FORMATTER);
        private DateTimeZone timeZone = DateTimeZone.UTC;
        static final byte ID = 2;
        FormatDateTimeFormatter formatter;

        public static DateTime mapper(DateFieldMapper.DateFieldType fieldType, DateTimeZone timezone) {
            return new DateTime(fieldType.dateTimeFormatter(), timezone);
        }

        DateTime() {
        }

        public DateTime(String format) {
            this.formatter = Joda.forPattern(format);
        }

        public DateTime(FormatDateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public DateTime(String format, DateTimeZone timezone) {
            this.formatter = Joda.forPattern(format);
            this.timeZone = timezone != null ? timezone : DateTimeZone.UTC;
        }

        public DateTime(FormatDateTimeFormatter formatter, DateTimeZone timezone) {
            this.formatter = formatter;
            this.timeZone = timezone != null ? timezone : DateTimeZone.UTC;
        }

        @Override
        public String format(long time) {
            return this.formatter.printer().withZone(this.timeZone).print(time);
        }

        @Override
        public String format(double value) {
            return this.format((long)value);
        }

        @Override
        public byte id() {
            return 2;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.formatter = Joda.forPattern(in.readString());
            this.timeZone = DateTimeZone.forID(in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.formatter.format());
            out.writeString(this.timeZone.getID());
        }
    }

    public static class Raw
    implements ValueFormatter {
        static final byte ID = 1;

        @Override
        public String format(long value) {
            return String.valueOf(value);
        }

        @Override
        public String format(double value) {
            return String.valueOf(value);
        }

        @Override
        public byte id() {
            return 1;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }
    }
}

